/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.changes;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.maven.plugin.changes.Action;
import org.apache.maven.plugin.changes.Release;
import org.apache.maven.plugin.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ChangesXML
extends DefaultHandler {
    private Action action;
    private List actionList;
    private Release release;
    private StringBuffer currentElement = new StringBuffer(1024);
    private String currentName;
    private List releaseList;
    private String author;
    private String authorEmail;
    private String title;

    public ChangesXML(File xmlPath, Log log) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(xmlPath, (DefaultHandler)this);
        }
        catch (Throwable t) {
            log.error((CharSequence)"An error occured when parsing the changes.xml file:", t);
        }
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthorEmail(String authorEmail) {
        this.authorEmail = authorEmail;
    }

    public String getAuthorEmail() {
        return this.authorEmail;
    }

    public void setReleaseList(List releaseList) {
        this.releaseList = releaseList;
    }

    public List getReleaseList() {
        return this.releaseList;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void characters(char[] buf, int offset, int len) throws SAXException {
        this.currentElement.append(buf, offset, len);
    }

    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        if (qName.equals("title")) {
            this.title = this.currentElement.toString().trim();
        } else if (qName.equals("author")) {
            this.author = this.currentElement.toString().trim();
        } else if (qName.equals("action")) {
            this.action.setAction(this.currentElement.toString().trim());
            this.actionList.add(this.action);
        } else if (qName.equals("release")) {
            this.release.setAction(this.actionList);
            this.releaseList.add(this.release);
        }
        this.currentElement.setLength(0);
    }

    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        if (qName.equals("title")) {
            this.title = "";
        } else if (qName.equals("author")) {
            this.authorEmail = attrs.getValue("email");
            this.author = "";
        } else if (qName.equals("body")) {
            this.releaseList = new ArrayList();
        } else if (qName.equals("release")) {
            this.release = new Release();
            this.release.setDateRelease(attrs.getValue("date"));
            this.release.setVersion(attrs.getValue("version"));
            this.release.setDescription(attrs.getValue("description"));
            this.actionList = new ArrayList();
        } else if (qName.equals("action")) {
            this.action = new Action();
            this.action.setDev(attrs.getValue("dev"));
            this.action.setDueTo(attrs.getValue("due-to"));
            this.action.setDueToEmail(attrs.getValue("due-to-email"));
            this.action.setType(attrs.getValue("type"));
            this.action.setIssue(attrs.getValue("issue"));
        }
        this.currentName = qName;
    }
}

