/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.jira;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.maven.plugin.changes.Action;
import org.apache.maven.plugin.changes.Release;
import org.apache.maven.plugin.jira.JiraIssue;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JiraXML
extends DefaultHandler {
    private List issueList;
    private StringBuffer currentElement = new StringBuffer(1024);
    private String currentParent = "";
    private JiraIssue issue;

    public JiraXML(File xmlPath) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        this.issueList = new ArrayList();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(xmlPath, (DefaultHandler)this);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        if (qName.equals("item")) {
            this.issue = new JiraIssue();
            this.currentParent = "item";
        }
    }

    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        if (qName.equals("item")) {
            this.issueList.add(this.issue);
            this.currentParent = "";
        } else if (qName.equals("key")) {
            this.issue.setKey(this.currentElement.toString().trim());
        } else if (qName.equals("summary")) {
            this.issue.setSummary(this.currentElement.toString().trim());
        } else if (qName.equals("type")) {
            this.issue.setType(this.currentElement.toString().trim());
        } else if (qName.equals("link") && this.currentParent.equals("item")) {
            this.issue.setLink(this.currentElement.toString().trim());
        } else if (qName.equals("priority")) {
            this.issue.setPriority(this.currentElement.toString().trim());
        } else if (qName.equals("status")) {
            this.issue.setStatus(this.currentElement.toString().trim());
        } else if (qName.equals("resolution")) {
            this.issue.setResolution(this.currentElement.toString().trim());
        } else if (qName.equals("assignee")) {
            this.issue.setAssignee(this.currentElement.toString().trim());
        } else if (qName.equals("reporter")) {
            this.issue.setReporter(this.currentElement.toString().trim());
        } else if (qName.equals("version")) {
            this.issue.setVersion(this.currentElement.toString().trim());
        } else if (qName.equals("fixVersion")) {
            this.issue.setFixVersion(this.currentElement.toString().trim());
        } else if (qName.equals("component")) {
            this.issue.setComponent(this.currentElement.toString().trim());
        } else if (qName.equals("comment")) {
            this.issue.addComment(this.currentElement.toString().trim());
        } else if (qName.equals("title") && this.currentParent.equals("item")) {
            this.issue.setTitle(this.currentElement.toString().trim());
        }
        this.currentElement.setLength(0);
    }

    public void characters(char[] buf, int offset, int len) throws SAXException {
        this.currentElement.append(buf, offset, len);
    }

    public List getIssueList() {
        return this.issueList;
    }

    public static List getReleases(List issues) {
        HashMap<String, Release> releasesMap = new HashMap<String, Release>();
        for (int i = 0; i < issues.size(); ++i) {
            JiraIssue issue = (JiraIssue)issues.get(i);
            if (issue.getFixVersion() == null) continue;
            Release release = (Release)releasesMap.get(issue.getFixVersion());
            if (release == null) {
                release = new Release();
                release.setVersion(issue.getFixVersion());
                releasesMap.put(issue.getFixVersion(), release);
            }
            Action action = JiraXML.createAction(issue);
            release.addAction(action);
        }
        ArrayList<Release> releasesList = new ArrayList<Release>();
        Iterator iterator = releasesMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Release o = (Release)iterator.next().getValue();
            releasesList.add(o);
        }
        return releasesList;
    }

    private static Action createAction(JiraIssue issue) {
        Action action = new Action();
        action.setIssue(issue.getKey());
        String type = "";
        if (issue.getType().equals("Bug")) {
            type = "fix";
        } else if (issue.getType().equals("New Feature")) {
            type = "add";
        } else if (issue.getType().equals("Improvement")) {
            type = "update";
        }
        action.setType(type);
        action.setDev(issue.getAssignee());
        action.setDueTo("");
        action.setAction(issue.getSummary());
        return action;
    }
}

