/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.resource.loader;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.apache.velocity.util.StringUtils;

public class ProjectResourceLoader
extends ResourceLoader {
    private Vector paths = null;
    private Hashtable templatePaths = new Hashtable();

    public void init(ExtendedProperties configuration) {
        this.rsvc.info((Object)"ProjectResourceLoader : initialization starting.");
        String separator = System.getProperty("file.separator");
        String path = System.getProperty("user.dir") + separator + "src" + separator + "main" + separator + "resources" + separator;
        this.rsvc.info((Object)("path :" + path));
        this.paths = new Vector();
        this.paths.add(path);
        int sz = this.paths.size();
        for (int i = 0; i < sz; ++i) {
            this.rsvc.info((Object)("ProjectResourceLoader : adding path '" + (String)this.paths.get(i) + "'"));
        }
        this.rsvc.info((Object)"ProjectResourceLoader : initialization complete.");
    }

    public synchronized InputStream getResourceStream(String templateName) throws ResourceNotFoundException {
        if (templateName == null || templateName.length() == 0) {
            throw new ResourceNotFoundException("Need to specify a file name or file path!");
        }
        String template = StringUtils.normalizePath((String)templateName);
        if (template == null || template.length() == 0) {
            String msg = "Project Resource loader error : argument " + template + " contains .. and may be trying to access " + "content outside of template root.  Rejected.";
            this.rsvc.error((Object)("ProjectResourceLoader : " + msg));
            throw new ResourceNotFoundException(msg);
        }
        if (template.startsWith("/")) {
            template = template.substring(1);
        }
        int size = this.paths.size();
        for (int i = 0; i < size; ++i) {
            String path = (String)this.paths.get(i);
            InputStream inputStream = this.findTemplate(path, template);
            if (inputStream == null) continue;
            this.templatePaths.put(templateName, path);
            return inputStream;
        }
        String msg = "ProjectResourceLoader Error: cannot find resource " + template;
        throw new ResourceNotFoundException(msg);
    }

    private InputStream findTemplate(String path, String template) {
        try {
            File file = new File(path, template);
            if (file.canRead()) {
                return new BufferedInputStream(new FileInputStream(file.getAbsolutePath()));
            }
            return null;
        }
        catch (FileNotFoundException fnfe) {
            return null;
        }
    }

    public boolean isSourceModified(Resource resource) {
        boolean modified = true;
        String fileName = resource.getName();
        String path = (String)this.templatePaths.get(fileName);
        File currentFile = null;
        for (int i = 0; currentFile == null && i < this.paths.size(); ++i) {
            String testPath = (String)this.paths.get(i);
            File testFile = new File(testPath, fileName);
            if (!testFile.canRead()) continue;
            currentFile = testFile;
        }
        File file = new File(path, fileName);
        if (currentFile != null && file.exists() && currentFile.equals(file) && file.canRead()) {
            modified = file.lastModified() != resource.getLastModified();
        }
        return modified;
    }

    public long getLastModified(Resource resource) {
        String path = (String)this.templatePaths.get(resource.getName());
        File file = new File(path, resource.getName());
        if (file.canRead()) {
            return file.lastModified();
        }
        return 0L;
    }
}

