/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.jira;

public class UrlBuilder {
    private static final String AMPERSAND = "&";
    private static final String QUESTION_MARK = "?";
    private StringBuilder query = new StringBuilder();

    public UrlBuilder(String url, String context) {
        this.query.append(url).append("/").append(context);
    }

    public UrlBuilder addParameter(String key, String value) {
        if (key != null && value != null) {
            if (this.query.toString().contains(QUESTION_MARK)) {
                this.query.append(AMPERSAND);
            } else {
                this.query.append(QUESTION_MARK);
            }
            this.query.append(key).append("=").append(value);
        }
        return this;
    }

    public UrlBuilder addParameter(String key, int value) {
        this.addParameter(key, String.valueOf(value));
        return this;
    }

    public String build() {
        return this.query.toString();
    }
}

