/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.jira;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.configuration.security.ProxyAuthorizationPolicy;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.jaxrs.client.ClientConfiguration;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.transports.http.configuration.ProxyServerType;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.issues.Issue;
import org.apache.maven.plugin.jira.AbstractJiraDownloader;
import org.apache.maven.plugin.jira.JiraHelper;
import org.apache.maven.plugin.jira.JqlQueryBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestJiraDownloader
extends AbstractJiraDownloader {
    private List<Issue> issueList;
    private JsonFactory jsonFactory = new MappingJsonFactory();
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private List<String> resolvedFixVersionIds = new ArrayList<String>();
    private List<String> resolvedStatusIds = new ArrayList<String>();
    private List<String> resolvedComponentIds = new ArrayList<String>();
    private List<String> resolvedTypeIds = new ArrayList<String>();
    private List<String> resolvedResolutionIds = new ArrayList<String>();
    private List<String> resolvedPriorityIds = new ArrayList<String>();
    private String jiraProject;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doExecute() throws Exception {
        Map<String, String> urlMap = JiraHelper.getJiraUrlAndProjectName(this.project.getIssueManagement().getUrl());
        String jiraUrl = urlMap.get("url");
        this.jiraProject = urlMap.get("project");
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(WebClient.class.getClassLoader());
            WebClient client = this.setupWebClient(jiraUrl);
            client.replacePath("/rest/api/2/serverInfo");
            client.accept(new String[]{"application/json"});
            Response siResponse = client.get();
            if (siResponse.getStatus() != Response.Status.OK.getStatusCode()) {
                throw new NoRest("This JIRA server does not support version 2 of the REST API, which maven-changes-plugin requires.");
            }
            this.doSessionAuth(client);
            this.resolveIds(client, this.jiraProject);
            String jqlQuery = new JqlQueryBuilder(this.log).urlEncode(false).project(this.jiraProject).fixVersion(this.getFixFor()).fixVersionIds(this.resolvedFixVersionIds).statusIds(this.resolvedStatusIds).priorityIds(this.resolvedPriorityIds).resolutionIds(this.resolvedResolutionIds).components(this.resolvedComponentIds).typeIds(this.resolvedTypeIds).sortColumnNames(this.sortColumnNames).build();
            StringWriter searchParamStringWriter = new StringWriter();
            JsonGenerator gen = this.jsonFactory.createGenerator((Writer)searchParamStringWriter);
            gen.writeStartObject();
            gen.writeStringField("jql", jqlQuery);
            gen.writeNumberField("maxResults", this.nbEntriesMax);
            gen.writeArrayFieldStart("fields");
            gen.writeString("*all");
            gen.writeEndArray();
            gen.writeEndObject();
            gen.close();
            client.replacePath("/rest/api/2/search");
            client.type(MediaType.APPLICATION_JSON_TYPE);
            client.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
            Response searchResponse = client.post((Object)searchParamStringWriter.toString());
            if (searchResponse.getStatus() != Response.Status.OK.getStatusCode()) {
                this.reportErrors(searchResponse);
            }
            JsonNode issueTree = this.getResponseTree(searchResponse);
            assert (issueTree.isObject());
            JsonNode issuesNode = issueTree.get("issues");
            assert (issuesNode.isArray());
            this.buildIssues(issuesNode, jiraUrl, this.jiraProject);
        }
        finally {
            Thread.currentThread().setContextClassLoader(ccl);
        }
    }

    private JsonNode getResponseTree(Response response) throws IOException {
        JsonParser jsonParser = this.jsonFactory.createParser((InputStream)response.getEntity());
        return (JsonNode)jsonParser.readValueAsTree();
    }

    private void reportErrors(Response resp) throws IOException, MojoExecutionException {
        if (MediaType.APPLICATION_JSON_TYPE.getType().equals(this.getResponseMediaType(resp).getType())) {
            JsonNode errorTree = this.getResponseTree(resp);
            assert (errorTree.isObject());
            JsonNode messages = errorTree.get("errorMessages");
            if (messages != null) {
                for (int mx = 0; mx < messages.size(); ++mx) {
                    this.getLog().error((CharSequence)messages.get(mx).asText());
                }
            } else {
                JsonNode message = errorTree.get("message");
                if (message != null) {
                    this.getLog().error((CharSequence)message.asText());
                }
            }
        }
        throw new MojoExecutionException(String.format("Failed to query issues; response %d", resp.getStatus()));
    }

    private void resolveIds(WebClient client, String jiraProject) throws IOException, MojoExecutionException, MojoFailureException {
        this.resolveList(this.resolvedComponentIds, client, "components", this.component, "/rest/api/2/project/{key}/components", jiraProject);
        this.resolveList(this.resolvedFixVersionIds, client, "fixVersions", this.fixVersionIds, "/rest/api/2/project/{key}/versions", jiraProject);
        this.resolveList(this.resolvedStatusIds, client, "status", this.statusIds, "/rest/api/2/status", new String[0]);
        this.resolveList(this.resolvedResolutionIds, client, "resolution", this.resolutionIds, "/rest/api/2/resolution", new String[0]);
        this.resolveList(this.resolvedTypeIds, client, "type", this.typeIds, "/rest/api/2/issuetype", new String[0]);
        this.resolveList(this.resolvedPriorityIds, client, "priority", this.priorityIds, "/rest/api/2/priority", new String[0]);
    }

    private void resolveList(List<String> targetList, WebClient client, String what, String input, String listRestUrlPattern, String ... listUrlArgs) throws IOException, MojoExecutionException, MojoFailureException {
        String[] pieces;
        if (input == null || input.length() == 0) {
            return;
        }
        if (listUrlArgs != null && listUrlArgs.length != 0) {
            client.replacePath("/");
            client.path(listRestUrlPattern, (Object[])listUrlArgs);
        } else {
            client.replacePath(listRestUrlPattern);
        }
        client.accept(new String[]{"application/json"});
        Response resp = client.get();
        if (resp.getStatus() != 200) {
            this.getLog().error((CharSequence)String.format("Could not get %s list from %s", what, listRestUrlPattern));
            this.reportErrors(resp);
        }
        JsonNode items = this.getResponseTree(resp);
        for (String item : pieces = input.split(",")) {
            targetList.add(this.resolveOneItem(items, what, item.trim()));
        }
    }

    private String resolveOneItem(JsonNode items, String what, String nameOrId) throws IOException, MojoExecutionException, MojoFailureException {
        for (int cx = 0; cx < items.size(); ++cx) {
            JsonNode item = items.get(cx);
            if (nameOrId.equals(item.get("id").asText())) {
                return nameOrId;
            }
            if (!nameOrId.equals(item.get("name").asText())) continue;
            return item.get("id").asText();
        }
        throw new MojoFailureException(String.format("Could not find %s %s.", what, nameOrId));
    }

    private MediaType getResponseMediaType(Response response) {
        String header = (String)response.getMetadata().getFirst((Object)"Content-Type");
        return header == null ? null : MediaType.valueOf((String)header);
    }

    private void buildIssues(JsonNode issuesNode, String jiraUrl, String jiraProject) {
        this.issueList = new ArrayList<Issue>();
        for (int ix = 0; ix < issuesNode.size(); ++ix) {
            JsonNode issueNode = issuesNode.get(ix);
            assert (issueNode.isObject());
            Issue issue = new Issue();
            JsonNode val = issueNode.get("id");
            if (val != null) {
                issue.setId(val.asText());
            }
            if ((val = issueNode.get("key")) != null) {
                issue.setKey(val.asText());
                issue.setLink(String.format("%s/browse/%s", jiraUrl, val.asText()));
            }
            JsonNode fieldsNode = issueNode.get("fields");
            val = fieldsNode.get("assignee");
            this.processAssignee(issue, val);
            val = fieldsNode.get("created");
            this.processCreated(issue, val);
            val = fieldsNode.get("comment");
            this.processComments(issue, val);
            val = fieldsNode.get("components");
            this.processComponents(issue, val);
            val = fieldsNode.get("fixVersions");
            this.processFixVersions(issue, val);
            val = fieldsNode.get("issuetype");
            this.processIssueType(issue, val);
            val = fieldsNode.get("priority");
            this.processPriority(issue, val);
            val = fieldsNode.get("reporter");
            this.processReporter(issue, val);
            val = fieldsNode.get("resolution");
            this.processResolution(issue, val);
            val = fieldsNode.get("status");
            this.processStatus(issue, val);
            val = fieldsNode.get("summary");
            if (val != null) {
                issue.setSummary(val.asText());
            }
            if ((val = fieldsNode.get("title")) != null) {
                issue.setTitle(val.asText());
            }
            val = fieldsNode.get("updated");
            this.processUpdated(issue, val);
            val = fieldsNode.get("versions");
            this.processVersions(issue, val);
            this.issueList.add(issue);
        }
    }

    private void processVersions(Issue issue, JsonNode val) {
        StringBuilder sb = new StringBuilder();
        if (val != null) {
            for (int vx = 0; vx < val.size(); ++vx) {
                sb.append(val.get(vx).get("name").asText());
                sb.append(", ");
            }
        }
        if (sb.length() > 0) {
            issue.setVersion(sb.substring(0, sb.length() - 2));
        }
    }

    private void processStatus(Issue issue, JsonNode val) {
        if (val != null) {
            issue.setStatus(val.get("name").asText());
        }
    }

    private void processPriority(Issue issue, JsonNode val) {
        if (val != null) {
            issue.setPriority(val.get("name").asText());
        }
    }

    private void processResolution(Issue issue, JsonNode val) {
        if (val != null) {
            issue.setResolution(val.get("name").asText());
        }
    }

    private String getPerson(JsonNode val) {
        JsonNode nameNode = val.get("displayName");
        if (nameNode == null) {
            nameNode = val.get("name");
        }
        if (nameNode != null) {
            return nameNode.asText();
        }
        return null;
    }

    private void processAssignee(Issue issue, JsonNode val) {
        String text;
        if (val != null && (text = this.getPerson(val)) != null) {
            issue.setAssignee(text);
        }
    }

    private void processReporter(Issue issue, JsonNode val) {
        String text;
        if (val != null && (text = this.getPerson(val)) != null) {
            issue.setReporter(text);
        }
    }

    private void processCreated(Issue issue, JsonNode val) {
        if (val != null) {
            try {
                issue.setCreated(this.parseDate(val));
            }
            catch (ParseException e) {
                this.getLog().warn((CharSequence)("Invalid created date " + val.asText()));
            }
        }
    }

    private void processUpdated(Issue issue, JsonNode val) {
        if (val != null) {
            try {
                issue.setUpdated(this.parseDate(val));
            }
            catch (ParseException e) {
                this.getLog().warn((CharSequence)("Invalid updated date " + val.asText()));
            }
        }
    }

    private Date parseDate(JsonNode val) throws ParseException {
        return this.dateFormat.parse(val.asText());
    }

    private void processFixVersions(Issue issue, JsonNode val) {
        if (val != null) {
            assert (val.isArray());
            for (int vx = 0; vx < val.size(); ++vx) {
                JsonNode fvNode = val.get(vx);
                issue.addFixVersion(fvNode.get("name").asText());
            }
        }
    }

    private void processComments(Issue issue, JsonNode val) {
        if (val != null) {
            JsonNode commentsArray = val.get("comments");
            for (int cx = 0; cx < commentsArray.size(); ++cx) {
                JsonNode cnode = commentsArray.get(cx);
                issue.addComment(cnode.get("body").asText());
            }
        }
    }

    private void processComponents(Issue issue, JsonNode val) {
        if (val != null) {
            assert (val.isArray());
            for (int cx = 0; cx < val.size(); ++cx) {
                JsonNode cnode = val.get(cx);
                issue.addComponent(cnode.get("name").asText());
            }
        }
    }

    private void processIssueType(Issue issue, JsonNode val) {
        if (val != null) {
            issue.setType(val.get("name").asText());
        }
    }

    private void doSessionAuth(WebClient client) throws IOException, MojoExecutionException, NoRest {
        if (this.jiraUser != null) {
            client.replacePath("/rest/auth/1/session");
            client.type(MediaType.APPLICATION_JSON_TYPE);
            StringWriter jsWriter = new StringWriter();
            JsonGenerator gen = this.jsonFactory.createGenerator((Writer)jsWriter);
            gen.writeStartObject();
            gen.writeStringField("username", this.jiraUser);
            gen.writeStringField("password", this.jiraPassword);
            gen.writeEndObject();
            gen.close();
            Response authRes = client.post((Object)jsWriter.toString());
            if (authRes.getStatus() != Response.Status.OK.getStatusCode()) {
                if (authRes.getStatus() != 401 && authRes.getStatus() != 403) {
                    throw new NoRest();
                }
                throw new MojoExecutionException(String.format("Authentication failure status %d.", authRes.getStatus()));
            }
        }
    }

    private WebClient setupWebClient(String jiraUrl) {
        WebClient client = WebClient.create((String)jiraUrl);
        ClientConfiguration clientConfiguration = WebClient.getConfig((Object)client);
        HTTPConduit http = clientConfiguration.getHttpConduit();
        clientConfiguration.getRequestContext().put(Message.MAINTAIN_SESSION, Boolean.TRUE);
        if (this.getLog().isDebugEnabled()) {
            clientConfiguration.getInInterceptors().add(new LoggingInInterceptor());
            clientConfiguration.getOutInterceptors().add(new LoggingOutInterceptor());
        }
        HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();
        this.getLog().debug((CharSequence)("RestJiraDownloader: connectionTimeout: " + this.connectionTimeout));
        httpClientPolicy.setConnectionTimeout((long)this.connectionTimeout);
        httpClientPolicy.setAllowChunking(false);
        this.getLog().debug((CharSequence)("RestJiraDownloader: receiveTimout: " + this.receiveTimout));
        httpClientPolicy.setReceiveTimeout((long)this.receiveTimout);
        this.getProxyInfo(jiraUrl);
        if (this.proxyHost != null) {
            this.getLog().debug((CharSequence)("Using proxy: " + this.proxyHost + " at port " + this.proxyPort));
            httpClientPolicy.setProxyServer(this.proxyHost);
            httpClientPolicy.setProxyServerPort(this.proxyPort);
            httpClientPolicy.setProxyServerType(ProxyServerType.HTTP);
            if (this.proxyUser != null) {
                ProxyAuthorizationPolicy proxyAuthorizationPolicy = new ProxyAuthorizationPolicy();
                proxyAuthorizationPolicy.setAuthorizationType("Basic");
                proxyAuthorizationPolicy.setUserName(this.proxyUser);
                proxyAuthorizationPolicy.setPassword(this.proxyPass);
                http.setProxyAuthorization(proxyAuthorizationPolicy);
            }
        }
        if (this.webUser != null) {
            AuthorizationPolicy authPolicy = new AuthorizationPolicy();
            authPolicy.setAuthorizationType("Basic");
            authPolicy.setUserName(this.webUser);
            authPolicy.setPassword(this.webPassword);
            http.setAuthorization(authPolicy);
        }
        http.setClient(httpClientPolicy);
        return client;
    }

    @Override
    public List<Issue> getIssueList() throws MojoExecutionException {
        return this.issueList;
    }

    public static class NoRest
    extends Exception {
        public NoRest() {
        }

        public NoRest(String message) {
            super(message);
        }
    }
}

