/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.changes;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.changes.ChangesXMLRuntimeException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.changes.model.Body;
import org.apache.maven.plugins.changes.model.ChangesDocument;
import org.apache.maven.plugins.changes.model.Properties;
import org.apache.maven.plugins.changes.model.Release;
import org.apache.maven.plugins.changes.model.io.xpp3.ChangesXpp3Reader;
import org.codehaus.plexus.util.IOUtil;

public class ChangesXML {
    private List<Release> releaseList;
    private String author;
    private String title;
    private String authorEmail;
    private ChangesDocument changesDocument;

    public ChangesXML(File xmlPath, Log log) throws ChangesXMLRuntimeException {
        FileInputStream fileInputStream;
        block9: {
            if (xmlPath == null || !xmlPath.exists()) {
                log.error((CharSequence)"changes xml file is null or not exists ");
                return;
            }
            fileInputStream = null;
            ChangesXpp3Reader reader = new ChangesXpp3Reader();
            fileInputStream = new FileInputStream(xmlPath);
            this.changesDocument = reader.read(fileInputStream, false);
            fileInputStream.close();
            fileInputStream = null;
            if (this.changesDocument != null) break block9;
            log.error((CharSequence)("Cannot build Changes Report from file: " + xmlPath.getPath()));
            IOUtil.close((InputStream)fileInputStream);
            return;
        }
        try {
            Body body;
            Properties properties = this.changesDocument.getProperties();
            if (properties != null) {
                if (properties.getAuthor() != null) {
                    this.author = properties.getAuthor().getName();
                    this.authorEmail = properties.getAuthor().getName();
                }
                this.title = properties.getTitle();
            }
            if ((body = this.changesDocument.getBody()) != null) {
                this.releaseList = body.getReleases();
            }
        }
        catch (Throwable e) {
            try {
                log.error((CharSequence)"An error occurred when parsing the changes.xml file: ", e);
                throw new ChangesXMLRuntimeException("An error occurred when parsing the changes.xml file", e);
            }
            catch (Throwable throwable) {
                IOUtil.close(fileInputStream);
                throw throwable;
            }
        }
        IOUtil.close((InputStream)fileInputStream);
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setReleaseList(List<Release> releaseList) {
        this.releaseList = releaseList;
    }

    public List<Release> getReleaseList() {
        return this.releaseList == null ? Collections.emptyList() : this.releaseList;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public ChangesDocument getChangesDocument() {
        return this.changesDocument;
    }

    public String getAuthorEmail() {
        return this.authorEmail;
    }

    public void setAuthorEmail(String authorEmail) {
        this.authorEmail = authorEmail;
    }
}

