/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.jira;

import java.io.File;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.plugin.changes.AbstractChangesReport;
import org.apache.maven.plugin.jira.JiraDownloader;
import org.apache.maven.plugin.jira.JiraReportGenerator;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.settings.Settings;

public class JiraMojo
extends AbstractChangesReport {
    private File jiraXmlPath;
    private Settings settings;
    private int maxEntries;
    private String filter;
    private String fixVersionIds;
    private String statusIds;
    private String resolutionIds;
    private String priorityIds;
    private String component;
    private String typeIds;
    private String columnNames;
    private String sortColumnNames;
    private String jiraUser;
    private String jiraPassword;
    private String webUser;
    private String webPassword;
    private boolean onlyCurrentVersion;

    public boolean canGenerateReport() {
        return this.validateIfIssueManagementComplete();
    }

    public void executeReport(Locale locale) throws MavenReportException {
        JiraDownloader jiraDownloader = new JiraDownloader();
        this.setJiraDownloaderParameters(jiraDownloader);
        try {
            jiraDownloader.doExecute();
            if (this.jiraXmlPath.isFile()) {
                JiraReportGenerator report = new JiraReportGenerator(this.jiraXmlPath, this.columnNames, this.project.getVersion(), this.onlyCurrentVersion);
                report.doGenerateReport(this.getBundle(locale), this.getSink(), this.getLog());
            } else {
                JiraReportGenerator report = new JiraReportGenerator();
                report.doGenerateEmptyReport(this.getBundle(locale), this.getSink());
            }
        }
        catch (MavenReportException mre) {
            throw mre;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.jira.name");
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.jira.description");
    }

    public String getOutputName() {
        return "jira-report";
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("jira-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    private void setJiraDownloaderParameters(JiraDownloader jira) {
        jira.setLog(this.getLog());
        jira.setMavenProject(this.project);
        jira.setOutput(this.jiraXmlPath);
        jira.setNbEntries(this.maxEntries);
        jira.setComponent(this.component);
        jira.setFixVersionIds(this.fixVersionIds);
        jira.setStatusIds(this.statusIds);
        jira.setResolutionIds(this.resolutionIds);
        jira.setPriorityIds(this.priorityIds);
        jira.setSortColumnNames(this.sortColumnNames);
        jira.setFilter(this.filter);
        jira.setJiraUser(this.jiraUser);
        jira.setJiraPassword(this.jiraPassword);
        jira.setTypeIds(this.typeIds);
        jira.setWebUser(this.webUser);
        jira.setWebPassword(this.webPassword);
        jira.setSettings(this.settings);
    }

    private boolean validateIfIssueManagementComplete() {
        if (this.project.getIssueManagement() == null) {
            this.getLog().error((CharSequence)"No Issue Management set. No JIRA Report will be generated.");
            return false;
        }
        if (this.project.getIssueManagement().getUrl() == null || this.project.getIssueManagement().getUrl().trim().equals("")) {
            this.getLog().error((CharSequence)"No URL set in Issue Management. No JIRA Report will be generated.");
            return false;
        }
        if (this.project.getIssueManagement().getSystem() != null && !this.project.getIssueManagement().getSystem().equalsIgnoreCase("jira")) {
            this.getLog().error((CharSequence)"The JIRA Report only supports JIRA.  No JIRA Report will be generated.");
            return false;
        }
        return true;
    }
}

