/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.changes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.changes.model.Action;
import org.apache.maven.plugins.changes.model.Release;

public class ReleaseUtils {
    private static final String SNAPSHOT_SUFFIX = "-SNAPSHOT";
    private Log log;

    public ReleaseUtils(Log log) {
        this.log = log;
    }

    public Release getLatestRelease(List releases, String pomVersion) throws MojoExecutionException {
        if (pomVersion != null && pomVersion.endsWith(SNAPSHOT_SUFFIX)) {
            pomVersion = pomVersion.substring(0, pomVersion.length() - SNAPSHOT_SUFFIX.length());
        }
        this.getLog().debug((CharSequence)("Found " + releases.size() + " releases."));
        Release release = this.getRelease(releases, pomVersion);
        if (release == null) {
            throw new MojoExecutionException("Couldn't find the release '" + pomVersion + "' among the supplied releases.");
        }
        return release;
    }

    private Log getLog() {
        return this.log;
    }

    protected Release getRelease(List releases, String version) {
        Release release = null;
        for (int i = 0; i < releases.size(); ++i) {
            release = (Release)releases.get(i);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("The release: " + release.getVersion() + " has " + release.getActions().size() + " actions."));
            }
            if (release.getVersion() == null || !release.getVersion().equals(version)) continue;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Found the correct release: " + release.getVersion()));
                this.logRelease(release);
            }
            return release;
        }
        return null;
    }

    protected void logRelease(Release release) {
        Iterator iterator = release.getActions().iterator();
        while (iterator.hasNext()) {
            Action action = (Action)iterator.next();
            this.getLog().debug((CharSequence)("o " + action.getType()));
            this.getLog().debug((CharSequence)("issue : " + action.getIssue()));
            this.getLog().debug((CharSequence)("action : " + action.getAction()));
            this.getLog().debug((CharSequence)("dueTo : " + action.getDueTo()));
        }
    }

    public List mergeReleases(List firstReleases, List secondReleases) {
        if (firstReleases == null && secondReleases == null) {
            return Collections.EMPTY_LIST;
        }
        if (firstReleases == null) {
            return secondReleases;
        }
        if (secondReleases == null) {
            return firstReleases;
        }
        ArrayList<Release> mergedReleases = new ArrayList<Release>();
        Iterator iterator = firstReleases.iterator();
        while (iterator.hasNext()) {
            Release firstRelease = (Release)iterator.next();
            Release secondRelease = this.getRelease(secondReleases, firstRelease.getVersion());
            if (secondRelease != null && secondRelease.getActions() != null) {
                firstRelease.getActions().addAll(secondRelease.getActions());
            }
            mergedReleases.add(firstRelease);
        }
        iterator = secondReleases.iterator();
        while (iterator.hasNext()) {
            Release secondRelease = (Release)iterator.next();
            Release mergedRelease = this.getRelease(mergedReleases, secondRelease.getVersion());
            if (mergedRelease != null) continue;
            mergedReleases.add(secondRelease);
        }
        return mergedReleases;
    }
}

