/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.jira;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.changes.AbstractChangesReport;
import org.apache.maven.plugin.changes.ProjectUtils;
import org.apache.maven.plugin.issues.IssueUtils;
import org.apache.maven.plugin.issues.IssuesReportGenerator;
import org.apache.maven.plugin.issues.IssuesReportHelper;
import org.apache.maven.plugin.jira.JiraDownloader;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.settings.Settings;

public class JiraMojo
extends AbstractChangesReport {
    private static final Map JIRA_COLUMNS = new HashMap(16);
    private String columnNames;
    private String component;
    private String filter;
    private String fixVersionIds;
    private String jiraDatePattern;
    private String jiraPassword;
    private String jiraUser;
    private File jiraXmlPath;
    private int maxEntries;
    private boolean onlyCurrentVersion;
    private String priorityIds;
    private String resolutionIds;
    private Settings settings;
    private String sortColumnNames;
    private String statusIds;
    private String typeIds;
    private String versionPrefix;
    private String webPassword;
    private String webUser;

    public boolean canGenerateReport() {
        return ProjectUtils.validateIfIssueManagementComplete(this.project, "JIRA", "JIRA Report", this.getLog());
    }

    public void executeReport(Locale locale) throws MavenReportException {
        List columnIds = IssuesReportHelper.getColumnIds(this.columnNames, JIRA_COLUMNS);
        if (columnIds.isEmpty()) {
            throw new MavenReportException("maven-changes-plugin: None of the configured columnNames '" + this.columnNames + "' are valid.");
        }
        try {
            JiraDownloader issueDownloader = new JiraDownloader();
            this.configureIssueDownloader(issueDownloader);
            issueDownloader.doExecute();
            List issueList = issueDownloader.getIssueList();
            if (StringUtils.isNotEmpty((String)this.versionPrefix)) {
                int originalNumberOfIssues = issueList.size();
                issueList = IssueUtils.filterIssuesWithVersionPrefix(issueList, this.versionPrefix);
                this.getLog().debug((CharSequence)("Filtered out " + issueList.size() + " issues of " + originalNumberOfIssues + " that matched the versionPrefix '" + this.versionPrefix + "'."));
            }
            if (this.onlyCurrentVersion) {
                String version = (this.versionPrefix == null ? "" : this.versionPrefix) + this.project.getVersion();
                issueList = IssueUtils.getIssuesForVersion(issueList, version);
                this.getLog().info((CharSequence)"The JIRA Report will contain issues only for the current version.");
            }
            IssuesReportGenerator report = new IssuesReportGenerator(IssuesReportHelper.toIntArray(columnIds));
            if (issueList.isEmpty()) {
                report.doGenerateEmptyReport(this.getBundle(locale), this.getSink());
            } else {
                report.doGenerateReport(this.getBundle(locale), this.getSink(), issueList);
            }
        }
        catch (Exception e) {
            this.getLog().warn((Throwable)e);
        }
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.issues.description");
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.issues.name");
    }

    public String getOutputName() {
        return "jira-report";
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("jira-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    private void configureIssueDownloader(JiraDownloader issueDownloader) {
        issueDownloader.setLog(this.getLog());
        issueDownloader.setMavenProject(this.project);
        issueDownloader.setOutput(this.jiraXmlPath);
        issueDownloader.setNbEntries(this.maxEntries);
        issueDownloader.setComponent(this.component);
        issueDownloader.setFixVersionIds(this.fixVersionIds);
        issueDownloader.setStatusIds(this.statusIds);
        issueDownloader.setResolutionIds(this.resolutionIds);
        issueDownloader.setPriorityIds(this.priorityIds);
        issueDownloader.setSortColumnNames(this.sortColumnNames);
        issueDownloader.setFilter(this.filter);
        issueDownloader.setJiraDatePattern(this.jiraDatePattern);
        issueDownloader.setJiraUser(this.jiraUser);
        issueDownloader.setJiraPassword(this.jiraPassword);
        issueDownloader.setTypeIds(this.typeIds);
        issueDownloader.setWebUser(this.webUser);
        issueDownloader.setWebPassword(this.webPassword);
        issueDownloader.setSettings(this.settings);
    }

    static {
        JIRA_COLUMNS.put("Assignee", new Integer(0));
        JIRA_COLUMNS.put("Component", new Integer(1));
        JIRA_COLUMNS.put("Created", new Integer(2));
        JIRA_COLUMNS.put("Fix Version", new Integer(3));
        JIRA_COLUMNS.put("Id", new Integer(4));
        JIRA_COLUMNS.put("Key", new Integer(5));
        JIRA_COLUMNS.put("Priority", new Integer(6));
        JIRA_COLUMNS.put("Reporter", new Integer(7));
        JIRA_COLUMNS.put("Resolution", new Integer(8));
        JIRA_COLUMNS.put("Status", new Integer(9));
        JIRA_COLUMNS.put("Summary", new Integer(10));
        JIRA_COLUMNS.put("Type", new Integer(11));
        JIRA_COLUMNS.put("Updated", new Integer(12));
        JIRA_COLUMNS.put("Version", new Integer(13));
    }
}

