/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.changes;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.changes.schema.ChangesSchemaValidator;
import org.apache.maven.plugin.changes.schema.SchemaValidatorException;
import org.apache.maven.plugin.changes.schema.XmlValidationHandler;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="changes-validate", threadSafe=true)
public class ChangesValidatorMojo
extends AbstractMojo {
    @Component(role=ChangesSchemaValidator.class, hint="default")
    private ChangesSchemaValidator changesSchemaValidator;
    @Parameter(property="changes.xsdVersion", defaultValue="1.0.0")
    private String changesXsdVersion;
    @Parameter(property="changes.validate.failed", defaultValue="false")
    private boolean failOnError;
    @Parameter(property="changes.xmlPath", defaultValue="src/changes/changes.xml")
    private File xmlPath;

    public void execute() throws MojoExecutionException, MojoFailureException {
        block5: {
            if (!this.xmlPath.exists()) {
                this.getLog().warn((CharSequence)("changes.xml file " + this.xmlPath.getAbsolutePath() + " does not exist."));
                return;
            }
            try {
                boolean hasErrors;
                XmlValidationHandler xmlValidationHandler = this.changesSchemaValidator.validateXmlWithSchema(this.xmlPath, this.changesXsdVersion, this.failOnError);
                boolean bl = hasErrors = !xmlValidationHandler.getErrors().isEmpty();
                if (hasErrors) {
                    this.logSchemaValidation(xmlValidationHandler.getErrors());
                    if (this.failOnError) {
                        throw new MojoExecutionException("changes.xml file " + this.xmlPath.getAbsolutePath() + " is not valid, see previous errors.");
                    }
                    this.getLog().info((CharSequence)" skip previous validation errors due to failOnError=false.");
                }
            }
            catch (SchemaValidatorException e) {
                if (!this.failOnError) break block5;
                throw new MojoExecutionException("failed to validate changes.xml file " + this.xmlPath.getAbsolutePath() + ": " + e.getMessage(), (Exception)e);
            }
        }
    }

    private void logSchemaValidation(List<SAXParseException> errors) {
        this.getLog().warn((CharSequence)("failed to validate changes.xml file " + this.xmlPath.getAbsolutePath()));
        this.getLog().warn((CharSequence)"validation errors: ");
        for (SAXParseException error : errors) {
            this.getLog().warn((CharSequence)error.getMessage());
        }
    }
}

