/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.issues;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.bidimap.DualHashBidiMap;
import org.apache.maven.plugin.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IssuesReportHelper {
    public static final int COLUMN_ASSIGNEE = 0;
    public static final int COLUMN_COMPONENT = 1;
    public static final int COLUMN_CREATED = 2;
    public static final int COLUMN_FIX_VERSION = 3;
    public static final int COLUMN_ID = 4;
    public static final int COLUMN_KEY = 5;
    public static final int COLUMN_PRIORITY = 6;
    public static final int COLUMN_REPORTER = 7;
    public static final int COLUMN_RESOLUTION = 8;
    public static final int COLUMN_STATUS = 9;
    public static final int COLUMN_SUMMARY = 10;
    public static final int COLUMN_TYPE = 11;
    public static final int COLUMN_UPDATED = 12;
    public static final int COLUMN_VERSION = 13;

    public static List<Integer> getColumnIds(String columnNames, Map<String, Integer> allColumns) {
        return IssuesReportHelper.getColumnIds(columnNames, allColumns, null, null);
    }

    public static List<Integer> getColumnIds(String columnNames, Map<String, Integer> allColumns, Map<String, Integer> deprecatedColumns, Log log) {
        DualHashBidiMap bidiColumns = null;
        ArrayList<Integer> columnIds = new ArrayList<Integer>();
        String[] columnNamesArray = columnNames.split(",");
        if (deprecatedColumns != null) {
            bidiColumns = new DualHashBidiMap(allColumns);
        }
        for (int i = 0; i < columnNamesArray.length; ++i) {
            String columnName = columnNamesArray[i].trim();
            if (allColumns.containsKey(columnName)) {
                columnIds.add(allColumns.get(columnName));
                continue;
            }
            if (deprecatedColumns == null || !deprecatedColumns.containsKey(columnName)) continue;
            Integer columnId = deprecatedColumns.get(columnName);
            columnIds.add(columnId);
            if (log == null) continue;
            log.warn((CharSequence)("The columnName '" + columnName + "' has been deprecated." + " Please use " + "the columnName '" + bidiColumns.getKey((Object)columnId) + "' instead."));
        }
        return columnIds;
    }

    public static String printValues(List<String> values) {
        StringBuffer sb = new StringBuffer();
        if (values != null) {
            Iterator<String> iterator = values.iterator();
            while (iterator.hasNext()) {
                String value = iterator.next();
                sb.append(value);
                if (!iterator.hasNext()) continue;
                sb.append(", ");
            }
        }
        return sb.toString();
    }

    public static int[] toIntArray(List<Integer> list) {
        int[] intArray = new int[list.size()];
        for (int j = 0; j < intArray.length; ++j) {
            intArray[j] = list.get(j);
        }
        return intArray;
    }
}

