/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.jira;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.issues.Issue;
import org.apache.maven.plugin.jira.JiraHelper;
import org.apache.maven.plugin.jira.JiraXML;
import org.apache.maven.plugin.jira.JqlQueryBuilder;
import org.apache.maven.plugin.jira.ParameterQueryBuilder;
import org.apache.maven.plugin.jira.UrlBuilder;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJiraDownloader {
    private static final String UTF_8 = "UTF-8";
    protected Log log;
    private File output;
    private int nbEntriesMax;
    private String filter;
    private String fixVersionIds;
    private String statusIds;
    private String resolutionIds;
    private String priorityIds;
    private String component;
    private String typeIds;
    private String sortColumnNames;
    private String jiraUser;
    private String jiraPassword;
    private String webUser;
    private String webPassword;
    private MavenProject project;
    private Settings settings;
    private boolean useJql;
    private boolean onlyCurrentVersion;
    private String versionPrefix;
    protected String jiraDatePattern;

    public void doExecute() throws Exception {
        try {
            HttpClient client = new HttpClient();
            HttpClientParams clientParams = client.getParams();
            clientParams.setBooleanParameter("http.protocol.allow-circular-redirects", true);
            clientParams.setCookiePolicy("compatibility");
            HttpState state = new HttpState();
            HostConfiguration hc = new HostConfiguration();
            client.setHostConfiguration(hc);
            client.setState(state);
            String fullUrl = null;
            fullUrl = this.useJql ? this.getJqlQueryURL() : this.getParameterBasedQueryURL(client);
            String baseUrl = JiraHelper.getBaseUrl(fullUrl);
            this.getLog().debug((CharSequence)("JIRA lives at: " + baseUrl));
            this.determineProxy(baseUrl, client);
            this.prepareBasicAuthentication(client);
            boolean jiraAuthenticationSuccessful = false;
            if (this.isJiraAuthenticationConfigured()) {
                jiraAuthenticationSuccessful = this.doJiraAuthentication(client, baseUrl);
            }
            if (this.isJiraAuthenticationConfigured() && jiraAuthenticationSuccessful || !this.isJiraAuthenticationConfigured()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((CharSequence)("download jira issues from url " + fullUrl));
                }
                this.download(client, fullUrl);
            }
        }
        catch (Exception e) {
            if (this.project.getIssueManagement() != null) {
                this.getLog().error((CharSequence)("Error accessing " + this.project.getIssueManagement().getUrl()), (Throwable)e);
            }
            this.getLog().error((CharSequence)"Error accessing mock project issues", (Throwable)e);
        }
    }

    private String getJqlQueryURL() {
        Map<String, String> urlMap = JiraHelper.getJiraUrlAndProjectName(this.project.getIssueManagement().getUrl());
        String jiraUrl = urlMap.get("url");
        String jiraProject = urlMap.get("project");
        if (jiraProject == null) {
            throw new RuntimeException("The issue management URL in the POM does not include a JIRA project name");
        }
        String jqlQuery = new JqlQueryBuilder(this.log).project(jiraProject).fixVersion(this.getFixFor()).fixVersionIds(this.fixVersionIds).statusIds(this.statusIds).priorityIds(this.priorityIds).resolutionIds(this.resolutionIds).components(this.component).typeIds(this.typeIds).sortColumnNames(this.sortColumnNames).build();
        String url = new UrlBuilder(jiraUrl, "sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml").addParameter("tempMax", this.nbEntriesMax).addParameter("reset", "true").addParameter("jqlQuery", jqlQuery).build();
        return url;
    }

    private String getParameterBasedQueryURL(HttpClient client) {
        String createdFilter;
        Map<String, String> urlMap = JiraHelper.getJiraUrlAndProjectId(this.project.getIssueManagement().getUrl());
        String jiraUrl = urlMap.get("url");
        String jiraId = urlMap.get("id");
        if (jiraId == null || jiraId.length() == 0) {
            this.log.debug((CharSequence)("The JIRA URL " + this.project.getIssueManagement().getUrl() + " doesn't include a pid, trying to extract it from JIRA."));
            jiraId = JiraHelper.getPidFromJira(this.log, this.project.getIssueManagement().getUrl(), client);
        }
        if (jiraId == null) {
            throw new RuntimeException("The issue management URL in the POM does not include a pid, and it was not possible to extract it from the page at that URL.");
        }
        String fullURL = jiraUrl + "/secure/IssueNavigator.jspa?view=rss&pid=" + jiraId;
        if (this.getFixFor() != null) {
            fullURL = fullURL + "&fixfor=" + this.getFixFor();
        }
        if ((createdFilter = new ParameterQueryBuilder(this.log).fixVersionIds(this.fixVersionIds).statusIds(this.statusIds).priorityIds(this.priorityIds).resolutionIds(this.resolutionIds).components(this.component).typeIds(this.typeIds).sortColumnNames(this.sortColumnNames).filter(this.filter).build()).charAt(0) != '&') {
            fullURL = fullURL + "&";
        }
        fullURL = fullURL + createdFilter;
        fullURL = fullURL + "&tempMax=" + this.nbEntriesMax + "&reset=true&decorator=none";
        return fullURL;
    }

    protected String getFixFor() {
        if (this.onlyCurrentVersion && this.useJql) {
            String version = (this.versionPrefix == null ? "" : this.versionPrefix) + this.project.getVersion();
            if (version != null && version.endsWith("-SNAPSHOT")) {
                return version.substring(0, version.length() - "-SNAPSHOT".length());
            }
            return version;
        }
        return null;
    }

    private void prepareBasicAuthentication(HttpClient client) {
        if (this.webUser != null && this.webUser.length() > 0) {
            client.getParams().setAuthenticationPreemptive(true);
            UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(this.webUser, this.webPassword);
            this.getLog().debug((CharSequence)("Using username: " + this.webUser + " for Basic Authentication."));
            client.getState().setCredentials(new AuthScope(null, -1, null, AuthScope.ANY_SCHEME), (Credentials)defaultcreds);
        }
    }

    private boolean doJiraAuthentication(HttpClient client, String jiraUrl) {
        String loginUrl = null;
        StringBuffer loginLink = new StringBuffer(jiraUrl);
        loginLink.append("/login.jsp?os_destination=/secure/");
        try {
            loginLink.append("&os_username=").append(URLEncoder.encode(this.jiraUser, UTF_8));
            String password = null;
            if (this.jiraPassword != null) {
                password = StringUtils.repeat((String)"*", (int)this.jiraPassword.length());
            }
            this.getLog().debug((CharSequence)("Login URL: " + loginLink + "&os_password=" + password));
            loginLink.append("&os_password=").append(URLEncoder.encode(this.jiraPassword, UTF_8));
            loginUrl = loginLink.toString();
            GetMethod loginGet = new GetMethod(loginUrl);
            client.executeMethod((HttpMethod)loginGet);
            if (this.loginSucceeded(loginGet)) {
                this.getLog().debug((CharSequence)"Successfully logged in into JIRA.");
                return true;
            }
            this.getLog().warn((CharSequence)"Was unable to login into JIRA: wrong username and/or password.");
        }
        catch (Exception e) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().error((CharSequence)"Error trying to login into JIRA.", (Throwable)e);
            }
            this.getLog().error((CharSequence)("Error trying to login into JIRA. Cause is: " + e.getLocalizedMessage()));
        }
        return false;
    }

    private boolean isJiraAuthenticationConfigured() {
        return this.jiraUser != null && this.jiraUser.length() > 0 && this.jiraPassword != null;
    }

    private boolean loginSucceeded(GetMethod loginGet) throws IOException {
        String loginFailureResponse = "your username and password are incorrect";
        return loginGet.getResponseBodyAsString().indexOf("your username and password are incorrect") == -1;
    }

    private void determineProxy(String jiraUrl, HttpClient client) {
        Proxy proxy = null;
        String proxyHost = null;
        int proxyPort = 0;
        String proxyUser = null;
        String proxyPass = null;
        if (this.project == null) {
            this.getLog().error((CharSequence)"No project set. No proxy info available.");
            return;
        }
        if (this.settings != null) {
            proxy = this.settings.getActiveProxy();
        }
        if (proxy != null) {
            ProxyInfo proxyInfo = new ProxyInfo();
            proxyInfo.setNonProxyHosts(proxy.getNonProxyHosts());
            URL url = null;
            try {
                url = new URL(jiraUrl);
            }
            catch (MalformedURLException e) {
                this.getLog().error((CharSequence)("Invalid JIRA URL: " + jiraUrl + ". " + e.getMessage()));
            }
            String jiraHost = null;
            if (url != null) {
                jiraHost = url.getHost();
            }
            if (JiraHelper.validateNonProxyHosts(proxyInfo, jiraHost)) {
                return;
            }
            proxyHost = this.settings.getActiveProxy().getHost();
            proxyPort = this.settings.getActiveProxy().getPort();
            proxyUser = this.settings.getActiveProxy().getUsername();
            proxyPass = this.settings.getActiveProxy().getPassword();
            this.getLog().debug((CharSequence)proxyPass);
        }
        if (proxyHost != null) {
            client.getHostConfiguration().setProxy(proxyHost, proxyPort);
            this.getLog().debug((CharSequence)("Using proxy: " + proxyHost + " at port " + proxyPort));
            if (proxyUser != null) {
                this.getLog().debug((CharSequence)("Using proxy user: " + proxyUser));
                client.getState().setProxyCredentials(new AuthScope(null, -1, null, AuthScope.ANY_SCHEME), (Credentials)new UsernamePasswordCredentials(proxyUser, proxyPass));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void download(HttpClient cl, String link) {
        block13: {
            try {
                GetMethod gm;
                block14: {
                    gm = new GetMethod(link);
                    this.getLog().info((CharSequence)("Downloading from JIRA at: " + link));
                    gm.setFollowRedirects(true);
                    cl.executeMethod((HttpMethod)gm);
                    StatusLine sl = gm.getStatusLine();
                    if (sl == null) {
                        this.getLog().error((CharSequence)("Unknown error validating link: " + link));
                        return;
                    }
                    if (gm.getStatusCode() == 302) {
                        Header locationHeader = gm.getResponseHeader("Location");
                        if (locationHeader == null) {
                            this.getLog().warn((CharSequence)"Site sent redirect, but did not set Location header");
                        } else {
                            String newLink = locationHeader.getValue();
                            this.getLog().debug((CharSequence)("Following redirect to " + newLink));
                            this.download(cl, newLink);
                        }
                    }
                    if (gm.getStatusCode() != 200) break block14;
                    InputStream responseBodyStream = gm.getResponseBodyAsStream();
                    if (!this.output.getParentFile().exists()) {
                        this.output.getParentFile().mkdirs();
                    }
                    FileOutputStream out = null;
                    try {
                        out = new FileOutputStream(this.output);
                        IOUtil.copy((InputStream)responseBodyStream, (OutputStream)out);
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(out);
                        IOUtil.close((InputStream)responseBodyStream);
                        throw throwable;
                    }
                    IOUtil.close((OutputStream)out);
                    IOUtil.close((InputStream)responseBodyStream);
                    this.getLog().debug((CharSequence)"Downloading from JIRA was successful");
                    break block13;
                }
                this.getLog().warn((CharSequence)("Downloading from JIRA failed. Received: [" + gm.getStatusCode() + "]"));
            }
            catch (HttpException e) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().error((CharSequence)"Error downloading issues from JIRA:", (Throwable)e);
                } else {
                    this.getLog().error((CharSequence)("Error downloading issues from JIRA url: " + e.getLocalizedMessage()));
                }
            }
            catch (IOException e) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().error((CharSequence)"Error downloading issues from JIRA:", (Throwable)e);
                }
                this.getLog().error((CharSequence)("Error downloading issues from JIRA. Cause is " + e.getLocalizedMessage()));
            }
        }
    }

    public List<Issue> getIssueList() throws MojoExecutionException {
        if (this.output.isFile()) {
            JiraXML jira = new JiraXML(this.log, this.jiraDatePattern);
            jira.parseXML(this.output);
            this.getLog().info((CharSequence)("The JIRA version is '" + jira.getJiraVersion() + "'"));
            return jira.getIssueList();
        }
        this.getLog().warn((CharSequence)("JIRA file " + this.output.getPath() + " doesn't exist."));
        return Collections.emptyList();
    }

    public void setJiraDatePattern(String jiraDatePattern) {
        this.jiraDatePattern = jiraDatePattern;
    }

    public void setOutput(File thisOutput) {
        this.output = thisOutput;
    }

    public File getOutput() {
        return this.output;
    }

    public void setMavenProject(Object thisProject) {
        this.project = (MavenProject)thisProject;
    }

    public void setNbEntries(int nbEntries) {
        this.nbEntriesMax = nbEntries;
    }

    public void setStatusIds(String thisStatusIds) {
        this.statusIds = thisStatusIds;
    }

    public void setPriorityIds(String thisPriorityIds) {
        this.priorityIds = thisPriorityIds;
    }

    public void setResolutionIds(String thisResolutionIds) {
        this.resolutionIds = thisResolutionIds;
    }

    public void setSortColumnNames(String thisSortColumnNames) {
        this.sortColumnNames = thisSortColumnNames;
    }

    public void setWebPassword(String thisWebPassword) {
        this.webPassword = thisWebPassword;
    }

    public void setWebUser(String thisWebUser) {
        this.webUser = thisWebUser;
    }

    public void setJiraPassword(String thisJiraPassword) {
        this.jiraPassword = thisJiraPassword;
    }

    public void setJiraUser(String thisJiraUser) {
        this.jiraUser = thisJiraUser;
    }

    public void setFilter(String thisFilter) {
        this.filter = thisFilter;
    }

    public void setComponent(String theseComponents) {
        this.component = theseComponents;
    }

    public void setFixVersionIds(String theseFixVersionIds) {
        this.fixVersionIds = theseFixVersionIds;
    }

    public void setTypeIds(String theseTypeIds) {
        this.typeIds = theseTypeIds;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    private Log getLog() {
        return this.log;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public boolean isUseJql() {
        return this.useJql;
    }

    public void setUseJql(boolean useJql) {
        this.useJql = useJql;
    }

    public boolean isOnlyCurrentVersion() {
        return this.onlyCurrentVersion;
    }

    public void setOnlyCurrentVersion(boolean onlyCurrentVersion) {
        this.onlyCurrentVersion = onlyCurrentVersion;
    }

    public String getVersionPrefix() {
        return this.versionPrefix;
    }

    public void setVersionPrefix(String versionPrefix) {
        this.versionPrefix = versionPrefix;
    }
}

