/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.issues;

import java.util.ResourceBundle;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributeSet;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.util.HtmlTools;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractIssuesReportGenerator {
    protected String author;
    protected String title;

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    protected void sinkBeginReport(Sink sink, ResourceBundle bundle) {
        sink.head();
        String title = null;
        title = this.title != null ? this.title : bundle.getString("report.issues.header");
        sink.title();
        sink.text(title);
        sink.title_();
        if (StringUtils.isNotEmpty((String)this.author)) {
            sink.author();
            sink.text(this.author);
            sink.author_();
        }
        sink.head_();
        sink.body();
        sink.section1();
        this.sinkSectionTitle1Anchor(sink, title, title);
    }

    protected void sinkCell(Sink sink, String text) {
        sink.tableCell();
        if (text != null) {
            sink.text(text);
        } else {
            sink.nonBreakingSpace();
        }
        sink.tableCell_();
    }

    protected void sinkCellLink(Sink sink, String text, String link) {
        sink.tableCell();
        this.sinkLink(sink, text, link);
        sink.tableCell_();
    }

    protected void sinkEndReport(Sink sink) {
        sink.section1_();
        sink.body_();
        sink.flush();
        sink.close();
    }

    protected void sinkFigure(Sink sink, String image, String altText) {
        SinkEventAttributeSet attributes = new SinkEventAttributeSet();
        attributes.addAttribute((Object)"alt", (Object)altText);
        attributes.addAttribute((Object)"title", (Object)altText);
        sink.figureGraphics(image, (SinkEventAttributes)attributes);
    }

    protected void sinkHeader(Sink sink, String header) {
        sink.tableHeaderCell();
        sink.text(header);
        sink.tableHeaderCell_();
    }

    protected void sinkLink(Sink sink, String text, String link) {
        sink.link(link);
        sink.text(text);
        sink.link_();
    }

    protected void sinkSectionTitle1Anchor(Sink sink, String text, String anchor) {
        sink.sectionTitle1();
        sink.text(text);
        sink.sectionTitle1_();
        sink.anchor(HtmlTools.encodeId((String)anchor));
        sink.anchor_();
    }

    protected void sinkSectionTitle2Anchor(Sink sink, String text, String anchor) {
        sink.sectionTitle2();
        sink.text(text);
        sink.sectionTitle2_();
        sink.anchor(HtmlTools.encodeId((String)anchor));
        sink.anchor_();
    }

    protected void sinkShowTypeIcon(Sink sink, String type) {
        String image = "";
        String altText = "";
        if (type == null) {
            image = "images/icon_help_sml.gif";
            altText = "?";
        } else if (type.equals("fix")) {
            image = "images/fix.gif";
            altText = "fix";
        } else if (type.equals("update")) {
            image = "images/update.gif";
            altText = "update";
        } else if (type.equals("add")) {
            image = "images/add.gif";
            altText = "add";
        } else if (type.equals("remove")) {
            image = "images/remove.gif";
            altText = "remove";
        }
        sink.tableCell();
        this.sinkFigure(sink, image, altText);
        sink.tableCell_();
    }
}

