/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.trac;

import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.maven.plugin.changes.AbstractChangesReport;
import org.apache.maven.plugin.changes.ProjectUtils;
import org.apache.maven.plugin.issues.Issue;
import org.apache.maven.plugin.issues.IssuesReportGenerator;
import org.apache.maven.plugin.issues.IssuesReportHelper;
import org.apache.maven.plugin.trac.TracDownloader;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.reporting.MavenReportException;
import org.apache.xmlrpc.XmlRpcException;

@Mojo(name="trac-report", threadSafe=true)
public class TracMojo
extends AbstractChangesReport {
    private static Map<String, Integer> DEPRECATED_TRAC_COLUMNS = new HashMap<String, Integer>();
    private static Map<String, Integer> TRAC_COLUMNS = new HashMap<String, Integer>();
    @Parameter(defaultValue="Id,Type,Summary,Assignee,Reporter,Priority,Status,Resolution,Created,Updated")
    private String columnNames;
    @Parameter(defaultValue="order=id")
    private String query;
    @Parameter(defaultValue="")
    private String tracPassword;
    @Parameter(defaultValue="")
    private String tracUser;

    public boolean canGenerateReport() {
        return ProjectUtils.validateIfIssueManagementComplete(this.project, "Trac", "Trac Report", this.getLog());
    }

    public void executeReport(Locale locale) throws MavenReportException {
        List<Integer> columnIds = IssuesReportHelper.getColumnIds(this.columnNames, TRAC_COLUMNS, DEPRECATED_TRAC_COLUMNS, this.getLog());
        if (columnIds.size() == 0) {
            throw new MavenReportException("maven-changes-plugin: None of the configured columnNames '" + this.columnNames + "' are valid.");
        }
        try {
            TracDownloader issueDownloader = new TracDownloader();
            this.configureIssueDownloader(issueDownloader);
            List<Issue> issueList = issueDownloader.getIssueList();
            IssuesReportGenerator report = new IssuesReportGenerator(IssuesReportHelper.toIntArray(columnIds));
            if (issueList.isEmpty()) {
                report.doGenerateEmptyReport(this.getBundle(locale), this.getSink());
                this.getLog().warn((CharSequence)"No ticket has matched.");
            } else {
                report.doGenerateReport(this.getBundle(locale), this.getSink(), issueList);
            }
        }
        catch (MalformedURLException e) {
            throw new MavenReportException("The Trac URL is incorrect.");
        }
        catch (XmlRpcException e) {
            throw new MavenReportException("XmlRpc Error.", (Exception)((Object)e));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.issues.description");
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.issues.name");
    }

    public String getOutputName() {
        return "trac-report";
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("trac-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    private void configureIssueDownloader(TracDownloader issueDownloader) {
        issueDownloader.setProject(this.project);
        issueDownloader.setQuery(this.query);
        issueDownloader.setTracPassword(this.tracPassword);
        issueDownloader.setTracUser(this.tracUser);
    }

    static {
        DEPRECATED_TRAC_COLUMNS.put("changed", new Integer(12));
        DEPRECATED_TRAC_COLUMNS.put("component", new Integer(1));
        DEPRECATED_TRAC_COLUMNS.put("created", new Integer(2));
        DEPRECATED_TRAC_COLUMNS.put("id", new Integer(4));
        DEPRECATED_TRAC_COLUMNS.put("milestone", new Integer(3));
        DEPRECATED_TRAC_COLUMNS.put("owner", new Integer(0));
        DEPRECATED_TRAC_COLUMNS.put("priority", new Integer(6));
        DEPRECATED_TRAC_COLUMNS.put("reporter", new Integer(7));
        DEPRECATED_TRAC_COLUMNS.put("resolution", new Integer(8));
        DEPRECATED_TRAC_COLUMNS.put("status", new Integer(9));
        DEPRECATED_TRAC_COLUMNS.put("summary", new Integer(10));
        DEPRECATED_TRAC_COLUMNS.put("type", new Integer(11));
        TRAC_COLUMNS.put("Assignee", new Integer(0));
        TRAC_COLUMNS.put("Component", new Integer(1));
        TRAC_COLUMNS.put("Created", new Integer(2));
        TRAC_COLUMNS.put("Fix Version", new Integer(3));
        TRAC_COLUMNS.put("Id", new Integer(4));
        TRAC_COLUMNS.put("Priority", new Integer(6));
        TRAC_COLUMNS.put("Reporter", new Integer(7));
        TRAC_COLUMNS.put("Resolution", new Integer(8));
        TRAC_COLUMNS.put("Status", new Integer(9));
        TRAC_COLUMNS.put("Summary", new Integer(10));
        TRAC_COLUMNS.put("Type", new Integer(11));
        TRAC_COLUMNS.put("Updated", new Integer(12));
    }
}

