/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.changes;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.inject.Inject;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.apache.commons.io.input.XmlStreamReader;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.changes.AbstractChangesReport;
import org.apache.maven.plugins.changes.ChangesReportRenderer;
import org.apache.maven.plugins.changes.ChangesXML;
import org.apache.maven.plugins.changes.FeedGenerator;
import org.apache.maven.plugins.changes.ReleaseUtils;
import org.apache.maven.plugins.changes.model.Release;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFileFilterRequest;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="changes", threadSafe=true)
public class ChangesReport
extends AbstractChangesReport {
    @Parameter(defaultValue="false")
    private boolean aggregated;
    @Parameter(property="changes.addActionDate", defaultValue="false")
    private boolean addActionDate;
    @Parameter(defaultValue="${project.build.directory}/changes", required=true, readonly=true)
    private File filteredOutputDirectory;
    @Parameter(defaultValue="false")
    private boolean filteringChanges;
    @Parameter
    private Map<String, String> issueLinkTemplatePerSystem;
    @Parameter(defaultValue="yyyy-MM-dd")
    private String publishDateFormat;
    @Parameter(defaultValue="en")
    private String publishDateLocale;
    @Parameter(defaultValue="${project.issueManagement.system}", readonly=true)
    private String system;
    @Parameter(defaultValue="team.html")
    private String team;
    @Parameter(defaultValue="${project.issueManagement.url}", readonly=true)
    private String url;
    @Parameter
    private String feedType;
    @Parameter(property="changes.xmlPath", defaultValue="src/changes/changes.xml")
    private File xmlPath;
    private final MavenFileFilter mavenFileFilter;

    @Inject
    public ChangesReport(MavenFileFilter mavenFileFilter) {
        this.mavenFileFilter = mavenFileFilter;
    }

    public boolean canGenerateReport() {
        if (this.runOnlyAtExecutionRoot && !this.isThisTheExecutionRoot()) {
            this.getLog().info((CharSequence)"Skipping the Changes Report in this project because it's not the Execution Root");
            return false;
        }
        return this.xmlPath.isFile();
    }

    public void executeReport(Locale locale) throws MavenReportException {
        Date now = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.publishDateFormat, new Locale(this.publishDateLocale));
        Properties additionalProperties = new Properties();
        additionalProperties.put("publishDate", simpleDateFormat.format(now));
        ChangesXML changesXml = this.getChangesFromFile(this.xmlPath, this.project, additionalProperties);
        if (changesXml == null) {
            return;
        }
        if (this.aggregated) {
            String basePath = this.project.getBasedir().getAbsolutePath();
            String absolutePath = this.xmlPath.getAbsolutePath();
            if (!absolutePath.startsWith(basePath)) {
                this.getLog().warn((CharSequence)"xmlPath should be within the project dir for aggregated changes report.");
                return;
            }
            String relativePath = absolutePath.substring(basePath.length());
            List<Release> releaseList = changesXml.getReleaseList();
            for (MavenProject childProject : this.project.getCollectedProjects()) {
                File changesFile = new File(childProject.getBasedir(), relativePath);
                ChangesXML childXml = this.getChangesFromFile(changesFile, childProject, additionalProperties);
                if (childXml == null) continue;
                releaseList = ReleaseUtils.mergeReleases(releaseList, childProject.getName(), childXml.getReleaseList());
            }
            changesXml.setReleaseList(releaseList);
        }
        ChangesReportRenderer report = new ChangesReportRenderer(this.getSink(), this.getBundle(locale), changesXml);
        report.setIssueLinksPerSystem(this.prepareIssueLinksPerSystem());
        report.setSystem(this.system);
        report.setTeam(this.team);
        report.setUrl(this.url);
        report.setAddActionDate(this.addActionDate);
        if (this.url == null || this.url.isEmpty()) {
            this.getLog().warn((CharSequence)"No issue management URL defined in POM. Links to your issues will not work correctly.");
        }
        boolean feedGenerated = false;
        if (this.feedType != null && !this.feedType.isEmpty()) {
            feedGenerated = this.generateFeed(changesXml, locale);
        }
        report.setLinkToFeed(feedGenerated);
        report.render();
        this.copyStaticResources();
    }

    private Map<String, String> prepareIssueLinksPerSystem() {
        CaseInsensitiveMap issueLinkTemplate = this.issueLinkTemplatePerSystem == null ? new CaseInsensitiveMap() : new CaseInsensitiveMap(this.issueLinkTemplatePerSystem);
        issueLinkTemplate.computeIfAbsent("default", k -> "%URL%/ViewIssue.jspa?key=%ISSUE%");
        issueLinkTemplate.computeIfAbsent("Bitbucket", k -> "%URL%/issue/%ISSUE%");
        issueLinkTemplate.computeIfAbsent("Bugzilla", k -> "%URL%/show_bug.cgi?id=%ISSUE%");
        issueLinkTemplate.computeIfAbsent("GitHub", k -> "%URL%/%ISSUE%");
        issueLinkTemplate.computeIfAbsent("GoogleCode", k -> "%URL%/detail?id=%ISSUE%");
        issueLinkTemplate.computeIfAbsent("JIRA", k -> "%URL%/%ISSUE%");
        issueLinkTemplate.computeIfAbsent("Mantis", k -> "%URL%/view.php?id=%ISSUE%");
        issueLinkTemplate.computeIfAbsent("MKS", k -> "%URL%/viewissue?selection=%ISSUE%");
        issueLinkTemplate.computeIfAbsent("Redmine", k -> "%URL%/issues/show/%ISSUE%");
        issueLinkTemplate.computeIfAbsent("Scarab", k -> "%URL%/issues/id/%ISSUE%");
        issueLinkTemplate.computeIfAbsent("SourceForge", k -> "http://sourceforge.net/support/tracker.php?aid=%ISSUE%");
        issueLinkTemplate.computeIfAbsent("SourceForge2", k -> "%URL%/%ISSUE%");
        issueLinkTemplate.computeIfAbsent("Trac", k -> "%URL%/ticket/%ISSUE%");
        issueLinkTemplate.computeIfAbsent("Trackplus", k -> "%URL%/printItem.action?key=%ISSUE%");
        issueLinkTemplate.computeIfAbsent("Tuleap", k -> "%URL%/?aid=%ISSUE%");
        issueLinkTemplate.computeIfAbsent("YouTrack", k -> "%URL%/issue/%ISSUE%");
        this.logIssueLinkTemplatePerSystem((Map<String, String>)issueLinkTemplate);
        return issueLinkTemplate;
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.issues.description");
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.issues.name");
    }

    @Deprecated
    public String getOutputName() {
        return "changes";
    }

    private ChangesXML getChangesFromFile(File changesXml, MavenProject project, Properties additionalProperties) throws MavenReportException {
        if (!changesXml.exists()) {
            this.getLog().warn((CharSequence)("changes.xml file " + changesXml.getAbsolutePath() + " does not exist."));
            return null;
        }
        if (this.filteringChanges) {
            if (!this.filteredOutputDirectory.exists()) {
                this.filteredOutputDirectory.mkdirs();
            }
            try (XmlStreamReader xmlStreamReader = ((XmlStreamReader.Builder)XmlStreamReader.builder().setFile(changesXml)).get();){
                String encoding = xmlStreamReader.getEncoding();
                File resultFile = new File(this.filteredOutputDirectory, project.getGroupId() + "." + project.getArtifactId() + "-changes.xml");
                MavenFileFilterRequest mavenFileFilterRequest = new MavenFileFilterRequest(changesXml, resultFile, true, project, Collections.emptyList(), false, encoding, this.mavenSession, additionalProperties);
                this.mavenFileFilter.copyFile(mavenFileFilterRequest);
                changesXml = resultFile;
            }
            catch (IOException | MavenFilteringException e) {
                throw new MavenReportException("Exception during filtering changes file : " + e.getMessage(), (Exception)e);
            }
        }
        return new ChangesXML(changesXml, this.getLog());
    }

    private void copyStaticResources() throws MavenReportException {
        String pluginResourcesBase = "org/apache/maven/plugins/changes";
        String[] resourceNames = new String[]{"images/add.gif", "images/fix.gif", "images/icon_help_sml.gif", "images/remove.gif", "images/rss.png", "images/update.gif"};
        try {
            this.getLog().debug((CharSequence)"Copying static resources.");
            for (String resourceName : resourceNames) {
                URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("org/apache/maven/plugins/changes/" + resourceName);
                FileUtils.copyURLToFile((URL)url, (File)new File(this.getReportOutputDirectory(), resourceName));
            }
        }
        catch (IOException e) {
            throw new MavenReportException("Unable to copy static resources.");
        }
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("changes-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    private void logIssueLinkTemplatePerSystem(Map<String, String> issueLinkTemplatePerSystem) {
        if (this.getLog().isDebugEnabled()) {
            for (Map.Entry<String, String> entry : issueLinkTemplatePerSystem.entrySet()) {
                this.getLog().debug((CharSequence)("issueLinkTemplatePerSystem[" + entry.getKey() + "] = " + entry.getValue()));
            }
        }
    }

    private boolean generateFeed(ChangesXML changesXml, Locale locale) {
        this.getLog().debug((CharSequence)("Generating " + this.feedType + " feed."));
        boolean success = true;
        FeedGenerator feed = new FeedGenerator(locale);
        feed.setLink(this.project.getUrl() + "/changes-report.html");
        feed.setTitle(this.project.getName() + ": " + changesXml.getTitle());
        feed.setAuthor(changesXml.getAuthor());
        feed.setDateFormat(new SimpleDateFormat(this.publishDateFormat, new Locale(this.publishDateLocale)));
        Path changes = this.getReportOutputDirectory().toPath().resolve("changes.rss");
        try (BufferedWriter writer = Files.newBufferedWriter(changes, StandardCharsets.UTF_8, new OpenOption[0]);){
            feed.export(changesXml.getReleaseList(), this.feedType, writer);
        }
        catch (IOException ex) {
            success = false;
            this.getLog().warn((CharSequence)("Failed to create RSS feed: " + ex.getMessage()));
            this.getLog().debug((Throwable)ex);
        }
        return success;
    }
}

