/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.changes;

import com.rometools.rome.feed.synd.SyndContent;
import com.rometools.rome.feed.synd.SyndContentImpl;
import com.rometools.rome.feed.synd.SyndEntry;
import com.rometools.rome.feed.synd.SyndEntryImpl;
import com.rometools.rome.feed.synd.SyndFeed;
import com.rometools.rome.feed.synd.SyndFeedImpl;
import com.rometools.rome.io.FeedException;
import com.rometools.rome.io.SyndFeedOutput;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.doxia.util.DoxiaUtils;
import org.apache.maven.plugins.changes.model.Release;

public class FeedGenerator {
    private final ResourceBundle rbundle;
    private final SyndFeed feed = new SyndFeedImpl();
    private String link;
    private String title;
    private String author;
    private DateFormat dateFormat;

    public FeedGenerator(Locale locale) {
        this.rbundle = ResourceBundle.getBundle("changes-report", locale, this.getClass().getClassLoader());
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author.trim();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title.trim();
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link.trim();
    }

    public boolean isSupportedFeedType(String type) {
        return this.getSupportedFeedTypes().contains(type);
    }

    public List<String> getSupportedFeedTypes() {
        return this.feed.getSupportedFeedTypes();
    }

    public void export(List<Release> releases, String feedType, Writer writer) throws IOException {
        this.feed.setFeedType(feedType);
        this.feed.setTitle(this.title);
        this.feed.setAuthor(this.author);
        this.feed.setPublishedDate(new Date());
        this.feed.setLink(this.link);
        this.feed.setDescription(this.rbundle.getString("report.changes.text.rssfeed.description"));
        this.feed.setLanguage(this.rbundle.getLocale().getLanguage());
        this.feed.setEntries(this.getEntries(releases));
        try {
            new SyndFeedOutput().output(this.feed, writer);
        }
        catch (FeedException ex) {
            throw new IOException(ex.getMessage(), ex);
        }
    }

    private List<SyndEntry> getEntries(List<Release> releases) {
        ArrayList<SyndEntry> entries = new ArrayList<SyndEntry>(1);
        if (releases.size() > 0) {
            Release release = releases.get(0);
            SyndEntryImpl entry = new SyndEntryImpl();
            entry.setTitle(release.getVersion());
            entry.setLink(this.link + "#" + DoxiaUtils.encodeId((String)release.getVersion()));
            entry.setDescription(FeedGenerator.getSyndContent(release));
            entry.setPublishedDate(FeedGenerator.getDate(release.getDateRelease(), this.dateFormat));
            entries.add((SyndEntry)entry);
        }
        return entries;
    }

    private static SyndContent getSyndContent(Release release) {
        SyndContentImpl syndContent = new SyndContentImpl();
        syndContent.setType("text/html");
        StringBuilder sb = new StringBuilder(512);
        String description = release.getDescription();
        if (description != null && description.trim().length() > 0) {
            sb.append("<p>").append(description).append("</p>");
        }
        sb.append("<p>Version ").append(release.getVersion()).append(" is available with ");
        sb.append(release.getActions().size()).append(" fixed issues.</p>");
        syndContent.setValue(sb.toString());
        return syndContent;
    }

    private static Date getDate(String dateRelease, DateFormat dateFormat) {
        if (dateFormat == null) {
            return new Date();
        }
        try {
            return dateFormat.parse(dateRelease);
        }
        catch (ParseException ex) {
            return new Date();
        }
    }
}

