/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.changes;

import org.apache.maven.project.MavenProject;

public final class ProjectUtils {
    private ProjectUtils() {
    }

    public static String validateIssueManagement(MavenProject project, String issueManagementSystem, String mojoResult) {
        if (project.getIssueManagement() == null) {
            return "No Issue Management set. No " + mojoResult + " will be generated.";
        }
        if (project.getIssueManagement().getUrl() == null || project.getIssueManagement().getUrl().trim().equals("")) {
            return "No URL set in Issue Management. No " + mojoResult + " will be generated.";
        }
        if (project.getIssueManagement().getSystem() != null && !project.getIssueManagement().getSystem().equalsIgnoreCase(issueManagementSystem)) {
            return "The " + mojoResult + " only supports " + issueManagementSystem + ".  No " + mojoResult + " will be generated.";
        }
        return null;
    }
}

