/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.changes.jira;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.changes.issues.Issue;
import org.apache.maven.plugins.changes.jira.JiraHelper;
import org.apache.maven.plugins.changes.jira.JqlQueryBuilder;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.SettingsProblem;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;

public class RestJiraDownloader {
    private Log log;
    private MavenProject project;
    private Settings settings;
    private SettingsDecrypter settingsDecrypter;
    private boolean onlyCurrentVersion;
    protected String versionPrefix;
    protected int nbEntriesMax;
    protected String filter;
    protected String fixVersionIds;
    protected String statusIds;
    protected String resolutionIds;
    protected String priorityIds;
    protected String component;
    protected String typeIds;
    protected String sortColumnNames;
    protected String jiraUser;
    protected String jiraPassword;
    private String jiraServerId;
    protected String jiraDatePattern;
    protected int connectionTimeout;
    protected int receiveTimout;
    private List<Issue> issueList;
    private JsonFactory jsonFactory = new MappingJsonFactory();
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private List<String> resolvedFixVersionIds = new ArrayList<String>();
    private List<String> resolvedStatusIds = new ArrayList<String>();
    private List<String> resolvedComponentIds = new ArrayList<String>();
    private List<String> resolvedTypeIds = new ArrayList<String>();
    private List<String> resolvedResolutionIds = new ArrayList<String>();
    private List<String> resolvedPriorityIds = new ArrayList<String>();

    protected String getFixFor() {
        if (this.onlyCurrentVersion) {
            String version = (this.versionPrefix == null ? "" : this.versionPrefix) + this.project.getVersion();
            if (version.endsWith("-SNAPSHOT")) {
                return version.substring(0, version.length() - "-SNAPSHOT".length());
            }
            return version;
        }
        return null;
    }

    public void setMavenProject(MavenProject thisProject) {
        this.project = thisProject;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    protected Log getLog() {
        return this.log;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public void setSettingsDecrypter(SettingsDecrypter settingsDecrypter) {
        this.settingsDecrypter = settingsDecrypter;
    }

    public void setOnlyCurrentVersion(boolean onlyCurrentVersion) {
        this.onlyCurrentVersion = onlyCurrentVersion;
    }

    public void setVersionPrefix(String versionPrefix) {
        this.versionPrefix = versionPrefix;
    }

    public void setJiraDatePattern(String jiraDatePattern) {
        this.jiraDatePattern = jiraDatePattern;
    }

    public void setNbEntries(int nbEntries) {
        this.nbEntriesMax = nbEntries;
    }

    public void setStatusIds(String thisStatusIds) {
        this.statusIds = thisStatusIds;
    }

    public void setPriorityIds(String thisPriorityIds) {
        this.priorityIds = thisPriorityIds;
    }

    public void setResolutionIds(String thisResolutionIds) {
        this.resolutionIds = thisResolutionIds;
    }

    public void setSortColumnNames(String thisSortColumnNames) {
        this.sortColumnNames = thisSortColumnNames;
    }

    public void setJiraPassword(String thisJiraPassword) {
        this.jiraPassword = thisJiraPassword;
    }

    public void setJiraUser(String thisJiraUser) {
        this.jiraUser = thisJiraUser;
    }

    public void setJiraServerId(String jiraServerId) {
        this.jiraServerId = jiraServerId;
    }

    public void setFilter(String thisFilter) {
        this.filter = thisFilter;
    }

    public void setComponent(String theseComponents) {
        this.component = theseComponents;
    }

    public void setFixVersionIds(String theseFixVersionIds) {
        this.fixVersionIds = theseFixVersionIds;
    }

    public void setTypeIds(String theseTypeIds) {
        this.typeIds = theseTypeIds;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setReceiveTimout(int receiveTimout) {
        this.receiveTimout = receiveTimout;
    }

    public void doExecute() throws Exception {
        Map<String, String> urlMap = JiraHelper.getJiraUrlAndProjectName(this.project.getIssueManagement().getUrl());
        String jiraUrl = urlMap.get("url");
        String jiraProject = urlMap.get("project");
        try (CloseableHttpClient client = this.setupHttpClient(jiraUrl);){
            this.checkRestApi(client, jiraUrl);
            this.doSessionAuth(client, jiraUrl);
            this.resolveIds(client, jiraUrl, jiraProject);
            this.search(client, jiraProject, jiraUrl);
        }
    }

    private void search(CloseableHttpClient client, String jiraProject, String jiraUrl) throws IOException, MojoExecutionException {
        String jqlQuery = new JqlQueryBuilder(this.log).urlEncode(false).project(jiraProject).fixVersion(this.getFixFor()).fixVersionIds(this.resolvedFixVersionIds).statusIds(this.resolvedStatusIds).priorityIds(this.resolvedPriorityIds).resolutionIds(this.resolvedResolutionIds).components(this.resolvedComponentIds).typeIds(this.resolvedTypeIds).sortColumnNames(this.sortColumnNames).filter(this.filter).build();
        this.log.debug((CharSequence)("JIRA jql=" + jqlQuery));
        StringWriter searchParamStringWriter = new StringWriter();
        try (JsonGenerator gen = this.jsonFactory.createGenerator((Writer)searchParamStringWriter);){
            gen.writeStartObject();
            gen.writeStringField("jql", jqlQuery);
            gen.writeNumberField("maxResults", this.nbEntriesMax);
            gen.writeArrayFieldStart("fields");
            gen.writeString("*all");
            gen.writeEndArray();
            gen.writeEndObject();
        }
        HttpPost httpPost = new HttpPost(jiraUrl + "/rest/api/2/search");
        httpPost.setHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
        httpPost.setEntity((HttpEntity)new StringEntity(searchParamStringWriter.toString()));
        try (CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);){
            if (response.getStatusLine().getStatusCode() != 200) {
                this.reportErrors((HttpResponse)response);
            }
            JsonNode issueTree = this.getResponseTree((HttpResponse)response);
            this.assertIsObject(issueTree);
            JsonNode issuesNode = issueTree.get("issues");
            this.assertIsArray(issuesNode);
            this.buildIssues(issuesNode, jiraUrl);
        }
    }

    private void checkRestApi(CloseableHttpClient client, String jiraUrl) throws IOException, NoRest {
        HttpGet httpGet = new HttpGet(jiraUrl + "/rest/api/2/serverInfo");
        try (CloseableHttpResponse response = client.execute((HttpUriRequest)httpGet);){
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new NoRest("This JIRA server does not support version 2 of the REST API, which maven-changes-plugin requires.");
            }
        }
    }

    private JsonNode getResponseTree(HttpResponse response) throws IOException {
        try (InputStream inputStream = response.getEntity().getContent();){
            JsonNode jsonNode;
            block12: {
                JsonParser jsonParser = this.jsonFactory.createParser(inputStream);
                try {
                    jsonNode = (JsonNode)jsonParser.readValueAsTree();
                    if (jsonParser == null) break block12;
                }
                catch (Throwable throwable) {
                    if (jsonParser != null) {
                        try {
                            jsonParser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                jsonParser.close();
            }
            return jsonNode;
        }
    }

    private void reportErrors(HttpResponse resp) throws IOException, MojoExecutionException {
        ContentType contentType = ContentType.get((HttpEntity)resp.getEntity());
        if (contentType != null && contentType.getMimeType().equals(ContentType.APPLICATION_JSON.getMimeType())) {
            JsonNode errorTree = this.getResponseTree(resp);
            this.assertIsObject(errorTree);
            JsonNode messages = errorTree.get("errorMessages");
            if (messages != null) {
                for (int mx = 0; mx < messages.size(); ++mx) {
                    this.getLog().error((CharSequence)messages.get(mx).asText());
                }
            } else {
                JsonNode message = errorTree.get("message");
                if (message != null) {
                    this.getLog().error((CharSequence)message.asText());
                }
            }
        }
        throw new MojoExecutionException(String.format("Failed to query issues; response %d", resp.getStatusLine().getStatusCode()));
    }

    private void resolveIds(CloseableHttpClient client, String jiraUrl, String jiraProject) throws IOException, MojoExecutionException, MojoFailureException {
        this.resolveList(this.resolvedComponentIds, client, "components", this.component, jiraUrl + "/rest/api/2/project/" + jiraProject + "/components");
        this.resolveList(this.resolvedFixVersionIds, client, "fixVersions", this.fixVersionIds, jiraUrl + "/rest/api/2/project/" + jiraProject + "/versions");
        this.resolveList(this.resolvedStatusIds, client, "status", this.statusIds, jiraUrl + "/rest/api/2/status");
        this.resolveList(this.resolvedResolutionIds, client, "resolution", this.resolutionIds, jiraUrl + "/rest/api/2/resolution");
        this.resolveList(this.resolvedTypeIds, client, "type", this.typeIds, jiraUrl + "/rest/api/2/issuetype");
        this.resolveList(this.resolvedPriorityIds, client, "priority", this.priorityIds, jiraUrl + "/rest/api/2/priority");
    }

    private void resolveList(List<String> targetList, CloseableHttpClient client, String what, String input, String listRestUrlPattern) throws IOException, MojoExecutionException, MojoFailureException {
        if (input == null || input.isEmpty()) {
            return;
        }
        HttpGet httpGet = new HttpGet(listRestUrlPattern);
        try (CloseableHttpResponse response = client.execute((HttpUriRequest)httpGet);){
            String[] pieces;
            if (response.getStatusLine().getStatusCode() != 200) {
                this.getLog().error((CharSequence)String.format("Could not get %s list from %s", what, listRestUrlPattern));
                this.reportErrors((HttpResponse)response);
            }
            JsonNode items = this.getResponseTree((HttpResponse)response);
            for (String item : pieces = input.split(",")) {
                targetList.add(this.resolveOneItem(items, what, item.trim()));
            }
        }
    }

    private String resolveOneItem(JsonNode items, String what, String nameOrId) throws MojoFailureException {
        for (int cx = 0; cx < items.size(); ++cx) {
            JsonNode item = items.get(cx);
            if (nameOrId.equals(item.get("id").asText())) {
                return nameOrId;
            }
            if (!nameOrId.equals(item.get("name").asText())) continue;
            return item.get("id").asText();
        }
        throw new MojoFailureException(String.format("Could not find %s %s.", what, nameOrId));
    }

    private void buildIssues(JsonNode issuesNode, String jiraUrl) {
        this.issueList = new ArrayList<Issue>();
        for (int ix = 0; ix < issuesNode.size(); ++ix) {
            JsonNode issueNode = issuesNode.get(ix);
            this.assertIsObject(issueNode);
            Issue issue = new Issue();
            JsonNode val = issueNode.get("id");
            if (this.isNotNullNode(val)) {
                issue.setId(val.asText());
            }
            if (this.isNotNullNode(val = issueNode.get("key"))) {
                issue.setKey(val.asText());
                issue.setLink(String.format("%s/browse/%s", jiraUrl, val.asText()));
            }
            JsonNode fieldsNode = issueNode.get("fields");
            val = fieldsNode.get("assignee");
            this.processAssignee(issue, val);
            val = fieldsNode.get("created");
            this.processCreated(issue, val);
            val = fieldsNode.get("components");
            this.processComponents(issue, val);
            val = fieldsNode.get("fixVersions");
            this.processFixVersions(issue, val);
            val = fieldsNode.get("issuetype");
            this.processIssueType(issue, val);
            val = fieldsNode.get("priority");
            this.processPriority(issue, val);
            val = fieldsNode.get("reporter");
            this.processReporter(issue, val);
            val = fieldsNode.get("resolution");
            this.processResolution(issue, val);
            val = fieldsNode.get("status");
            this.processStatus(issue, val);
            val = fieldsNode.get("summary");
            if (this.isNotNullNode(val)) {
                issue.setSummary(val.asText());
            }
            val = fieldsNode.get("updated");
            this.processUpdated(issue, val);
            val = fieldsNode.get("versions");
            this.processVersions(issue, val);
            this.issueList.add(issue);
        }
    }

    private void processVersions(Issue issue, JsonNode val) {
        StringBuilder sb = new StringBuilder();
        if (this.isNotNullNode(val)) {
            for (int vx = 0; vx < val.size(); ++vx) {
                if (!this.isNotNullNode(val.get(vx)) || !this.isNotNullNode(val.get(vx).get("name"))) continue;
                sb.append(val.get(vx).get("name").asText());
                sb.append(", ");
            }
        }
        if (sb.length() > 0) {
            issue.setVersion(sb.substring(0, sb.length() - 2));
        }
    }

    private void processStatus(Issue issue, JsonNode val) {
        if (this.isNotNullNode(val) && this.isNotNullNode(val.get("name"))) {
            issue.setStatus(val.get("name").asText());
        }
    }

    private void processPriority(Issue issue, JsonNode val) {
        if (this.isNotNullNode(val) && this.isNotNullNode(val.get("name"))) {
            issue.setPriority(val.get("name").asText());
        }
    }

    private void processResolution(Issue issue, JsonNode val) {
        if (this.isNotNullNode(val) && this.isNotNullNode(val.get("name"))) {
            issue.setResolution(val.get("name").asText());
        }
    }

    private String getPerson(JsonNode val) {
        JsonNode nameNode = val.get("displayName");
        if (!this.isNotNullNode(nameNode)) {
            nameNode = val.get("name");
        }
        if (this.isNotNullNode(nameNode)) {
            return nameNode.asText();
        }
        return null;
    }

    private void processAssignee(Issue issue, JsonNode val) {
        String text;
        if (this.isNotNullNode(val) && (text = this.getPerson(val)) != null) {
            issue.setAssignee(text);
        }
    }

    private void processReporter(Issue issue, JsonNode val) {
        String text;
        if (this.isNotNullNode(val) && (text = this.getPerson(val)) != null) {
            issue.setReporter(text);
        }
    }

    private void processCreated(Issue issue, JsonNode val) {
        if (this.isNotNullNode(val)) {
            try {
                issue.setCreated(this.parseDate(val));
            }
            catch (ParseException e) {
                this.getLog().warn((CharSequence)("Invalid created date " + val.asText()));
            }
        }
    }

    private void processUpdated(Issue issue, JsonNode val) {
        if (this.isNotNullNode(val)) {
            try {
                issue.setUpdated(this.parseDate(val));
            }
            catch (ParseException e) {
                this.getLog().warn((CharSequence)("Invalid updated date " + val.asText()));
            }
        }
    }

    private Date parseDate(JsonNode val) throws ParseException {
        return this.dateFormat.parse(val.asText());
    }

    private void processFixVersions(Issue issue, JsonNode val) {
        if (this.isNotNullNode(val)) {
            this.assertIsArray(val);
            for (int vx = 0; vx < val.size(); ++vx) {
                JsonNode fvNode = val.get(vx);
                if (!this.isNotNullNode(fvNode) || !this.isNotNullNode(fvNode.get("name"))) continue;
                issue.addFixVersion(fvNode.get("name").asText());
            }
        }
    }

    private void processComponents(Issue issue, JsonNode val) {
        if (this.isNotNullNode(val)) {
            this.assertIsArray(val);
            for (int cx = 0; cx < val.size(); ++cx) {
                JsonNode cnode = val.get(cx);
                if (!this.isNotNullNode(cnode) || !this.isNotNullNode(cnode.get("name"))) continue;
                issue.addComponent(cnode.get("name").asText());
            }
        }
    }

    private void processIssueType(Issue issue, JsonNode val) {
        if (this.isNotNullNode(val) && this.isNotNullNode(val.get("name"))) {
            issue.setType(val.get("name").asText());
        }
    }

    private void assertIsObject(JsonNode node) {
        if (!node.isObject()) {
            throw new IllegalArgumentException("json node: " + node + " is not an object");
        }
    }

    private void assertIsArray(JsonNode node) {
        if (!node.isArray()) {
            throw new IllegalArgumentException("json node: " + node + " is not an array");
        }
    }

    private boolean isNotNullNode(JsonNode node) {
        return node != null && !node.isNull();
    }

    private void doSessionAuth(CloseableHttpClient client, String jiraUrl) throws IOException, MojoExecutionException, NoRest {
        Server server = this.settings.getServer(this.jiraServerId);
        if (server != null) {
            SettingsDecryptionResult result = this.settingsDecrypter.decrypt((SettingsDecryptionRequest)new DefaultSettingsDecryptionRequest(server));
            if (!result.getProblems().isEmpty()) {
                for (SettingsProblem problem : result.getProblems()) {
                    this.log.error((CharSequence)problem.getMessage());
                }
            } else {
                this.jiraUser = result.getServer().getUsername();
                this.jiraPassword = result.getServer().getPassword();
            }
        }
        if (this.jiraUser != null) {
            StringWriter jsWriter = new StringWriter();
            try (JsonGenerator gen = this.jsonFactory.createGenerator((Writer)jsWriter);){
                gen.writeStartObject();
                gen.writeStringField("username", this.jiraUser);
                gen.writeStringField("password", this.jiraPassword);
                gen.writeEndObject();
            }
            HttpPost post = new HttpPost(jiraUrl + "/rest/auth/1/session");
            post.addHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
            post.setEntity((HttpEntity)new StringEntity(jsWriter.toString()));
            try (CloseableHttpResponse response = client.execute((HttpUriRequest)post);){
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode != 200) {
                    if (statusCode != 401 && statusCode != 403) {
                        throw new NoRest();
                    }
                    throw new MojoExecutionException(String.format("Authentication failure status %d.", statusCode));
                }
            }
        }
    }

    private CloseableHttpClient setupHttpClient(String jiraUrl) {
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setDefaultCookieStore((CookieStore)new BasicCookieStore()).setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout(this.receiveTimout).setConnectTimeout(this.connectionTimeout).build()).setDefaultHeaders(Collections.singletonList(new BasicHeader("Accept", "application/json")));
        Proxy proxy = this.getProxy(jiraUrl);
        if (proxy != null) {
            if (proxy.getUsername() != null && proxy.getPassword() != null) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(proxy.getHost(), proxy.getPort()), (Credentials)new UsernamePasswordCredentials(proxy.getUsername(), proxy.getPassword()));
                httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
            httpClientBuilder.setProxy(new HttpHost(proxy.getHost(), proxy.getPort()));
        }
        return httpClientBuilder.build();
    }

    private Proxy getProxy(String jiraUrl) {
        Proxy proxy = this.settings.getActiveProxy();
        if (proxy != null) {
            SettingsDecryptionResult result = this.settingsDecrypter.decrypt((SettingsDecryptionRequest)new DefaultSettingsDecryptionRequest(proxy));
            if (!result.getProblems().isEmpty()) {
                for (SettingsProblem problem : result.getProblems()) {
                    this.log.error((CharSequence)problem.getMessage());
                }
            } else {
                proxy = result.getProxy();
            }
        }
        if (proxy != null && proxy.getNonProxyHosts() != null) {
            URI jiraUri = URI.create(jiraUrl);
            boolean nonProxy = Arrays.stream(proxy.getNonProxyHosts().split("\\|")).anyMatch(host -> !host.equalsIgnoreCase(jiraUri.getHost()));
            if (nonProxy) {
                return null;
            }
        }
        return proxy;
    }

    public List<Issue> getIssueList() {
        return this.issueList;
    }

    public static class NoRest
    extends Exception {
        private static final long serialVersionUID = 6970088805270319624L;

        public NoRest() {
        }

        public NoRest(String message) {
            super(message);
        }
    }
}

