package org.apache.maven.plugin.checkstyle;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on 'org.apache.maven.plugins:maven-checkstyle-plugin' plugin. Call 'mvn checkstyle:help -Ddetail=true' to display all details.
 *
 * @version generated on Sat May 31 22:37:32 CEST 2008
 * @goal help
 */
public class HelpMojo
    extends AbstractMojo
{
    /** 80-character display buffer */
    private static final int DEFAULT_WIDTH = 80;

    /** 4 indent spaces */
    private static final String DEFAULT_INDENT = repeat( " ", 2 );

    /**
     * If true, display all settable properies for each goal.
     *
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        StringBuffer sb = new StringBuffer();

        sb.append( "The 'org.apache.maven.plugins:maven-checkstyle-plugin' plugin has 4 goals:" ).append( "\n" );
        sb.append( "\n" );

        sb.append( "checkstyle:checkstyle" ).append( "\n" );
        for ( Iterator it = toLines( "Perform a Checkstyle analysis, and generate a report on violations." ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
        if ( detail )
        {
            sb.append( "\n" );

            sb.append( repeat( " ", 2 ) );
            sb.append( "Available parameters:" ).append( "\n" );

            sb.append( "\n" );

        for ( Iterator it = toLines( "cacheFile (Default: '${project.build.directory}/checkstyle-cachefile')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Specifies the cache file used to speed up Checkstyle on successive runs.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "configLocation (Default: 'config/sun_checks.xml')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Specifies the location of the XML configuration to use.Potential values are a filesystem path, a URL, or a classpath resource. This parameter expects that the contents of the location conform to the xml format (Checkstyle Checker module) configuration of rulesets.This parameter is resolved as resource, URL, then file. If successfully resolved, the contents of the configuration is copied into the ${project.build.directory}/checkstyle-configuration.xml file before being passed to Checkstyle as a configuration.There are 4 predefined rulesets.config/sun_checks.xml: Sun Checks.config/turbine_checks.xml: Turbine Checks.config/avalon_checks.xml: Avalon Checks.config/maven_checks.xml: Maven Source Checks.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "consoleOutput (Default: 'false')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Output errors to console.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "enableFilesSummary (Default: 'true')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Specifies if the Files summary should be enabled or not.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "enableRSS (Default: 'true')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Specifies if the RSS should be enabled or not.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "enableRulesSummary (Default: 'true')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Specifies if the Rules summary should be enabled or not.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "enableSeveritySummary (Default: 'true')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Specifies if the Severity summary should be enabled or not.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "encoding (Default: '${project.build.sourceEncoding}')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "The file encoding to use when reading the source files. If the property project.build.sourceEncoding is not set, the platform default encoding is used. Note: This parameter always overrides the property charset from Checkstyle's TreeWalker module.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "excludes", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Specifies the names filter of the source files to be excluded for Checkstyle.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "failsOnError (Default: 'false')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Specifies if the build should fail upon a violation.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "format (Default: 'sun')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Specifies what predefined check set to use. Available sets are 'sun' (for the Sun coding conventions), 'turbine', and 'avalon'.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "headerFile", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Specifies the location of the License file (a.k.a. the header file) that is used by Checkstyle to verify that source code has the correct license header.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "headerLocation (Default: 'LICENSE.txt')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Specifies the location of the License file (a.k.a. the header file) that can be used by Checkstyle to verify that source code has the correct license header.You need to use ${checkstyle.header.file} in your Checkstyle xml configuration to reference the name of this header file.For instance:<module name='RegexpHeader'> <property name='headerFile' value='${checkstyle.header.file}'/> </module> ", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "includeTestSourceDirectory (Default: '${false}')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Include or not the test source directory to be used for Checkstyle.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "includes (Default: '**/*.java')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Specifies the names filter of the source files to be used for Checkstyle.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "linkXRef (Default: 'true')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Link the violation line numbers to the source xref. Will link automatically if Maven JXR plugin is being used.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "outputDirectory (Default: '${project.reporting.outputDirectory}')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "The output directory for the report. Note that this parameter is only evaluated if the goal is run directly from the command line. If the goal is run indirectly as part of a site generation, the output directory configured in Maven Site Plugin is used instead.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "outputFile (Default: '${project.build.directory}/checkstyle-result.xml')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Specifies the path and filename to save the checkstyle output. The format of the output file is determined by the outputFileFormat parameter.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "outputFileFormat (Default: 'xml')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Specifies the format of the output to be used when writing to the output file. Valid values are 'plain' and 'xml'.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "packageNamesFile", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Specifies the location of the package names XML to be used to configure Checkstyle.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "packageNamesLocation", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Specifies the location of the package names XML to be used to configure the Checkstyle Packages.This parameter is resolved as resource, URL, then file. If resolved to a resource, or a URL, the contents of the package names XML is copied into the ${project.build.directory}/checkstyle-packagenames.xml file before being passed to Checkstyle for loading.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "propertiesFile", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Specifies the location of the Checkstyle properties file that will be used to check the source.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "propertiesLocation", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Specifies the location of the properties file.This parameter is resolved as URL, File then resource. If successfully resolved, the contents of the properties location is copied into the ${project.build.directory}/checkstyle-checker.properties file before being passed to Checkstyle for loading.The contents of the propertiesLocation will be made available to Checkstyle for specifying values for parameters within the xml configuration (specified in the configLocation parameter).", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "propertiesURL", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Specifies the URL of the Checkstyle properties that will be used to check the source.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "propertyExpansion", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Allows for specifying raw property expansion information.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "skip (Default: 'false')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Skip entire check.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "sourceDirectory (Default: '${project.build.sourceDirectory}')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Specifies the location of the source directory to be used for Checkstyle.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "suppressionsFile", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Specifies the location of the suppressions XML file to use. The plugin defines a Checkstyle property named checkstyle.suppressions.file with the value of this property. This allows using the Checkstyle property in your own custom checkstyle configuration file when specifying a suppressions file.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "suppressionsFileExpression (Default: 'checkstyle.suppressions.file')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "The key to be used in the properties for the suppressions file.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "suppressionsLocation", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Specifies the location of the suppressions XML file to use.This parameter is resolved as resource, URL, then file. If successfully resolved, the contents of the suppressions XML is copied into the ${project.build.directory}/checkstyle-supressions.xml file before being passed to Checkstyle for loading.See suppressionsFileExpression for the property that will be made available to your checkstyle configuration.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "testSourceDirectory (Default: '${project.build.testSourceDirectory}')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Specifies the location of the test source directory to be used for Checkstyle.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "useFile", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "If null, the Checkstyle plugin will display violations on stdout. Otherwise, a text file will be created with the violations.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "xrefLocation (Default: '${project.reporting.outputDirectory}/xref')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Location of the Xrefs to link to.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        }

        sb.append( "\n" );

        sb.append( "checkstyle:help" ).append( "\n" );
        for ( Iterator it = toLines( "Display help information on 'org.apache.maven.plugins:maven-checkstyle-plugin' plugin. Call 'mvn checkstyle:help -Ddetail=true' to display all details." ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
        if ( detail )
        {
            sb.append( "\n" );

            sb.append( repeat( " ", 2 ) );
            sb.append( "Available parameters:" ).append( "\n" );

            sb.append( "\n" );

        for ( Iterator it = toLines( "detail (Default: 'false')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "If true, display all settable properies for each goal.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        }

        sb.append( "\n" );

        sb.append( "checkstyle:check" ).append( "\n" );
        for ( Iterator it = toLines( "Perform a violation check against the last Checkstyle run to see if there are any violations. It reads the Checkstyle output file, counts the number of violations found and displays it on the console." ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
        if ( detail )
        {
            sb.append( "\n" );

            sb.append( repeat( " ", 2 ) );
            sb.append( "Available parameters:" ).append( "\n" );

            sb.append( "\n" );

        for ( Iterator it = toLines( "failOnViolation (Default: 'true')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Do we fail the build on a violation?", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "outputFile (Default: '${project.build.directory}/checkstyle-result.xml')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Specifies the path and filename to save the Checkstyle output. The format of the output file is determined by the outputFileFormat parameter.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "outputFileFormat (Default: 'xml')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Specifies the format of the output to be used when writing to the output file. Valid values are 'plain' and 'xml'.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "skip (Default: 'false')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Skip entire check.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "violationSeverity (Default: 'error')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "The lowest severity level that is considered a violation. Valid values are 'error', 'warning' and 'info'.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        }

        sb.append( "\n" );

        sb.append( "checkstyle:help" ).append( "\n" );
        for ( Iterator it = toLines( "Display help information on 'org.apache.maven.plugins:maven-checkstyle-plugin' plugin. Call 'mvn checkstyle:help -Ddetail=true' to display all details." ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /**
     * <p>Give a list of lines for the <code>str</code>. Each line is indented by 4 spaces
     * and has a maximum of <code>80</code> characters.</p>
     *
     * @param str String to split in lines
     * @return List of lines
     * @throws NullPointerException if str is <code>null</code>
     */
    private static List toLines( String str )
    {
        return toLines( str, DEFAULT_INDENT, DEFAULT_WIDTH );
    }

    /**
     * <p>Give a list of lines for the <code>str</code>. Each line is indented by <code>indent</code>
     * and has a maximum of <code>size</code> characters.</p>
     *
     * @param str String to split in lines
     * @param indent the string to precede each line
     * @param size the size of the character display buffer
     * @return List of lines
     * @throws IllegalArgumentException if <code>size < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static List toLines( String str, String indent, int size )
    {
        List sentences = new ArrayList();

        if ( indent == null )
        {
            indent = "";
        }

        if ( size < 0 )
        {
            throw new IllegalArgumentException( "size should be positive" );
        }

        StringBuffer tmp = new StringBuffer( indent );
        StringTokenizer tokenizer = new StringTokenizer( str, " " );
        while ( tokenizer.hasMoreTokens() )
        {
            String word = tokenizer.nextToken();

            if ( tmp.length() + word.length() + 1 < size )
            {
                tmp.append( word ).append( " " );
            }
            else
            {
                sentences.add( tmp.toString() );
                tmp = new StringBuffer( indent );
                tmp.append( word ).append( " " );
            }
        }

        if ( tmp.toString().length() > 0 )
        {
            sentences.add( tmp.toString() );
        }

        return sentences;
    }
}
