/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.clover;

import com.cenqua.clover.CloverInstr;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.clover.internal.AbstractCloverMojo;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.SimpleSourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.SourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;
import org.codehaus.plexus.util.FileUtils;

public class CloverInstrumentInternalMojo
extends AbstractCloverMojo {
    private String cloverOutputDirectory;
    private List pluginArtifacts;
    private ArtifactFactory artifactFactory;
    private ArtifactResolver artifactResolver;
    private ArtifactRepository localRepository;
    private Set includes = new HashSet();
    private Set excludes = new HashSet();
    private boolean includesAllSourceRoots;
    private String cloverOutputSourceDirectory;

    public void execute() throws MojoExecutionException {
        new File(this.cloverOutputDirectory).mkdirs();
        this.cloverOutputSourceDirectory = new File(this.cloverOutputDirectory, "src").getPath();
        new File(this.getCloverDatabase()).getParentFile().mkdirs();
        super.execute();
        this.logArtifacts("before changes");
        if (this.isJavaProject()) {
            Map filesToInstrument = this.computeFilesToInstrument();
            if (filesToInstrument.isEmpty()) {
                this.getLog().warn((CharSequence)"No Clover instrumentation done as no matching sources files found");
            } else {
                this.instrumentSources(filesToInstrument);
                this.copyExcludedFiles();
            }
        }
        this.swizzleCloverDependencies();
        this.addCloverDependencyToCompileClasspath();
        this.redirectSourceDirectories();
        this.redirectOutputDirectories();
        this.redirectArtifact();
        this.logArtifacts("after changes");
    }

    private boolean isJavaProject() {
        boolean isJavaProject;
        ArtifactHandler artifactHandler = this.getProject().getArtifact().getArtifactHandler();
        if ("java".equals(artifactHandler.getLanguage())) {
            isJavaProject = true;
        } else {
            this.getLog().info((CharSequence)"Not instrumenting sources with Clover as this is not a Java project.");
            isJavaProject = false;
        }
        return isJavaProject;
    }

    private void instrumentSources(Map filesToInstrument) throws MojoExecutionException {
        int result = CloverInstr.mainImpl((String[])this.createCliArgs(filesToInstrument));
        if (result != 0) {
            throw new MojoExecutionException("Clover has failed to instrument the source files");
        }
    }

    private void copyExcludedFiles() throws MojoExecutionException {
        Map filesToCopy = this.computeExcludedFilesToCopy();
        Iterator sourceRoots = filesToCopy.keySet().iterator();
        while (sourceRoots.hasNext()) {
            String sourceRoot = (String)sourceRoots.next();
            Set filesInSourceRoot = (Set)filesToCopy.get(sourceRoot);
            Iterator files = filesInSourceRoot.iterator();
            while (files.hasNext()) {
                File file = (File)files.next();
                try {
                    FileUtils.copyFile((File)file, (File)new File(this.cloverOutputSourceDirectory, file.getPath().substring(sourceRoot.length())));
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed to copy excluded file [" + file + "] to [" + this.cloverOutputSourceDirectory + "]", (Exception)e);
                }
            }
        }
    }

    private void redirectOutputDirectories() {
        this.getProject().getBuild().setDirectory(this.cloverOutputDirectory);
        this.getProject().getBuild().setOutputDirectory(new File(this.cloverOutputDirectory, "classes").getPath());
        new File(this.getProject().getBuild().getOutputDirectory()).mkdirs();
        this.getProject().getBuild().setTestOutputDirectory(new File(this.cloverOutputDirectory, "test-classes").getPath());
    }

    private void redirectSourceDirectories() {
        String oldSourceDirectory = this.getProject().getBuild().getSourceDirectory();
        if (new File(oldSourceDirectory).exists()) {
            this.getProject().getBuild().setSourceDirectory(this.cloverOutputSourceDirectory);
        }
        this.getLog().debug((CharSequence)"Clover source directories before change:");
        this.logSourceDirectories();
        ArrayList sourceRoots = new ArrayList(this.getProject().getCompileSourceRoots());
        this.getProject().getCompileSourceRoots().removeAll(sourceRoots);
        Iterator i = sourceRoots.iterator();
        while (i.hasNext()) {
            String sourceRoot = (String)i.next();
            if (new File(oldSourceDirectory).exists() && sourceRoot.equals(oldSourceDirectory)) {
                this.getProject().addCompileSourceRoot(this.getProject().getBuild().getSourceDirectory());
                continue;
            }
            this.getProject().addCompileSourceRoot(sourceRoot);
        }
        this.getLog().debug((CharSequence)"Clover source directories after change:");
        this.logSourceDirectories();
    }

    private void redirectArtifact() {
        if (!this.getProject().getPackaging().equals("pom")) {
            Artifact oldArtifact = this.getProject().getArtifact();
            Artifact newArtifact = this.artifactFactory.createArtifactWithClassifier(oldArtifact.getGroupId(), oldArtifact.getArtifactId(), oldArtifact.getVersion(), oldArtifact.getType(), "clover");
            this.getProject().setArtifact(newArtifact);
            this.getProject().getBuild().setFinalName(this.getProject().getArtifactId() + "-" + this.getProject().getVersion() + "-clover");
        }
    }

    private void logSourceDirectories() {
        if (this.getLog().isDebugEnabled()) {
            Iterator i = this.getProject().getCompileSourceRoots().iterator();
            while (i.hasNext()) {
                String sourceRoot = (String)i.next();
                this.getLog().debug((CharSequence)("[Clover]  source root [" + sourceRoot + "]"));
            }
        }
    }

    private void swizzleCloverDependencies() {
        this.getProject().setDependencyArtifacts(this.swizzleCloverDependencies(this.getProject().getDependencyArtifacts()));
        this.getProject().setArtifacts(this.swizzleCloverDependencies(this.getProject().getArtifacts()));
    }

    protected Set swizzleCloverDependencies(Set artifacts) {
        HashSet<Artifact> resolvedArtifacts = new HashSet<Artifact>();
        Iterator i = artifacts.iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            if (artifact.getClassifier() == null) {
                Artifact cloveredArtifact = this.artifactFactory.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType(), "clover");
                try {
                    this.artifactResolver.resolve(cloveredArtifact, new ArrayList(), this.localRepository);
                    cloveredArtifact.setScope(artifact.getScope());
                    if (cloveredArtifact.getFile().lastModified() < artifact.getFile().lastModified()) {
                        this.getLog().warn((CharSequence)("Using [" + artifact.getId() + "] even though a Clovered version exists " + "but it's older and could fail the build. Please consider running Clover again on that " + "dependency's project."));
                        resolvedArtifacts.add(artifact);
                        continue;
                    }
                    resolvedArtifacts.add(cloveredArtifact);
                }
                catch (ArtifactResolutionException e) {
                    resolvedArtifacts.add(artifact);
                }
                catch (ArtifactNotFoundException e) {
                    resolvedArtifacts.add(artifact);
                }
                continue;
            }
            resolvedArtifacts.add(artifact);
        }
        return resolvedArtifacts;
    }

    protected Artifact findCloverArtifact(List pluginArtifacts) {
        Artifact cloverArtifact = null;
        Iterator artifacts = pluginArtifacts.iterator();
        while (artifacts.hasNext() && cloverArtifact == null) {
            Artifact artifact = (Artifact)artifacts.next();
            if (!"com.cenqua.clover".equals(artifact.getGroupId()) || !"clover".equals(artifact.getArtifactId())) continue;
            cloverArtifact = artifact;
        }
        return cloverArtifact;
    }

    private void addCloverDependencyToCompileClasspath() throws MojoExecutionException {
        Artifact cloverArtifact = this.findCloverArtifact(this.pluginArtifacts);
        if (cloverArtifact == null) {
            throw new MojoExecutionException("Couldn't find [com.cenqua.cover:clover] artifact in plugin dependencies");
        }
        cloverArtifact = this.artifactFactory.createArtifact(cloverArtifact.getGroupId(), cloverArtifact.getArtifactId(), cloverArtifact.getVersion(), "compile", cloverArtifact.getType());
        HashSet<Artifact> set = new HashSet<Artifact>(this.getProject().getDependencyArtifacts());
        set.add(cloverArtifact);
        this.getProject().setDependencyArtifacts(set);
    }

    private void logArtifacts(String message) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("[Clover] List of dependency artifacts " + message + ":"));
            this.logArtifacts(this.getProject().getDependencyArtifacts());
            this.getLog().debug((CharSequence)("[Clover] List of artifacts " + message + ":"));
            this.logArtifacts(this.getProject().getArtifacts());
        }
    }

    private void logArtifacts(Set artifacts) {
        Iterator i = artifacts.iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            this.getLog().debug((CharSequence)("[Clover]   Artifact [" + artifact.getId() + "], scope = [" + artifact.getScope() + "]"));
        }
    }

    private SourceInclusionScanner getScanner() {
        SimpleSourceInclusionScanner scanner = null;
        if (this.includes.isEmpty() && this.excludes.isEmpty()) {
            this.includes = Collections.singleton("**/*.java");
            scanner = new SimpleSourceInclusionScanner(this.includes, Collections.EMPTY_SET);
        } else {
            if (this.includes.isEmpty()) {
                this.includes.add("**/*.java");
            }
            scanner = new SimpleSourceInclusionScanner(this.includes, this.excludes);
        }
        scanner.addSourceMapping((SourceMapping)new SuffixMapping("dummy", "dummy"));
        return scanner;
    }

    private SourceInclusionScanner getExcludesScanner() {
        SimpleSourceInclusionScanner scanner = null;
        scanner = this.excludes.isEmpty() ? new SimpleSourceInclusionScanner(Collections.EMPTY_SET, Collections.EMPTY_SET) : new SimpleSourceInclusionScanner(this.excludes, Collections.EMPTY_SET);
        scanner.addSourceMapping((SourceMapping)new SuffixMapping("dummy", "dummy"));
        return scanner;
    }

    private Map computeExcludedFilesToCopy() {
        return this.computeFiles(this.getExcludesScanner());
    }

    private Map computeFilesToInstrument() {
        return this.computeFiles(this.getScanner());
    }

    private Map computeFiles(SourceInclusionScanner scanner) {
        HashMap<String, Set> files = new HashMap<String, Set>();
        Iterator sourceRoots = this.getSourceRoots().iterator();
        while (sourceRoots.hasNext()) {
            File sourceRoot = new File((String)sourceRoots.next());
            if (!sourceRoot.exists()) continue;
            try {
                files.put(sourceRoot.getPath(), scanner.getIncludedSources(sourceRoot, null));
            }
            catch (InclusionScanException e) {
                this.getLog().warn((CharSequence)("Failed to add sources from [" + sourceRoot + "]"), (Throwable)e);
            }
        }
        return files;
    }

    private List getSourceRoots() {
        List<String> sourceRoots = this.includesAllSourceRoots ? this.getProject().getCompileSourceRoots() : Collections.singletonList(this.getProject().getBuild().getSourceDirectory());
        return sourceRoots;
    }

    private String[] createCliArgs(Map filesToInstrument) throws MojoExecutionException {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("-p");
        parameters.add(this.getFlushPolicy());
        parameters.add("-f");
        parameters.add("" + this.getFlushInterval());
        parameters.add("-i");
        parameters.add(this.getCloverDatabase());
        parameters.add("-d");
        parameters.add(this.cloverOutputSourceDirectory);
        if (this.getLog().isDebugEnabled()) {
            parameters.add("-v");
        }
        if (this.getJdk() != null) {
            if (this.getJdk().equals("1.4")) {
                parameters.add("-jdk14");
            } else if (this.getJdk().equals("1.5")) {
                parameters.add("-jdk15");
            } else {
                throw new MojoExecutionException("Unsupported jdk version [" + this.getJdk() + "]. Valid values are [1.4] and [1.5]");
            }
        }
        Iterator sourceRoots = filesToInstrument.keySet().iterator();
        while (sourceRoots.hasNext()) {
            Set filesInSourceRoot = (Set)filesToInstrument.get((String)sourceRoots.next());
            Iterator files = filesInSourceRoot.iterator();
            while (files.hasNext()) {
                File file = (File)files.next();
                parameters.add(file.getPath());
            }
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"Parameter list being passed to Clover CLI:");
            Iterator it = parameters.iterator();
            while (it.hasNext()) {
                String param = (String)it.next();
                this.getLog().debug((CharSequence)("  parameter = [" + param + "]"));
            }
        }
        return parameters.toArray(new String[0]);
    }

    protected void setArtifactFactory(ArtifactFactory artifactFactory) {
        this.artifactFactory = artifactFactory;
    }

    protected void setArtifactResolver(ArtifactResolver artifactResolver) {
        this.artifactResolver = artifactResolver;
    }
}

