package org.apache.maven.plugin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on maven-compiler-plugin.<br/> Call <pre>  mvn compiler:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Mon May 17 23:18:31 CEST 2010
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.6)
 * @goal help
 * @requiresProject false
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.apache.maven.plugins:maven-compiler-plugin:2.3.1", 0 );
        append( sb, "", 0 );

        append( sb, "Maven Compiler Plugin", 0 );
        append( sb, "The Compiler Plugin is used to compile the sources of your project.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 3 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "compile".equals( goal ) )
        {
            append( sb, "compiler:compile", 0 );
            append( sb, "Compiles application sources", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "annotationProcessors", 2 );
                append( sb, "Names of annotation processors to run. Only applies to JDK 1.6+ If not set, the default annotation processors discovery process applies.\n", 3 );
                append( sb, "", 0 );

                append( sb, "compilerArgument", 2 );
                append( sb, "Sets the unformatted argument string to be passed to the compiler if fork is set to true.\n\nThis is because the list of valid arguments passed to a Java compiler varies based on the compiler version.\n", 3 );
                append( sb, "", 0 );

                append( sb, "compilerArguments", 2 );
                append( sb, "Sets the arguments to be passed to the compiler (prepending a dash) if fork is set to true.\n\nThis is because the list of valid arguments passed to a Java compiler varies based on the compiler version.\n", 3 );
                append( sb, "", 0 );

                append( sb, "compilerId (Default: javac)", 2 );
                append( sb, "The compiler id of the compiler to use. See this guide for more information.", 3 );
                append( sb, "", 0 );

                append( sb, "compilerVersion", 2 );
                append( sb, "Version of the compiler to use, ex. \'1.3\', \'1.5\', if fork is set to true.", 3 );
                append( sb, "", 0 );

                append( sb, "debug (Default: true)", 2 );
                append( sb, "Set to true to include debugging information in the compiled class files.", 3 );
                append( sb, "", 0 );

                append( sb, "debuglevel", 2 );
                append( sb, "Keyword list to be appended to the -g command-line switch. Legal values are none or a comma-separated list of the following keywords: lines, vars, and source. If debuglevel is not specified, by default, nothing will be appended to -g. If debug is not turned on, this attribute will be ignored.", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "The -encoding argument for the Java compiler.", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "A list of exclusion filters for the compiler.", 3 );
                append( sb, "", 0 );

                append( sb, "executable", 2 );
                append( sb, "Sets the executable of the compiler to use when fork is true.", 3 );
                append( sb, "", 0 );

                append( sb, "failOnError (Default: true)", 2 );
                append( sb, "Indicates whether the build will continue even if there are compilation errors; defaults to true.", 3 );
                append( sb, "", 0 );

                append( sb, "fork (Default: false)", 2 );
                append( sb, "Allows running the compiler in a separate process. If \'false\' it uses the built in compiler, while if \'true\' it will use an executable.", 3 );
                append( sb, "", 0 );

                append( sb, "generatedSourcesDirectory (Default: ${project.build.directory}/generated-sources/annotations)", 2 );
                append( sb, "Specify where to place generated source files created by annotation processing. Only applies to JDK 1.6+\n", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "A list of inclusion filters for the compiler.", 3 );
                append( sb, "", 0 );

                append( sb, "maxmem", 2 );
                append( sb, "Sets the maximum size, in megabytes, of the memory allocation pool, ex. \'128\', \'128m\' if fork is set to true.", 3 );
                append( sb, "", 0 );

                append( sb, "meminitial", 2 );
                append( sb, "Initial size, in megabytes, of the memory allocation pool, ex. \'64\', \'64m\' if fork is set to true.", 3 );
                append( sb, "", 0 );

                append( sb, "optimize (Default: false)", 2 );
                append( sb, "Set to true to optimize the compiled code using the compiler\'s optimization methods.", 3 );
                append( sb, "", 0 );

                append( sb, "outputFileName", 2 );
                append( sb, "Sets the name of the output file when compiling a set of sources to a single file.", 3 );
                append( sb, "", 0 );

                append( sb, "proc", 2 );
                append( sb, "Sets whether annotation processing is performed or not. Only applies to JDK 1.6+ If not set, both compilation and annotation processing are performed at the same time.\n\nAllowed values are: none - no annotation processing is performed. only - only annotation processing is done, no compilation.\n", 3 );
                append( sb, "", 0 );

                append( sb, "showDeprecation (Default: false)", 2 );
                append( sb, "Sets whether to show source locations where deprecated APIs are used.", 3 );
                append( sb, "", 0 );

                append( sb, "showWarnings (Default: false)", 2 );
                append( sb, "Set to true to show compilation warnings.", 3 );
                append( sb, "", 0 );

                append( sb, "source (Default: 1.5)", 2 );
                append( sb, "The -source argument for the Java compiler.", 3 );
                append( sb, "", 0 );

                append( sb, "staleMillis (Default: 0)", 2 );
                append( sb, "Sets the granularity in milliseconds of the last modification date for testing whether a source needs recompilation.", 3 );
                append( sb, "", 0 );

                append( sb, "target (Default: 1.5)", 2 );
                append( sb, "The -target argument for the Java compiler.", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: false)", 2 );
                append( sb, "Set to true to show messages about what the compiler is doing.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "compiler:help", 0 );
            append( sb, "Display help information on maven-compiler-plugin.\nCall\n\u00a0\u00a0mvn\u00a0compiler:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "testCompile".equals( goal ) )
        {
            append( sb, "compiler:testCompile", 0 );
            append( sb, "Compiles application test sources.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "annotationProcessors", 2 );
                append( sb, "Names of annotation processors to run. Only applies to JDK 1.6+ If not set, the default annotation processors discovery process applies.\n", 3 );
                append( sb, "", 0 );

                append( sb, "compilerArgument", 2 );
                append( sb, "Sets the unformatted argument string to be passed to the compiler if fork is set to true.\n\nThis is because the list of valid arguments passed to a Java compiler varies based on the compiler version.\n", 3 );
                append( sb, "", 0 );

                append( sb, "compilerArguments", 2 );
                append( sb, "Sets the arguments to be passed to the compiler (prepending a dash) if fork is set to true.\n\nThis is because the list of valid arguments passed to a Java compiler varies based on the compiler version.\n", 3 );
                append( sb, "", 0 );

                append( sb, "compilerId (Default: javac)", 2 );
                append( sb, "The compiler id of the compiler to use. See this guide for more information.", 3 );
                append( sb, "", 0 );

                append( sb, "compilerVersion", 2 );
                append( sb, "Version of the compiler to use, ex. \'1.3\', \'1.5\', if fork is set to true.", 3 );
                append( sb, "", 0 );

                append( sb, "debug (Default: true)", 2 );
                append( sb, "Set to true to include debugging information in the compiled class files.", 3 );
                append( sb, "", 0 );

                append( sb, "debuglevel", 2 );
                append( sb, "Keyword list to be appended to the -g command-line switch. Legal values are none or a comma-separated list of the following keywords: lines, vars, and source. If debuglevel is not specified, by default, nothing will be appended to -g. If debug is not turned on, this attribute will be ignored.", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "The -encoding argument for the Java compiler.", 3 );
                append( sb, "", 0 );

                append( sb, "executable", 2 );
                append( sb, "Sets the executable of the compiler to use when fork is true.", 3 );
                append( sb, "", 0 );

                append( sb, "failOnError (Default: true)", 2 );
                append( sb, "Indicates whether the build will continue even if there are compilation errors; defaults to true.", 3 );
                append( sb, "", 0 );

                append( sb, "fork (Default: false)", 2 );
                append( sb, "Allows running the compiler in a separate process. If \'false\' it uses the built in compiler, while if \'true\' it will use an executable.", 3 );
                append( sb, "", 0 );

                append( sb, "generatedTestSourcesDirectory (Default: ${project.build.directory}/generated-sources/test-annotations)", 2 );
                append( sb, "Specify where to place generated source files created by annotation processing. Only applies to JDK 1.6+\n", 3 );
                append( sb, "", 0 );

                append( sb, "maxmem", 2 );
                append( sb, "Sets the maximum size, in megabytes, of the memory allocation pool, ex. \'128\', \'128m\' if fork is set to true.", 3 );
                append( sb, "", 0 );

                append( sb, "meminitial", 2 );
                append( sb, "Initial size, in megabytes, of the memory allocation pool, ex. \'64\', \'64m\' if fork is set to true.", 3 );
                append( sb, "", 0 );

                append( sb, "optimize (Default: false)", 2 );
                append( sb, "Set to true to optimize the compiled code using the compiler\'s optimization methods.", 3 );
                append( sb, "", 0 );

                append( sb, "outputFileName", 2 );
                append( sb, "Sets the name of the output file when compiling a set of sources to a single file.", 3 );
                append( sb, "", 0 );

                append( sb, "proc", 2 );
                append( sb, "Sets whether annotation processing is performed or not. Only applies to JDK 1.6+ If not set, both compilation and annotation processing are performed at the same time.\n\nAllowed values are: none - no annotation processing is performed. only - only annotation processing is done, no compilation.\n", 3 );
                append( sb, "", 0 );

                append( sb, "showDeprecation (Default: false)", 2 );
                append( sb, "Sets whether to show source locations where deprecated APIs are used.", 3 );
                append( sb, "", 0 );

                append( sb, "showWarnings (Default: false)", 2 );
                append( sb, "Set to true to show compilation warnings.", 3 );
                append( sb, "", 0 );

                append( sb, "skip", 2 );
                append( sb, "Set this to \'true\' to bypass unit tests entirely. Its use is NOT RECOMMENDED, but quite convenient on occasion.", 3 );
                append( sb, "", 0 );

                append( sb, "source (Default: 1.5)", 2 );
                append( sb, "The -source argument for the Java compiler.", 3 );
                append( sb, "", 0 );

                append( sb, "staleMillis (Default: 0)", 2 );
                append( sb, "Sets the granularity in milliseconds of the last modification date for testing whether a source needs recompilation.", 3 );
                append( sb, "", 0 );

                append( sb, "target (Default: 1.5)", 2 );
                append( sb, "The -target argument for the Java compiler.", 3 );
                append( sb, "", 0 );

                append( sb, "testCompilerArgument", 2 );
                append( sb, "Sets the unformatted argument string to be passed to test compiler if fork is set to true.\n\nThis is because the list of valid arguments passed to a Java compiler varies based on the compiler version.\n", 3 );
                append( sb, "", 0 );

                append( sb, "testCompilerArguments", 2 );
                append( sb, "Sets the arguments to be passed to test compiler (prepending a dash) if fork is set to true.\n\nThis is because the list of valid arguments passed to a Java compiler varies based on the compiler version.\n", 3 );
                append( sb, "", 0 );

                append( sb, "testExcludes", 2 );
                append( sb, "A list of exclusion filters for the compiler.", 3 );
                append( sb, "", 0 );

                append( sb, "testIncludes", 2 );
                append( sb, "A list of inclusion filters for the compiler.", 3 );
                append( sb, "", 0 );

                append( sb, "testSource", 2 );
                append( sb, "The -source argument for the test Java compiler.", 3 );
                append( sb, "", 0 );

                append( sb, "testTarget", 2 );
                append( sb, "The -target argument for the test Java compiler.", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: false)", 2 );
                append( sb, "Set to true to show messages about what the compiler is doing.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
