/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.plugin.compiler.ModuleInfoParser;
import org.objectweb.asm.ClassReader;

public class AsmModuleInfoParser
implements ModuleInfoParser {
    @Override
    public String getModuleName(File modulePath) throws IOException {
        InputStream in = this.getModuleInfoClass(modulePath);
        ClassReader reader = new ClassReader(in);
        String className = reader.getClassName();
        int index = className.indexOf("/module-info");
        String moduleName = index >= 1 ? className.substring(0, index).replace('/', '.') : null;
        return moduleName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getModuleInfoClass(File modulePath) throws FileNotFoundException, IOException {
        InputStream in;
        if (modulePath.isDirectory()) {
            in = new FileInputStream(new File(modulePath, "module-info.class"));
        } else {
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(modulePath);
                JarEntry moduleInfo = jarFile.getJarEntry("/module-info.class");
                in = jarFile.getInputStream(moduleInfo);
            }
            finally {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
        }
        return in;
    }
}

