/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.compiler;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.JavaToolchain;
import org.apache.maven.api.PathScope;
import org.apache.maven.api.ProjectScope;
import org.apache.maven.api.Toolchain;
import org.apache.maven.api.plugin.MojoException;
import org.apache.maven.api.plugin.annotations.Mojo;
import org.apache.maven.api.plugin.annotations.Parameter;
import org.apache.maven.plugin.compiler.AbstractCompilerMojo;
import org.codehaus.plexus.compiler.util.scan.SimpleSourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.SourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.languages.java.jpms.JavaModuleDescriptor;
import org.codehaus.plexus.languages.java.jpms.LocationManager;
import org.codehaus.plexus.languages.java.jpms.ResolvePathsRequest;
import org.codehaus.plexus.languages.java.jpms.ResolvePathsResult;

@Mojo(name="testCompile", defaultPhase="test-compile")
public class TestCompilerMojo
extends AbstractCompilerMojo {
    @Parameter(property="maven.test.skip")
    private boolean skip;
    @Parameter
    private List<String> compileSourceRoots;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    private Path mainOutputDirectory;
    @Parameter(defaultValue="${project.build.testOutputDirectory}", required=true)
    private Path outputDirectory;
    @Parameter
    private Set<String> testIncludes = new HashSet<String>();
    @Parameter
    private Set<String> testExcludes = new HashSet<String>();
    @Parameter
    private Set<String> testIncrementalExcludes = new HashSet<String>();
    @Parameter(property="maven.compiler.testSource")
    private String testSource;
    @Parameter(property="maven.compiler.testTarget")
    private String testTarget;
    @Parameter(property="maven.compiler.testRelease")
    private String testRelease;
    @Parameter
    private Map<String, String> testCompilerArguments;
    @Parameter
    private String testCompilerArgument;
    @Parameter(defaultValue="${project.build.directory}/generated-test-sources/test-annotations")
    private Path generatedTestSourcesDirectory;
    @Parameter(defaultValue="true")
    private boolean useModulePath;
    @Parameter
    private List<String> testPath;
    @Parameter(defaultValue="javac-test")
    private String debugFileName;
    final LocationManager locationManager = new LocationManager();
    private Map<String, JavaModuleDescriptor> pathElements;
    private List<String> classpathElements;
    private List<String> modulepathElements;

    @Override
    public void execute() throws MojoException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Not compiling test sources");
            return;
        }
        super.execute();
    }

    @Override
    protected List<Path> getCompileSourceRoots() {
        if (this.compileSourceRoots == null || this.compileSourceRoots.isEmpty()) {
            return this.projectManager.getCompileSourceRoots(this.getProject(), ProjectScope.TEST);
        }
        return this.compileSourceRoots.stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
    }

    @Override
    protected Map<String, JavaModuleDescriptor> getPathElements() {
        return this.pathElements;
    }

    @Override
    protected List<String> getClasspathElements() {
        return this.classpathElements;
    }

    @Override
    protected List<String> getModulepathElements() {
        return this.modulepathElements;
    }

    @Override
    protected Path getOutputDirectory() {
        return this.outputDirectory;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void preparePaths(Set<Path> sourceFiles) {
        Path root;
        Iterator<Path> iterator;
        StringBuilder patchModuleValue;
        ResolvePathsResult result;
        Optional<Toolchain> toolchain;
        ResolvePathsRequest request;
        void var2_4;
        List<String> list = this.testPath;
        if (list == null) {
            Stream<String> s1 = Stream.of(this.outputDirectory.toString(), this.mainOutputDirectory.toString());
            Stream<String> s2 = this.session.resolveDependencies(this.getProject(), PathScope.TEST_COMPILE).stream().map(Path::toString);
            List list2 = Stream.concat(s1, s2).collect(Collectors.toList());
        }
        Path mainOutputDirectory = Paths.get(this.getProject().getBuild().getOutputDirectory(), new String[0]);
        Path mainModuleDescriptorClassFile = mainOutputDirectory.resolve("module-info.class");
        JavaModuleDescriptor mainModuleDescriptor = null;
        Path testModuleDescriptorJavaFile = Paths.get("module-info.java", new String[0]);
        JavaModuleDescriptor testModuleDescriptor = null;
        for (Path sourceFile : sourceFiles) {
            if (!"module-info.java".equals(sourceFile.getFileName().toString())) continue;
            testModuleDescriptorJavaFile = sourceFile;
            break;
        }
        if (Files.exists(mainModuleDescriptorClassFile, new LinkOption[0])) {
            try {
                request = ResolvePathsRequest.ofStrings((Collection)var2_4).setIncludeStatic(true).setMainModuleDescriptor((Object)mainModuleDescriptorClassFile.toAbsolutePath().toString());
                toolchain = this.getToolchain();
                if (toolchain.isPresent() && toolchain.get() instanceof JavaToolchain) {
                    request.setJdkHome((Object)((JavaToolchain)toolchain.get()).getJavaHome());
                }
                result = this.locationManager.resolvePaths(request);
                for (Map.Entry pathException : result.getPathExceptions().entrySet()) {
                    Throwable cause = (Throwable)pathException.getValue();
                    while (cause.getCause() != null) {
                        cause = cause.getCause();
                    }
                    String fileName = Paths.get((String)pathException.getKey(), new String[0]).getFileName().toString();
                    this.getLog().warn((CharSequence)("Can't extract module name from " + fileName + ": " + cause.getMessage()));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            mainModuleDescriptor = result.getMainModuleDescriptor();
            this.pathElements = new LinkedHashMap<String, JavaModuleDescriptor>(result.getPathElements().size());
            this.pathElements.putAll(result.getPathElements());
            this.modulepathElements = new ArrayList(result.getModulepathElements().keySet());
            this.classpathElements = new ArrayList<String>(result.getClasspathElements());
        }
        if (Files.exists(testModuleDescriptorJavaFile, new LinkOption[0])) {
            try {
                request = ResolvePathsRequest.ofStrings((Collection)var2_4).setMainModuleDescriptor((Object)testModuleDescriptorJavaFile.toAbsolutePath().toString());
                toolchain = this.getToolchain();
                if (toolchain.isPresent() && toolchain.get() instanceof JavaToolchain) {
                    request.setJdkHome((Object)((JavaToolchain)toolchain.get()).getJavaHome());
                }
                result = this.locationManager.resolvePaths(request);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            testModuleDescriptor = result.getMainModuleDescriptor();
        }
        if (this.release != null && !this.release.isEmpty()) {
            if (Integer.parseInt(this.release) < 9) {
                this.pathElements = Collections.emptyMap();
                this.modulepathElements = Collections.emptyList();
                this.classpathElements = var2_4;
                return;
            }
        } else if (Double.parseDouble(this.getTarget()) < Double.parseDouble("1.9")) {
            this.pathElements = Collections.emptyMap();
            this.modulepathElements = Collections.emptyList();
            this.classpathElements = var2_4;
            return;
        }
        if (testModuleDescriptor != null) {
            this.modulepathElements = var2_4;
            this.classpathElements = Collections.emptyList();
            if (mainModuleDescriptor == null) {
                if (Files.exists(mainOutputDirectory, new LinkOption[0])) throw new UnsupportedOperationException("Can't compile test sources when main sources are missing a module descriptor");
                return;
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"Main and test module descriptors exist:");
                this.getLog().debug((CharSequence)("  main module = " + mainModuleDescriptor.name()));
                this.getLog().debug((CharSequence)("  test module = " + testModuleDescriptor.name()));
            }
            if (!testModuleDescriptor.name().equals(mainModuleDescriptor.name())) {
                this.getLog().debug((CharSequence)"Black-box testing - all is ready to compile");
                return;
            }
            if (this.compilerArgs == null) {
                this.compilerArgs = new ArrayList();
            }
            this.compilerArgs.add("--patch-module");
            patchModuleValue = new StringBuilder();
            patchModuleValue.append(testModuleDescriptor.name());
            patchModuleValue.append('=');
            iterator = this.projectManager.getCompileSourceRoots(this.getProject(), ProjectScope.MAIN).iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    this.compilerArgs.add(patchModuleValue.toString());
                    return;
                }
                root = iterator.next();
                if (!Files.exists(root, new LinkOption[0])) continue;
                patchModuleValue.append(root).append(PS);
            }
        }
        if (mainModuleDescriptor == null) {
            this.modulepathElements = Collections.emptyList();
            this.classpathElements = var2_4;
            return;
        }
        if (this.compilerArgs == null) {
            this.compilerArgs = new ArrayList();
        }
        this.compilerArgs.add("--patch-module");
        patchModuleValue = new StringBuilder(mainModuleDescriptor.name()).append('=').append(mainOutputDirectory).append(PS);
        iterator = this.getCompileSourceRoots().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.compilerArgs.add(patchModuleValue.toString());
                this.compilerArgs.add("--add-reads");
                this.compilerArgs.add(mainModuleDescriptor.name() + "=ALL-UNNAMED");
                return;
            }
            root = iterator.next();
            patchModuleValue.append(root).append(PS);
        }
    }

    @Override
    protected SourceInclusionScanner getSourceInclusionScanner(int staleMillis) {
        StaleSourceScanner scanner;
        if (this.testIncludes.isEmpty() && this.testExcludes.isEmpty() && this.testIncrementalExcludes.isEmpty()) {
            scanner = new StaleSourceScanner((long)staleMillis);
        } else {
            if (this.testIncludes.isEmpty()) {
                this.testIncludes.add("**/*.java");
            }
            HashSet<String> excludesIncr = new HashSet<String>(this.testExcludes);
            excludesIncr.addAll(this.testIncrementalExcludes);
            scanner = new StaleSourceScanner((long)staleMillis, this.testIncludes, excludesIncr);
        }
        return scanner;
    }

    @Override
    protected SourceInclusionScanner getSourceInclusionScanner(String inputFileEnding) {
        SimpleSourceInclusionScanner scanner;
        String defaultIncludePattern = "**/*" + (inputFileEnding.startsWith(".") ? "" : ".") + inputFileEnding;
        if (this.testIncludes.isEmpty() && this.testExcludes.isEmpty() && this.testIncrementalExcludes.isEmpty()) {
            this.testIncludes = Collections.singleton(defaultIncludePattern);
            scanner = new SimpleSourceInclusionScanner(this.testIncludes, Collections.emptySet());
        } else {
            if (this.testIncludes.isEmpty()) {
                this.testIncludes.add(defaultIncludePattern);
            }
            HashSet<String> excludesIncr = new HashSet<String>(this.testExcludes);
            excludesIncr.addAll(this.testIncrementalExcludes);
            scanner = new SimpleSourceInclusionScanner(this.testIncludes, excludesIncr);
        }
        return scanner;
    }

    @Override
    protected String getSource() {
        return this.testSource == null ? this.source : this.testSource;
    }

    @Override
    protected String getTarget() {
        return this.testTarget == null ? this.target : this.testTarget;
    }

    @Override
    protected String getRelease() {
        return this.testRelease == null ? this.release : this.testRelease;
    }

    @Override
    protected String getCompilerArgument() {
        return this.testCompilerArgument == null ? this.compilerArgument : this.testCompilerArgument;
    }

    @Override
    protected Path getGeneratedSourcesDirectory() {
        return this.generatedTestSourcesDirectory;
    }

    @Override
    protected String getDebugFileName() {
        return this.debugFileName;
    }

    @Override
    protected boolean isTestCompile() {
        return true;
    }

    @Override
    protected Set<String> getIncludes() {
        return this.testIncludes;
    }

    @Override
    protected Set<String> getExcludes() {
        return this.testExcludes;
    }
}

