/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.plugin;

import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.plugin.AbstractContinuumMojo;
import org.apache.maven.continuum.xmlrpc.project.ProjectSummary;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public abstract class AbstractAddProject
extends AbstractContinuumMojo {
    private String projectName;
    private String projectVersion;
    private String scmUrl;
    private String scmUsernme;
    private String scmPassword;
    private String scmTag;
    private boolean scmUseCredentialsCache;
    private String projectGroupId;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ProjectSummary project = new ProjectSummary();
        project.setName(this.projectName);
        project.setVersion(this.projectVersion);
        project.setScmUrl(this.scmUrl);
        project.setScmUsername(this.scmUsernme);
        project.setScmPassword(this.scmPassword);
        project.setScmTag(this.scmTag);
        project.setScmUseCache(this.scmUseCredentialsCache);
        try {
            if (this.projectGroupId != null && this.projectGroupId.length() > 0) {
                if ("ant".equals(this.getProjectType())) {
                    this.getClient().addAntProject(project, Integer.parseInt(this.projectGroupId));
                } else {
                    this.getClient().addShellProject(project, Integer.parseInt(this.projectGroupId));
                }
            } else if ("ant".equals(this.getProjectType())) {
                this.getClient().addAntProject(project);
            } else {
                this.getClient().addShellProject(project);
            }
        }
        catch (ContinuumException e) {
            throw new MojoExecutionException("Can't add the " + this.getProjectType() + " project.", (Exception)((Object)e));
        }
    }

    protected abstract String getProjectType();
}

