/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency.utils.filters;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.dependency.utils.filters.ArtifactsFilter;
import org.apache.maven.plugin.logging.Log;

public class FilterArtifacts {
    private ArrayList filters = new ArrayList();

    public void clearFilters() {
        this.filters.clear();
    }

    public void addFilter(ArtifactsFilter filter) {
        if (filter != null) {
            this.filters.add(filter);
        }
    }

    public void addFilter(int index, ArtifactsFilter filter) {
        if (filter != null) {
            this.filters.add(index, filter);
        }
    }

    public Set filter(Set artifacts, Log log) throws MojoExecutionException {
        Iterator filterIterator = ((AbstractList)this.filters).iterator();
        while (filterIterator.hasNext()) {
            ArtifactsFilter filter = (ArtifactsFilter)filterIterator.next();
            try {
                artifacts = filter.filter(artifacts, log);
            }
            catch (NullPointerException e) {}
        }
        return artifacts;
    }

    public ArrayList getFilters() {
        return this.filters;
    }

    public void setFilters(ArrayList filters) {
        this.filters = filters;
    }
}

