/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency;

import java.util.Iterator;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.dependency.AnalyzeDepMgt;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalysis;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalyzer;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalyzerException;

public class AnalyzeMojo
extends AbstractMojo {
    private MavenProject project;
    private boolean failBuild = false;
    private ProjectDependencyAnalyzer analyzer;
    private boolean ignoreDirect = true;
    private boolean ignoreNonCompile = true;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if ("pom".equals(this.project.getPackaging())) {
            this.getLog().info((CharSequence)"Skipping pom project");
            return;
        }
        boolean result = this.checkDependencies();
        if (result && this.failBuild) {
            throw new MojoExecutionException("Found Dependency errors.");
        }
        AnalyzeDepMgt adm = new AnalyzeDepMgt();
        adm.setLog(this.getLog());
        adm.setProject(this.project);
        adm.setFailBuild(this.failBuild);
        adm.setPluginContext(this.getPluginContext());
        adm.setIgnoreDirect(this.ignoreDirect);
        adm.execute();
    }

    private boolean checkDependencies() throws MojoExecutionException {
        boolean result = false;
        try {
            ProjectDependencyAnalysis analysis = this.analyzer.analyze(this.project);
            this.getLog().info((CharSequence)"Used declared dependencies:");
            this.logArtifacts(analysis.getUsedDeclaredArtifacts(), false);
            this.getLog().info((CharSequence)"Used undeclared dependencies:");
            Set usedUndeclared = analysis.getUsedUndeclaredArtifacts();
            this.logArtifacts(usedUndeclared, true);
            this.getLog().info((CharSequence)"Unused declared dependencies:");
            Set unusedDeclared = analysis.getUnusedDeclaredArtifacts();
            if (this.ignoreNonCompile) {
                Iterator iter = unusedDeclared.iterator();
                while (iter.hasNext()) {
                    Artifact artifact = (Artifact)iter.next();
                    if (artifact.getScope().equals("compile")) continue;
                    iter.remove();
                }
            }
            this.logArtifacts(unusedDeclared, false);
            if (usedUndeclared != null && !usedUndeclared.isEmpty() || unusedDeclared != null && !unusedDeclared.isEmpty()) {
                this.getLog().warn((CharSequence)"Potential problems discovered.");
                result = true;
            }
        }
        catch (ProjectDependencyAnalyzerException exception) {
            throw new MojoExecutionException("Cannot analyze dependencies", (Exception)((Object)exception));
        }
        return result;
    }

    private void logArtifacts(Set artifacts, boolean warn) {
        if (artifacts.isEmpty()) {
            if (warn) {
                this.getLog().warn((CharSequence)"   None");
            } else {
                this.getLog().info((CharSequence)"   None");
            }
        } else {
            Iterator iterator = artifacts.iterator();
            while (iterator.hasNext()) {
                Artifact artifact = (Artifact)iterator.next();
                if (warn) {
                    this.getLog().warn((CharSequence)("   " + artifact));
                    continue;
                }
                this.getLog().info((CharSequence)("   " + artifact));
            }
        }
    }
}

