/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.dependency.AbstractDependencyFilterMojo;
import org.apache.maven.plugin.dependency.utils.DependencyUtil;
import org.apache.maven.plugin.dependency.utils.filters.ArtifactsFilter;

public class BuildClasspathMojo
extends AbstractDependencyFilterMojo
implements Comparator {
    private boolean stripVersion = false;
    private String prefix;
    private File cpFile;
    private boolean regenerateFile;

    public void execute() throws MojoExecutionException {
        Set artifacts = this.getResolvedDependencies(true);
        if (artifacts == null || artifacts.isEmpty()) {
            this.getLog().info((CharSequence)"No dependencies found.");
        }
        ArrayList artList = new ArrayList(artifacts);
        StringBuffer sb = new StringBuffer();
        Iterator i = artList.iterator();
        if (i.hasNext()) {
            this.appendArtifactPath((Artifact)i.next(), sb);
            while (i.hasNext()) {
                sb.append(":");
                this.appendArtifactPath((Artifact)i.next(), sb);
            }
        }
        String cpString = sb.toString();
        if (this.cpFile == null) {
            this.getLog().info((CharSequence)("Dependencies classpath:\n" + cpString));
        } else if (this.regenerateFile || !this.isUpdToDate(cpString)) {
            this.storeClasspathFile(cpString);
        } else {
            this.getLog().info((CharSequence)("Skipped writting classpath file '" + this.cpFile + "'.  No changes found."));
        }
    }

    protected void appendArtifactPath(Artifact art, StringBuffer sb) {
        if (this.prefix == null) {
            sb.append(art.getFile());
        } else {
            sb.append(this.prefix);
            sb.append(File.separatorChar);
            sb.append(DependencyUtil.getFormattedFileName(art, this.stripVersion));
        }
    }

    private boolean isUpdToDate(String cpString) {
        try {
            String oldCp = this.readClasspathFile();
            return cpString == oldCp || cpString != null && cpString.equals(oldCp);
        }
        catch (Exception ex) {
            this.getLog().warn((CharSequence)("Error while reading old classpath file '" + this.cpFile + "' for up-to-date check: " + ex));
            return false;
        }
    }

    private void storeClasspathFile(String cpString) throws MojoExecutionException {
        try {
            BufferedWriter w = new BufferedWriter(new FileWriter(this.cpFile));
            try {
                w.write(cpString);
                this.getLog().info((CharSequence)("Written classpath file '" + this.cpFile + "'."));
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Error while writting to classpath file '" + this.cpFile + "': " + ex.toString(), (Exception)ex);
            }
            finally {
                ((Writer)w).close();
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Error while opening/closing classpath file '" + this.cpFile + "': " + ex.toString(), (Exception)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readClasspathFile() throws IOException {
        if (!this.cpFile.isFile()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        BufferedReader r = new BufferedReader(new FileReader(this.cpFile));
        try {
            String l;
            while ((l = r.readLine()) != null) {
                sb.append(l);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            r.close();
        }
    }

    public int compare(Object arg1, Object arg2) {
        if (arg1 instanceof Artifact && arg2 instanceof Artifact) {
            if (arg1 == arg2) {
                return 0;
            }
            if (arg1 == null) {
                return -1;
            }
            if (arg2 == null) {
                return 1;
            }
            Artifact art1 = (Artifact)arg1;
            Artifact art2 = (Artifact)arg2;
            String s1 = art1.getGroupId() + art1.getArtifactId() + art1.getVersion();
            String s2 = art2.getGroupId() + art2.getArtifactId() + art2.getVersion();
            return s1.compareTo(s2);
        }
        return 0;
    }

    protected ArtifactsFilter getMarkedArtifactFilter() {
        return null;
    }
}

