/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency;

import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class AnalyzeDuplicateMojo
extends AbstractMojo {
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        MavenXpp3Reader pomReader = new MavenXpp3Reader();
        Model model = null;
        try {
            model = pomReader.read((Reader)new FileReader(this.project.getFile()));
        }
        catch (Exception e) {
            throw new MojoExecutionException("IOException: " + e.getMessage(), e);
        }
        Set duplicateDependencies = new HashSet();
        if (model.getDependencies() != null) {
            duplicateDependencies = this.findDuplicateDependencies(model.getDependencies());
        }
        Set duplicateDependenciesManagement = new HashSet();
        if (model.getDependencyManagement() != null && model.getDependencyManagement().getDependencies() != null) {
            duplicateDependenciesManagement = this.findDuplicateDependencies(model.getDependencyManagement().getDependencies());
        }
        if (this.getLog().isInfoEnabled()) {
            String dup;
            Iterator it;
            StringBuffer sb = new StringBuffer();
            if (!duplicateDependencies.isEmpty()) {
                sb.append("List of duplicate dependencies defined in <dependencies/> in your pom.xml:\n");
                it = duplicateDependencies.iterator();
                while (it.hasNext()) {
                    dup = (String)it.next();
                    sb.append("\to " + dup);
                    if (!it.hasNext()) continue;
                    sb.append("\n");
                }
            }
            if (!duplicateDependenciesManagement.isEmpty()) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append("List of duplicate dependencies defined in <dependencyManagement/> in your pom.xml:\n");
                it = duplicateDependenciesManagement.iterator();
                while (it.hasNext()) {
                    dup = (String)it.next();
                    sb.append("\to " + dup);
                    if (!it.hasNext()) continue;
                    sb.append("\n");
                }
            }
            if (sb.length() > 0) {
                this.getLog().info((CharSequence)sb.toString());
            } else {
                this.getLog().info((CharSequence)"No duplicate dependencies found in <dependencies/> or in <dependencyManagement/>");
            }
        }
    }

    private Set findDuplicateDependencies(List modelDependencies) {
        ArrayList<String> modelDependencies2 = new ArrayList<String>();
        for (Dependency dep : modelDependencies) {
            modelDependencies2.add(dep.getManagementKey());
        }
        return new HashSet(CollectionUtils.disjunction(modelDependencies2, new HashSet(modelDependencies2)));
    }
}

