/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency.utils;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;

public class DependencyStatusSets {
    Set resolvedDependencies = null;
    Set unResolvedDependencies = null;
    Set skippedDependencies = null;

    public DependencyStatusSets() {
    }

    public DependencyStatusSets(Set resolved, Set unResolved, Set skipped) {
        if (resolved != null) {
            this.resolvedDependencies = new LinkedHashSet(resolved);
        }
        if (unResolved != null) {
            this.unResolvedDependencies = new LinkedHashSet(unResolved);
        }
        if (skipped != null) {
            this.skippedDependencies = new LinkedHashSet(skipped);
        }
    }

    public Set getResolvedDependencies() {
        return this.resolvedDependencies;
    }

    public void setResolvedDependencies(Set resolvedDependencies) {
        this.resolvedDependencies = resolvedDependencies != null ? new LinkedHashSet(resolvedDependencies) : null;
    }

    public Set getSkippedDependencies() {
        return this.skippedDependencies;
    }

    public void setSkippedDependencies(Set skippedDependencies) {
        this.skippedDependencies = skippedDependencies != null ? new LinkedHashSet(skippedDependencies) : null;
    }

    public Set getUnResolvedDependencies() {
        return this.unResolvedDependencies;
    }

    public void setUnResolvedDependencies(Set unResolvedDependencies) {
        this.unResolvedDependencies = unResolvedDependencies != null ? new LinkedHashSet(unResolvedDependencies) : null;
    }

    public String getOutput(boolean outputAbsoluteArtifactFilename) {
        return this.getOutput(outputAbsoluteArtifactFilename, true);
    }

    public String getOutput(boolean outputAbsoluteArtifactFilename, boolean outputScope) {
        Iterator i;
        StringBuffer sb = new StringBuffer();
        sb.append("\n");
        sb.append("The following files have been resolved:\n");
        if (this.resolvedDependencies == null || this.resolvedDependencies.isEmpty()) {
            sb.append("   none\n");
        } else {
            for (Artifact artifact : this.resolvedDependencies) {
                String artifactFilename = null;
                if (outputAbsoluteArtifactFilename) {
                    try {
                        artifactFilename = artifact.getFile().getAbsoluteFile().getPath();
                    }
                    catch (NullPointerException e) {
                        artifactFilename = null;
                    }
                }
                String id = outputScope ? artifact.toString() : artifact.getId();
                sb.append("   " + id + (outputAbsoluteArtifactFilename ? ":" + artifactFilename : "") + "\n");
            }
        }
        if (this.skippedDependencies != null && !this.skippedDependencies.isEmpty()) {
            sb.append("\n");
            sb.append("The following files were skipped:\n");
            LinkedHashSet skippedDependencies = new LinkedHashSet();
            skippedDependencies.addAll(this.skippedDependencies);
            i = skippedDependencies.iterator();
            while (i.hasNext()) {
                sb.append("   " + ((Artifact)i.next()).getId() + "\n");
            }
        }
        if (this.unResolvedDependencies != null && !this.unResolvedDependencies.isEmpty()) {
            sb.append("\n");
            sb.append("The following files have NOT been resolved:\n");
            LinkedHashSet unResolvedDependencies = new LinkedHashSet();
            unResolvedDependencies.addAll(this.unResolvedDependencies);
            i = unResolvedDependencies.iterator();
            while (i.hasNext()) {
                sb.append("   " + ((Artifact)i.next()).getId() + "\n");
            }
        }
        sb.append("\n");
        return sb.toString();
    }
}

