/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency.resolvers;

import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.dependency.AbstractResolveMojo;
import org.apache.maven.plugin.dependency.utils.DependencyStatusSets;
import org.apache.maven.plugin.dependency.utils.DependencyUtil;
import org.apache.maven.plugin.dependency.utils.filters.ResolveFileFilter;
import org.apache.maven.plugin.dependency.utils.markers.SourcesFileMarkerHandler;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;

@Mojo(name="resolve", requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
public class ResolveDependenciesMojo
extends AbstractResolveMojo {
    @Parameter(property="mdep.outputScope", defaultValue="true")
    protected boolean outputScope;
    DependencyStatusSets results;

    public void execute() throws MojoExecutionException {
        this.results = this.getDependencySets(false);
        String output = this.results.getOutput(this.outputAbsoluteArtifactFilename, this.outputScope);
        try {
            if (this.outputFile == null) {
                DependencyUtil.log(output, this.getLog());
            } else {
                DependencyUtil.write(output, this.outputFile, this.appendOutput, this.getLog());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    public DependencyStatusSets getResults() {
        return this.results;
    }

    protected ArtifactsFilter getMarkedArtifactFilter() {
        return new ResolveFileFilter(new SourcesFileMarkerHandler(this.markersDirectory));
    }
}

