/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.resolvers;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.dependency.resolvers.AbstractResolveMojo;
import org.apache.maven.plugins.dependency.utils.DependencyUtil;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.artifact.filter.collection.ArtifactFilterException;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.FilterArtifacts;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolverException;
import org.apache.maven.shared.transfer.dependencies.DefaultDependableCoordinate;
import org.apache.maven.shared.transfer.dependencies.DependableCoordinate;
import org.apache.maven.shared.transfer.dependencies.resolve.DependencyResolverException;

@Mojo(name="resolve-plugins", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
public class ResolvePluginsMojo
extends AbstractResolveMojo {
    @Parameter(property="outputEncoding", defaultValue="${project.reporting.outputEncoding}")
    private String outputEncoding;

    @Override
    protected void doExecute() throws MojoExecutionException {
        block13: {
            try {
                Set<Artifact> plugins = this.resolvePluginArtifacts();
                StringBuilder sb = new StringBuilder();
                sb.append(System.lineSeparator());
                sb.append("The following plugins have been resolved:");
                sb.append(System.lineSeparator());
                if (plugins == null || plugins.isEmpty()) {
                    sb.append("   none");
                    sb.append(System.lineSeparator());
                    break block13;
                }
                for (Artifact plugin : plugins) {
                    String artifactFilename = null;
                    if (this.outputAbsoluteArtifactFilename) {
                        try {
                            artifactFilename = plugin.getFile().getAbsoluteFile().getPath();
                        }
                        catch (NullPointerException e) {
                            artifactFilename = null;
                        }
                    }
                    String id = plugin.toString();
                    sb.append("   ").append(id).append(this.outputAbsoluteArtifactFilename ? ":" + artifactFilename : "").append(System.lineSeparator());
                    if (this.excludeTransitive) continue;
                    DefaultDependableCoordinate pluginCoordinate = new DefaultDependableCoordinate();
                    pluginCoordinate.setGroupId(plugin.getGroupId());
                    pluginCoordinate.setArtifactId(plugin.getArtifactId());
                    pluginCoordinate.setVersion(plugin.getVersion());
                    for (Artifact artifact : this.resolveArtifactDependencies((DependableCoordinate)pluginCoordinate)) {
                        artifactFilename = null;
                        if (this.outputAbsoluteArtifactFilename) {
                            try {
                                artifactFilename = artifact.getFile().getAbsoluteFile().getPath();
                            }
                            catch (NullPointerException e) {
                                artifactFilename = null;
                            }
                        }
                        id = artifact.toString();
                        sb.append("      ").append(id).append(this.outputAbsoluteArtifactFilename ? ":" + artifactFilename : "").append(System.lineSeparator());
                    }
                }
                sb.append(System.lineSeparator());
                String output = sb.toString();
                if (this.outputFile == null) {
                    DependencyUtil.log(output, this.getLog());
                } else {
                    String encoding = Objects.toString(this.outputEncoding, "UTF-8");
                    DependencyUtil.write(output, this.outputFile, this.appendOutput, encoding);
                }
            }
            catch (IOException | ArtifactFilterException | ArtifactResolverException | DependencyResolverException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
    }

    protected Set<Artifact> resolvePluginArtifacts() throws ArtifactFilterException, ArtifactResolverException {
        Set plugins = this.getProject().getPluginArtifacts();
        Set reports = this.getProject().getReportArtifacts();
        Set<Artifact> artifacts = new LinkedHashSet();
        artifacts.addAll(reports);
        artifacts.addAll(plugins);
        FilterArtifacts filter = this.getArtifactsFilter();
        artifacts = filter.filter(artifacts);
        LinkedHashSet<Artifact> resolvedArtifacts = new LinkedHashSet<Artifact>(artifacts.size());
        for (Artifact artifact : new LinkedHashSet(artifacts)) {
            ProjectBuildingRequest buildingRequest = this.newResolvePluginProjectBuildingRequest();
            resolvedArtifacts.add(this.getArtifactResolver().resolveArtifact(buildingRequest, artifact).getArtifact());
        }
        return artifacts;
    }

    @Override
    protected ArtifactsFilter getMarkedArtifactFilter() {
        return null;
    }
}

