/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.doap;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.ArtifactRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataResolutionException;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Developer;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.doap.DoapUtil;
import org.apache.maven.plugin.doap.options.ASFExtOptions;
import org.apache.maven.plugin.doap.options.DoapOptions;
import org.apache.maven.plugin.doap.options.Standard;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.cvslib.repository.CvsScmProviderRepository;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.XmlWriterUtil;

public class DoapMojo
extends AbstractMojo {
    private static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");
    private static final DateFormat REPOSITORY_DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss", Locale.ENGLISH);
    private static final DateFormat DOAP_DATE_FORMAT;
    private ScmManager scmManager;
    private ArtifactFactory artifactFactory;
    private RepositoryMetadataManager repositoryMetadataManager;
    private I18N i18n;
    private MavenProject project;
    private File doapFile;
    private ArtifactRepository localRepository;
    private List remoteRepositories;
    private String category;
    private String language;
    private DoapOptions doapOptions;
    private ASFExtOptions asfExtOptions;
    private String lang;
    private String about;

    public void execute() throws MojoExecutionException {
        XmlStreamWriter w;
        try {
            if (!this.doapFile.getParentFile().exists()) {
                FileUtils.mkdir((String)this.doapFile.getParentFile().getAbsolutePath());
            }
            w = WriterFactory.newXmlWriter((File)this.doapFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating DOAP file.", (Exception)e);
        }
        if (this.asfExtOptions.isIncluded()) {
            this.getLog().info((CharSequence)"Generating an ASF DOAP file...");
        } else {
            this.getLog().info((CharSequence)"Generating a pure DOAP file...");
        }
        PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)w, this.project.getModel().getModelEncoding(), null);
        DoapUtil.writeHeader((XMLWriter)writer);
        writer.startElement("rdf:RDF");
        writer.addAttribute("xml:lang", this.lang);
        writer.addAttribute("xmlns", "http://usefulinc.com/ns/doap#");
        writer.addAttribute("xmlns:rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        writer.addAttribute("xmlns:foaf", "http://xmlns.com/foaf/0.1/");
        if (this.asfExtOptions.isIncluded()) {
            writer.addAttribute("xmlns:asfext", "http://projects.apache.org/ns/asfext#");
        }
        writer.startElement("Project");
        if (StringUtils.isNotEmpty((String)this.about)) {
            writer.addAttribute("rdf:about", this.about);
        } else {
            this.getLog().warn((CharSequence)"rdf:about should be required");
        }
        this.writeName((XMLWriter)writer);
        this.writeDescription((XMLWriter)writer);
        this.writeCreated((XMLWriter)writer);
        this.writeHomepage((XMLWriter)writer);
        this.writeLicenses((XMLWriter)writer);
        this.writeProgrammingLanguage((XMLWriter)writer);
        this.writeCategory((XMLWriter)writer);
        this.writeOS((XMLWriter)writer);
        this.writeSourceRepositories((XMLWriter)writer);
        this.writeBugDatabase((XMLWriter)writer);
        this.writeMailingList((XMLWriter)writer);
        this.writeDownloadPage((XMLWriter)writer);
        this.writeScreenshots((XMLWriter)writer);
        this.writeWiki((XMLWriter)writer);
        this.writeReleases((XMLWriter)writer);
        this.writeDevelopersOrContributors((XMLWriter)writer, this.project.getDevelopers());
        this.writeDevelopersOrContributors((XMLWriter)writer, this.project.getContributors());
        if (this.asfExtOptions.isIncluded()) {
            this.writeASFext((XMLWriter)writer);
        }
        writer.endElement();
        writer.endElement();
        try {
            w.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error when closing the writer.", (Exception)e);
        }
    }

    private void writeName(XMLWriter writer) {
        if (StringUtils.isEmpty((String)this.project.getName())) {
            return;
        }
        XmlWriterUtil.writeLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeCommentText((XMLWriter)writer, (String)"A name of something.", (int)2);
        if (this.asfExtOptions.isIncluded() && !this.project.getName().toLowerCase(Locale.ENGLISH).trim().startsWith("apache")) {
            DoapUtil.writeRdfResourceElement(writer, "name", "Apache " + this.project.getName());
        } else {
            DoapUtil.writeRdfResourceElement(writer, "name", this.project.getName());
        }
    }

    private void writeDescription(XMLWriter writer) {
        if (StringUtils.isEmpty((String)this.project.getDescription())) {
            return;
        }
        XmlWriterUtil.writeLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeCommentText((XMLWriter)writer, (String)"Plain text description of a project, of 2-4 sentences in length.", (int)2);
        DoapUtil.writeElement(writer, "description", this.project.getDescription(), this.lang);
        if (StringUtils.isNotEmpty((String)this.doapOptions.getShortdesc())) {
            DoapUtil.writeElement(writer, "shortdesc", this.doapOptions.getShortdesc(), this.lang);
        } else {
            DoapUtil.writeElement(writer, "shortdesc", this.project.getDescription(), this.lang);
        }
    }

    private void writeCreated(XMLWriter writer) {
        if (StringUtils.isEmpty((String)this.project.getInceptionYear())) {
            return;
        }
        XmlWriterUtil.writeLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeCommentText((XMLWriter)writer, (String)"Date when something was created, in YYYY-MM-DD form. e.g. 2004-04-05", (int)2);
        DoapUtil.writeElement(writer, "created", this.project.getInceptionYear() + "-01-01");
    }

    private void writeHomepage(XMLWriter writer) {
        if (StringUtils.isNotEmpty((String)this.project.getUrl())) {
            XmlWriterUtil.writeLineBreak((XMLWriter)writer);
            XmlWriterUtil.writeCommentText((XMLWriter)writer, (String)"URL of a project's homepage, associated with exactly one project.", (int)2);
            DoapUtil.writeRdfResourceElement(writer, "homepage", this.project.getUrl());
        }
        if (StringUtils.isNotEmpty((String)this.doapOptions.getOldHomepage())) {
            XmlWriterUtil.writeLineBreak((XMLWriter)writer);
            XmlWriterUtil.writeCommentText((XMLWriter)writer, (String)"URL of a project's past homepage, associated with exactly one project.", (int)2);
            DoapUtil.writeRdfResourceElement(writer, "old-homepage", this.doapOptions.getOldHomepage());
        }
    }

    private void writeProgrammingLanguage(XMLWriter writer) {
        if (StringUtils.isEmpty((String)this.doapOptions.getProgrammingLanguage()) && StringUtils.isEmpty((String)this.language)) {
            return;
        }
        XmlWriterUtil.writeLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeCommentText((XMLWriter)writer, (String)"Programming language.", (int)2);
        if (StringUtils.isNotEmpty((String)this.language)) {
            if (this.asfExtOptions.isIncluded() && !ASFExtOptions.isProgrammingLanguageSupportedByASF(this.language)) {
                this.getLog().warn((CharSequence)("The programming language '" + this.language + "' is not supported by ASF. " + "Refer you to http://projects.apache.org/languages.html"));
            }
            DoapUtil.writeRdfResourceElement(writer, "programming-language", this.language);
        }
        if (StringUtils.isNotEmpty((String)this.doapOptions.getProgrammingLanguage())) {
            String[] languages = StringUtils.split((String)this.doapOptions.getProgrammingLanguage(), (String)",");
            for (int i = 0; i < languages.length; ++i) {
                if (this.asfExtOptions.isIncluded() && !ASFExtOptions.isProgrammingLanguageSupportedByASF(languages[i].trim())) {
                    this.getLog().warn((CharSequence)("The programming language '" + languages[i].trim() + "' is not supported by ASF. " + "Refer you to http://projects.apache.org/languages.html"));
                }
                DoapUtil.writeRdfResourceElement(writer, "programming-language", languages[i].trim());
            }
        }
    }

    private void writeCategory(XMLWriter writer) {
        if (StringUtils.isEmpty((String)this.doapOptions.getCategory()) && StringUtils.isEmpty((String)this.category)) {
            return;
        }
        XmlWriterUtil.writeLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeCommentText((XMLWriter)writer, (String)"A category of project.", (int)2);
        if (StringUtils.isNotEmpty((String)this.category)) {
            if (this.asfExtOptions.isIncluded() && !ASFExtOptions.isCategorySupportedByASF(this.category)) {
                this.getLog().warn((CharSequence)("The given category '" + this.category + "' is not supported by ASF. " + "Refer you to http://projects.apache.org/categories.html"));
            }
            if (this.asfExtOptions.isIncluded()) {
                DoapUtil.writeRdfResourceElement(writer, "category", "http://projects.apache.org/category/" + this.category);
            } else {
                DoapUtil.writeRdfResourceElement(writer, "category", this.category);
            }
        }
        if (StringUtils.isNotEmpty((String)this.doapOptions.getCategory())) {
            String[] categories = StringUtils.split((String)this.doapOptions.getCategory(), (String)",");
            for (int i = 0; i < categories.length; ++i) {
                if (this.asfExtOptions.isIncluded() && !ASFExtOptions.isCategorySupportedByASF(categories[i])) {
                    this.getLog().warn((CharSequence)("The given category '" + categories[i] + "' is not supported by ASF. " + "Refer you to http://projects.apache.org/categories.html"));
                }
                if (this.asfExtOptions.isIncluded()) {
                    DoapUtil.writeRdfResourceElement(writer, "category", "http://projects.apache.org/category/" + categories[i].trim());
                    continue;
                }
                DoapUtil.writeRdfResourceElement(writer, "category", categories[i].trim());
            }
        }
    }

    private void writeDownloadPage(XMLWriter writer) {
        if (StringUtils.isEmpty((String)this.doapOptions.getDownloadPage()) && StringUtils.isNotEmpty((String)this.project.getUrl())) {
            this.doapOptions.setDownloadPage(DoapMojo.composeUrl(this.project.getUrl(), "/download.html"));
        }
        if (StringUtils.isNotEmpty((String)this.doapOptions.getDownloadPage())) {
            XmlWriterUtil.writeLineBreak((XMLWriter)writer);
            XmlWriterUtil.writeCommentText((XMLWriter)writer, (String)"Download page.", (int)2);
            DoapUtil.writeRdfResourceElement(writer, "download-page", this.doapOptions.getDownloadPage());
        }
        if (StringUtils.isNotEmpty((String)this.doapOptions.getDownloadMirror())) {
            XmlWriterUtil.writeLineBreak((XMLWriter)writer);
            XmlWriterUtil.writeCommentText((XMLWriter)writer, (String)"Mirror of software download web page.", (int)2);
            String[] downloadMirrors = StringUtils.split((String)this.doapOptions.getDownloadMirror(), (String)",");
            for (int i = 0; i < downloadMirrors.length; ++i) {
                DoapUtil.writeRdfResourceElement(writer, "download-mirror", downloadMirrors[i].trim());
            }
        }
    }

    private void writeOS(XMLWriter writer) {
        if (StringUtils.isEmpty((String)this.doapOptions.getOs())) {
            return;
        }
        XmlWriterUtil.writeLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeCommentText((XMLWriter)writer, (String)"Operating system that a project is limited to.", (int)2);
        String[] oses = StringUtils.split((String)this.doapOptions.getOs(), (String)",");
        for (int i = 0; i < oses.length; ++i) {
            DoapUtil.writeRdfResourceElement(writer, "os", oses[i].trim());
        }
    }

    private void writeScreenshots(XMLWriter writer) {
        if (StringUtils.isEmpty((String)this.doapOptions.getScreenshots())) {
            return;
        }
        XmlWriterUtil.writeLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeCommentText((XMLWriter)writer, (String)"Web page with screenshots of project.", (int)2);
        DoapUtil.writeRdfResourceElement(writer, "screenshots", this.doapOptions.getScreenshots());
    }

    private void writeWiki(XMLWriter writer) {
        if (StringUtils.isEmpty((String)this.doapOptions.getWiki())) {
            return;
        }
        XmlWriterUtil.writeLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeCommentText((XMLWriter)writer, (String)"URL of Wiki for collaborative discussion of project.", (int)2);
        DoapUtil.writeRdfResourceElement(writer, "wiki", this.doapOptions.getWiki());
    }

    private void writeLicenses(XMLWriter writer) {
        if (this.project.getLicenses() == null || this.project.getLicenses().isEmpty()) {
            return;
        }
        XmlWriterUtil.writeLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeCommentText((XMLWriter)writer, (String)"The URI of the license the software is distributed under.", (int)2);
        Iterator it = this.project.getLicenses().iterator();
        while (it.hasNext()) {
            License license = (License)it.next();
            if (StringUtils.isNotEmpty((String)license.getUrl())) {
                DoapUtil.writeRdfResourceElement(writer, "license", license.getUrl());
                continue;
            }
            this.getLog().warn((CharSequence)("No URL was specified for license " + license.getName()));
        }
    }

    private void writeBugDatabase(XMLWriter writer) {
        if (this.project.getIssueManagement() == null) {
            return;
        }
        XmlWriterUtil.writeLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeCommentText((XMLWriter)writer, (String)"bug database.", (int)2);
        if (StringUtils.isNotEmpty((String)this.project.getIssueManagement().getUrl())) {
            DoapUtil.writeRdfResourceElement(writer, "bug-database", this.project.getIssueManagement().getUrl());
        } else {
            this.getLog().warn((CharSequence)"No URL was specified for issue management");
        }
    }

    private void writeMailingList(XMLWriter writer) {
        if (this.project.getMailingLists() == null || this.project.getMailingLists().isEmpty()) {
            return;
        }
        XmlWriterUtil.writeLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeCommentText((XMLWriter)writer, (String)"mailing list.", (int)2);
        Iterator it = this.project.getMailingLists().iterator();
        while (it.hasNext()) {
            MailingList mailingList = (MailingList)it.next();
            if (StringUtils.isNotEmpty((String)mailingList.getArchive())) {
                DoapUtil.writeRdfResourceElement(writer, "mailing-list", mailingList.getArchive());
            } else {
                this.getLog().warn((CharSequence)("No archive was specified for mailing list " + mailingList.getName()));
            }
            if (mailingList.getOtherArchives() == null) continue;
            Iterator it2 = mailingList.getOtherArchives().iterator();
            while (it2.hasNext()) {
                String otherArchive = (String)it2.next();
                if (StringUtils.isNotEmpty((String)otherArchive)) {
                    DoapUtil.writeRdfResourceElement(writer, "mailing-list", otherArchive);
                    continue;
                }
                this.getLog().warn((CharSequence)("No other archive was specified for mailing list " + mailingList.getName()));
            }
        }
    }

    private void writeReleases(XMLWriter writer) throws MojoExecutionException {
        Artifact artifact = this.artifactFactory.createArtifact(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), null, this.project.getPackaging());
        ArtifactRepositoryMetadata metadata = new ArtifactRepositoryMetadata(artifact);
        Iterator it = this.remoteRepositories.iterator();
        while (it.hasNext()) {
            ArtifactRepository repo = (ArtifactRepository)it.next();
            if (repo.isBlacklisted() || repo.getSnapshots().isEnabled() || !repo.getReleases().isEnabled()) continue;
            try {
                this.repositoryMetadataManager.resolveAlways((RepositoryMetadata)metadata, this.localRepository, repo);
                break;
            }
            catch (RepositoryMetadataResolutionException e) {
                throw new MojoExecutionException(metadata + " could not be retrieved from repositories due to an error: " + e.getMessage(), (Exception)((Object)e));
            }
        }
        if (metadata.getMetadata().getVersioning() == null) {
            this.getLog().info((CharSequence)"No versioning was found - ignored writing <release/> tag.");
            return;
        }
        List versions = metadata.getMetadata().getVersioning().getVersions();
        Collections.reverse(versions);
        boolean addComment = false;
        int i = 0;
        Iterator it2 = versions.iterator();
        while (it2.hasNext()) {
            String version = (String)it2.next();
            if (!addComment) {
                XmlWriterUtil.writeLineBreak((XMLWriter)writer);
                XmlWriterUtil.writeCommentText((XMLWriter)writer, (String)"Project releases.", (int)2);
                addComment = true;
            }
            writer.startElement("release");
            writer.startElement("Version");
            writer.startElement("name");
            if (version.equals(metadata.getMetadata().getVersioning().getRelease())) {
                writer.writeText("Latest stable release");
            } else {
                writer.writeText(this.project.getName() + " - " + version);
            }
            writer.endElement();
            writer.startElement("revision");
            writer.writeText(version);
            writer.endElement();
            Iterator it22 = this.remoteRepositories.iterator();
            while (it22.hasNext()) {
                ArtifactRepository repo = (ArtifactRepository)it22.next();
                Artifact artifactRelease = this.artifactFactory.createArtifact(this.project.getGroupId(), this.project.getArtifactId(), version, null, this.project.getPackaging());
                if (artifactRelease == null) continue;
                String fileRelease = repo.getUrl() + "/" + repo.pathOf(artifactRelease);
                try {
                    URL urlRelease = new URL(fileRelease);
                    urlRelease.openStream();
                }
                catch (MalformedURLException e) {
                    this.getLog().debug((CharSequence)e.getMessage(), (Throwable)e);
                    continue;
                }
                catch (IOException e) {
                    this.getLog().debug((CharSequence)e.getMessage(), (Throwable)e);
                    continue;
                }
                writer.startElement("file-release");
                writer.writeText(fileRelease);
                writer.endElement();
                Date releaseDate = null;
                try {
                    releaseDate = REPOSITORY_DATE_FORMAT.parse(metadata.getMetadata().getVersioning().getLastUpdated());
                }
                catch (ParseException e) {
                    this.getLog().error((CharSequence)("Unable to parse date '" + metadata.getMetadata().getVersioning().getLastUpdated() + "'"));
                    continue;
                }
                if (i != 0) continue;
                writer.startElement("created");
                writer.writeText(DOAP_DATE_FORMAT.format(releaseDate));
                writer.endElement();
            }
            writer.endElement();
            writer.endElement();
            ++i;
        }
    }

    private void writeSourceRepositories(XMLWriter writer) {
        Scm scm = this.project.getScm();
        if (scm == null) {
            return;
        }
        XmlWriterUtil.writeLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeCommentText((XMLWriter)writer, (String)"Anonymous Source Repository", (int)2);
        String anonymousConnection = scm.getConnection();
        this.writeSourceRepository(writer, anonymousConnection);
        XmlWriterUtil.writeLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeCommentText((XMLWriter)writer, (String)"Developer Source Repository", (int)2);
        String developerConnection = scm.getDeveloperConnection();
        this.writeSourceRepository(writer, developerConnection);
    }

    private void writeSourceRepository(XMLWriter writer, String connection) {
        ScmRepository repository = this.getScmRepository(connection);
        writer.startElement("repository");
        if (DoapMojo.isScmSystem(repository, "cvs")) {
            writer.startElement("CVSRepository");
            CvsScmProviderRepository cvsRepo = (CvsScmProviderRepository)repository.getProviderRepository();
            DoapUtil.writeElement(writer, "anon-root", cvsRepo.getCvsRoot());
            DoapUtil.writeElement(writer, "module", cvsRepo.getModule());
        } else if (DoapMojo.isScmSystem(repository, "svn")) {
            writer.startElement("SVNRepository");
            SvnScmProviderRepository svnRepo = (SvnScmProviderRepository)repository.getProviderRepository();
            DoapUtil.writeRdfResourceElement(writer, "location", svnRepo.getUrl());
        } else {
            writer.startElement("Repository");
            if (connection.length() < 4) {
                throw new IllegalArgumentException("The source repository connection is too short.");
            }
            DoapUtil.writeRdfResourceElement(writer, "location", connection.substring(4));
        }
        DoapUtil.writeRdfResourceElement(writer, "browse", this.project.getScm().getUrl());
        writer.endElement();
        writer.endElement();
    }

    private void writeDevelopersOrContributors(XMLWriter writer, List developersOrContributors) {
        if (developersOrContributors == null || developersOrContributors.isEmpty()) {
            return;
        }
        boolean isDeveloper = Developer.class.isAssignableFrom(developersOrContributors.get(0).getClass());
        if (isDeveloper) {
            XmlWriterUtil.writeLineBreak((XMLWriter)writer);
            XmlWriterUtil.writeCommentText((XMLWriter)writer, (String)"Main committers", (int)2);
        } else {
            XmlWriterUtil.writeLineBreak((XMLWriter)writer);
            XmlWriterUtil.writeCommentText((XMLWriter)writer, (String)"Contributed persons", (int)2);
        }
        List maintainers = DoapUtil.getDevelopersOrContributorsWithMaintainerRole(this.i18n, developersOrContributors);
        List developers = DoapUtil.getDevelopersOrContributorsWithDeveloperRole(this.i18n, developersOrContributors);
        List documenters = DoapUtil.getDevelopersOrContributorsWithDocumenterRole(this.i18n, developersOrContributors);
        List translators = DoapUtil.getDevelopersOrContributorsWithTranslatorRole(this.i18n, developersOrContributors);
        List testers = DoapUtil.getDevelopersOrContributorsWithTesterRole(this.i18n, developersOrContributors);
        List helpers = DoapUtil.getDevelopersOrContributorsWithHelperRole(this.i18n, developersOrContributors);
        List unknowns = DoapUtil.getDevelopersOrContributorsWithUnknownRole(this.i18n, developersOrContributors);
        if (isDeveloper) {
            maintainers.addAll(unknowns);
        } else {
            helpers.addAll(unknowns);
        }
        if (developers.size() != 0) {
            this.writeDeveloperOrContributor(writer, developers, "developer");
        }
        if (documenters.size() != 0) {
            this.writeDeveloperOrContributor(writer, documenters, "documenter");
        }
        if (helpers.size() != 0) {
            this.writeDeveloperOrContributor(writer, helpers, "helper");
        }
        if (maintainers.size() != 0) {
            this.writeDeveloperOrContributor(writer, maintainers, "maintainer");
        }
        if (testers.size() != 0) {
            this.writeDeveloperOrContributor(writer, testers, "tester");
        }
        if (translators.size() != 0) {
            this.writeDeveloperOrContributor(writer, translators, "translator");
        }
    }

    private void writeDeveloperOrContributor(XMLWriter writer, List developersOrContributors, String doapType) {
        if (developersOrContributors == null || developersOrContributors.isEmpty()) {
            return;
        }
        Collections.sort(developersOrContributors, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                if ((class$org$apache$maven$model$Developer == null ? (class$org$apache$maven$model$Developer = DoapMojo.class$("org.apache.maven.model.Developer")) : class$org$apache$maven$model$Developer).isAssignableFrom(arg0.getClass())) {
                    Developer developer0 = (Developer)arg0;
                    Developer developer1 = (Developer)arg1;
                    if (developer0.getName() == null) {
                        return -1;
                    }
                    if (developer1.getName() == null) {
                        return 1;
                    }
                    return developer0.getName().compareTo(developer1.getName());
                }
                Contributor contributor0 = (Contributor)arg0;
                Contributor contributor1 = (Contributor)arg1;
                if (contributor0.getName() == null) {
                    return -1;
                }
                if (contributor1.getName() == null) {
                    return 1;
                }
                return contributor0.getName().compareTo(contributor1.getName());
            }
        });
        Iterator it = developersOrContributors.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            this.writeDeveloperOrContributor(writer, obj, doapType);
        }
    }

    private void writeDeveloperOrContributor(XMLWriter writer, Object developerOrContributor, String doapType) {
        String homepage;
        String organization;
        String email;
        String name;
        if (developerOrContributor == null) {
            return;
        }
        if (StringUtils.isEmpty((String)doapType)) {
            throw new IllegalArgumentException("doapType is required.");
        }
        if (Developer.class.isAssignableFrom(developerOrContributor.getClass())) {
            Developer d = (Developer)developerOrContributor;
            name = d.getName();
            email = d.getEmail();
            organization = d.getOrganization();
            homepage = d.getUrl();
        } else {
            Contributor c = (Contributor)developerOrContributor;
            name = c.getName();
            email = c.getEmail();
            organization = c.getOrganization();
            homepage = c.getUrl();
        }
        if (StringUtils.isEmpty((String)name)) {
            return;
        }
        writer.startElement(doapType);
        writer.startElement("foaf:Person");
        writer.startElement("foaf:name");
        writer.writeText(name);
        writer.endElement();
        if (StringUtils.isNotEmpty((String)email)) {
            DoapUtil.writeRdfResourceElement(writer, "foaf:mbox", "mailto:" + email);
        }
        if (StringUtils.isNotEmpty((String)organization)) {
            DoapUtil.writeRdfResourceElement(writer, "foaf:Organization", organization);
        }
        if (StringUtils.isNotEmpty((String)homepage)) {
            DoapUtil.writeRdfResourceElement(writer, "foaf:homepage", homepage);
        }
        writer.endElement();
        writer.endElement();
    }

    private ScmRepository getScmRepository(String scmUrl) {
        ScmRepository repo;
        block5: {
            repo = null;
            if (!StringUtils.isEmpty((String)scmUrl)) {
                try {
                    repo = this.scmManager.makeScmRepository(scmUrl);
                }
                catch (NoSuchScmProviderException e) {
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)e.getMessage(), (Throwable)e);
                    }
                }
                catch (ScmRepositoryException e) {
                    if (!this.getLog().isDebugEnabled()) break block5;
                    this.getLog().debug((CharSequence)e.getMessage(), (Throwable)e);
                }
            }
        }
        return repo;
    }

    private void writeASFext(XMLWriter writer) {
        XmlWriterUtil.writeLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeCommentText((XMLWriter)writer, (String)"ASF extension", (int)2);
        if (StringUtils.isNotEmpty((String)this.asfExtOptions.getPmc())) {
            DoapUtil.writeRdfResourceElement(writer, "asfext:pmc", this.asfExtOptions.getPmc());
        } else if (StringUtils.isEmpty((String)this.project.getUrl())) {
            this.getLog().warn((CharSequence)"No project url discovered! According http://projects.apache.org/docs/pmc.html, asfext:pmc is required");
        } else {
            DoapUtil.writeRdfResourceElement(writer, "asfext:pmc", this.project.getUrl());
        }
        if (StringUtils.isNotEmpty((String)this.asfExtOptions.getName())) {
            DoapUtil.writeRdfResourceElement(writer, "asfext:name", this.asfExtOptions.getName());
        } else if (StringUtils.isEmpty((String)this.project.getName())) {
            this.getLog().warn((CharSequence)"No project name discovered! According http://projects.apache.org/docs/pmc.html, asfext:name is required");
        } else if (!this.project.getName().trim().startsWith("Apache")) {
            DoapUtil.writeRdfResourceElement(writer, "asfext:name", "Apache " + this.project.getName().trim());
        } else {
            DoapUtil.writeRdfResourceElement(writer, "asfext:name", this.project.getName().trim());
        }
        if (StringUtils.isEmpty((String)this.asfExtOptions.getCharter())) {
            this.getLog().warn((CharSequence)"No charter specified! According http://projects.apache.org/docs/pmc.html, charter is required");
        } else {
            DoapUtil.writeRdfResourceElement(writer, "asfext:charter", this.asfExtOptions.getCharter());
        }
        List developers = this.project.getDevelopers();
        if (StringUtils.isNotEmpty((String)this.asfExtOptions.getChair())) {
            writer.startElement("asfext:chair");
            writer.startElement("foaf:Person");
            writer.startElement("foaf:name");
            writer.writeText(this.asfExtOptions.getChair());
            writer.endElement();
            writer.endElement();
            writer.endElement();
        } else {
            Developer chair = ASFExtOptions.findChair(developers);
            if (chair != null) {
                this.writeDeveloperOrContributor(writer, chair, "asfext:chair");
            } else {
                this.getLog().warn((CharSequence)"No chair man discovered! According http://projects.apache.org/docs/pmc.html, asfext:chair is required");
            }
        }
        if (developers != null && developers.size() > 0) {
            List pmcMember = ASFExtOptions.findPMCMembers(developers);
            Iterator it = pmcMember.iterator();
            while (it.hasNext()) {
                Developer developer = (Developer)it.next();
                this.writeDeveloperOrContributor(writer, developer, "asfext:member");
            }
        }
        this.writeASFImplements(writer);
    }

    private void writeASFImplements(XMLWriter writer) {
        if (this.asfExtOptions.getStandards() == null || this.asfExtOptions.getStandards().isEmpty()) {
            return;
        }
        Iterator it = this.asfExtOptions.getStandards().iterator();
        while (it.hasNext()) {
            Standard standard = (Standard)it.next();
            writer.startElement("asfext:implements");
            writer.startElement("asfext:Standard");
            if (StringUtils.isEmpty((String)standard.getTitle())) {
                this.getLog().warn((CharSequence)"No title specified! According http://projects.apache.org/docs/standards.html, asfext:title is required");
            } else {
                writer.startElement("asfext:title");
                writer.writeText(standard.getTitle());
                writer.endElement();
            }
            if (StringUtils.isEmpty((String)standard.getBody())) {
                this.getLog().warn((CharSequence)"No body specified! According http://projects.apache.org/docs/standards.html, asfext:body is required");
            } else {
                writer.startElement("asfext:body");
                writer.writeText(standard.getBody());
                writer.endElement();
            }
            if (StringUtils.isEmpty((String)standard.getId())) {
                this.getLog().warn((CharSequence)"No id specified! According http://projects.apache.org/docs/standards.html, asfext:id is required");
            } else {
                writer.startElement("asfext:id");
                writer.writeText(standard.getId());
                writer.endElement();
            }
            if (StringUtils.isNotEmpty((String)standard.getUrl())) {
                writer.startElement("asfext:url");
                writer.writeText(standard.getUrl());
                writer.endElement();
            }
            writer.endElement();
            writer.endElement();
        }
    }

    private static String composeUrl(String base, String path) {
        if (base.endsWith("/") && path.startsWith("/")) {
            return base + path.substring(1);
        }
        return base + path;
    }

    private static boolean isScmSystem(ScmRepository scmRepository, String scmProvider) {
        if (StringUtils.isEmpty((String)scmProvider)) {
            return false;
        }
        return scmRepository != null && scmProvider.equalsIgnoreCase(scmRepository.getProvider());
    }

    static {
        REPOSITORY_DATE_FORMAT.setTimeZone(UTC_TIME_ZONE);
        DOAP_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);
        DOAP_DATE_FORMAT.setTimeZone(UTC_TIME_ZONE);
    }
}

