/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.doap;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Developer;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.codehaus.plexus.util.xml.XmlWriterUtil;

public class DoapUtil {
    private static final int REPEAT_EQUALS = 21;
    protected static final String RDF_RESOURCE = "rdf:resource";
    static /* synthetic */ Class class$org$apache$maven$model$Developer;

    public static void writeHeader(XMLWriter writer) {
        XmlWriterUtil.writeLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeCommentLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)(StringUtils.repeat((String)"=", (int)21) + " - DO NOT EDIT THIS FILE! - " + StringUtils.repeat((String)"=", (int)21)));
        XmlWriterUtil.writeCommentLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)" ");
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)"Any modifications will be overwritten.");
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)" ");
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3, Locale.US);
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)("Generated by Maven Doap Plugin on " + dateFormat.format(new Date(System.currentTimeMillis()))));
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)"See: http://maven.apache.org/plugins/maven-doap-plugin/");
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)" ");
        XmlWriterUtil.writeCommentLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeLineBreak((XMLWriter)writer);
    }

    public static void writeElement(XMLWriter writer, String name, String value) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("name should be defined");
        }
        if (value != null) {
            writer.startElement(name);
            writer.writeText(value);
            writer.endElement();
        }
    }

    public static void writeElement(XMLWriter writer, String name, String value, String lang) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)lang)) {
            DoapUtil.writeElement(writer, name, value);
            return;
        }
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("name should be defined");
        }
        if (value != null) {
            writer.startElement(name);
            writer.addAttribute("xml:lang", lang);
            writer.writeText(value);
            writer.endElement();
        }
    }

    public static void writeRdfResourceElement(XMLWriter writer, String name, String value) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("name should be defined");
        }
        if (value != null) {
            writer.startElement(name);
            writer.addAttribute(RDF_RESOURCE, value);
            writer.endElement();
        }
    }

    public static List getDevelopersOrContributorsWithDeveloperRole(I18N i18n, List developersOrContributors) {
        return (List)DoapUtil.filterDevelopersOrContributorsByDoapRoles(i18n, developersOrContributors).get("developers");
    }

    public static List getDevelopersOrContributorsWithDocumenterRole(I18N i18n, List developersOrContributors) {
        return (List)DoapUtil.filterDevelopersOrContributorsByDoapRoles(i18n, developersOrContributors).get("documenters");
    }

    public static List getDevelopersOrContributorsWithHelperRole(I18N i18n, List developersOrContributors) {
        return (List)DoapUtil.filterDevelopersOrContributorsByDoapRoles(i18n, developersOrContributors).get("helpers");
    }

    public static List getDevelopersOrContributorsWithMaintainerRole(I18N i18n, List developersOrContributors) {
        return (List)DoapUtil.filterDevelopersOrContributorsByDoapRoles(i18n, developersOrContributors).get("maintainers");
    }

    public static List getDevelopersOrContributorsWithTesterRole(I18N i18n, List developersOrContributors) {
        return (List)DoapUtil.filterDevelopersOrContributorsByDoapRoles(i18n, developersOrContributors).get("testers");
    }

    public static List getDevelopersOrContributorsWithTranslatorRole(I18N i18n, List developersOrContributors) {
        return (List)DoapUtil.filterDevelopersOrContributorsByDoapRoles(i18n, developersOrContributors).get("translators");
    }

    public static List getDevelopersOrContributorsWithUnknownRole(I18N i18n, List developersOrContributors) {
        return (List)DoapUtil.filterDevelopersOrContributorsByDoapRoles(i18n, developersOrContributors).get("unknowns");
    }

    private static Map filterDevelopersOrContributorsByDoapRoles(I18N i18n, List developersOrContributors) {
        HashMap returnMap = new HashMap(7);
        returnMap.put("maintainers", new ArrayList());
        returnMap.put("developers", new ArrayList());
        returnMap.put("documenters", new ArrayList());
        returnMap.put("translators", new ArrayList());
        returnMap.put("testers", new ArrayList());
        returnMap.put("helpers", new ArrayList());
        returnMap.put("unknowns", new ArrayList());
        if (developersOrContributors == null || developersOrContributors.isEmpty()) {
            return returnMap;
        }
        Iterator it = developersOrContributors.iterator();
        while (it.hasNext()) {
            List roles;
            Object obj;
            if ((class$org$apache$maven$model$Developer == null ? DoapUtil.class$("org.apache.maven.model.Developer") : class$org$apache$maven$model$Developer).isAssignableFrom((obj = it.next()).getClass())) {
                Developer developer = (Developer)obj;
                roles = developer.getRoles();
            } else {
                Contributor contributor = (Contributor)obj;
                roles = contributor.getRoles();
            }
            if (roles != null && roles.size() != 0) {
                Iterator it2 = roles.iterator();
                while (it2.hasNext()) {
                    String role = (String)it2.next();
                    if ((role = role.toLowerCase(Locale.ENGLISH)).indexOf(DoapUtil.getLowerCaseString(i18n, "doap.maintainer")) != -1) {
                        ((List)returnMap.get("maintainers")).add(obj);
                        continue;
                    }
                    if (role.indexOf(DoapUtil.getLowerCaseString(i18n, "doap.developer")) != -1) {
                        ((List)returnMap.get("developers")).add(obj);
                        continue;
                    }
                    if (role.indexOf(DoapUtil.getLowerCaseString(i18n, "doap.documenter")) != -1) {
                        ((List)returnMap.get("documenters")).add(obj);
                        continue;
                    }
                    if (role.indexOf(DoapUtil.getLowerCaseString(i18n, "doap.translator")) != -1) {
                        ((List)returnMap.get("translators")).add(obj);
                        continue;
                    }
                    if (role.indexOf(DoapUtil.getLowerCaseString(i18n, "doap.tester")) != -1) {
                        ((List)returnMap.get("testers")).add(obj);
                        continue;
                    }
                    if (role.indexOf(DoapUtil.getLowerCaseString(i18n, "doap.helper")) != -1) {
                        ((List)returnMap.get("helpers")).add(obj);
                        continue;
                    }
                    ((List)returnMap.get("unknowns")).add(obj);
                }
                continue;
            }
            ((List)returnMap.get("unknowns")).add(obj);
        }
        return returnMap;
    }

    private static String getLowerCaseString(I18N i18n, String key) {
        return i18n.getString("doap-person", Locale.ENGLISH, key).toLowerCase(Locale.ENGLISH);
    }
}

