/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.doap.options;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.model.Developer;
import org.apache.maven.plugin.doap.options.Standard;

public class ASFExtOptions
implements Serializable {
    private boolean included = true;
    private String pmc;
    private String name;
    private String charter;
    private String chair;
    private List standards;
    public static final String ASFEXT_NAMESPACE = "http://projects.apache.org/ns/asfext#";
    public static final String CATEGORY_RESOURCE = "http://projects.apache.org/category/";
    public static final String BUILD_MANAGEMENT_CATEGORY = "build-management";
    public static final String DATABASE_CATEGORY = "database";
    public static final String HTTP_CATEGORY = "http";
    public static final String HTTP_MODULES_CATEGORY = "httpd-modules";
    public static final String LIBRARY_CATEGORY = "library";
    public static final String MAIL_CATEGORY = "mail";
    public static final String NETWORK_CLIENT_CATEGORY = "network-client";
    public static final String NETWORK_SERVER_CATEGORY = "network-server";
    public static final String TESTING_CATEGORY = "testing";
    public static final String WEB_FRAMEWORK_CATEGORY = "web-framework";
    public static final String XML_CATEGORY = "xml";
    public static final String[] CATEGORIES = new String[]{"build-management", "database", "http", "httpd-modules", "library", "mail", "network-client", "network-server", "testing", "web-framework", "xml"};
    public static final String C_PROGRAMMING_LANGUAGE = "C";
    public static final String JAVA_PROGRAMMING_LANGUAGE = "Java";
    public static final String PERL_PROGRAMMING_LANGUAGE = "Perl";
    public static final String PYTHON_PROGRAMMING_LANGUAGE = "Python";
    public static final String SVG_PROGRAMMING_LANGUAGE = "SVG";
    public static final String TCL_PROGRAMMING_LANGUAGE = "Tcl";
    public static final String[] PROGRAMMING_LANGUAGES = new String[]{"C", "Java", "Perl", "Python", "SVG", "Tcl"};
    private String modelEncoding = "UTF-8";

    public void addStandard(Standard standard) {
        if (!(standard instanceof Standard)) {
            throw new ClassCastException("ASFExtOptions.addStandards(standard) parameter must be instanceof " + Standard.class.getName());
        }
        this.getStandards().add(standard);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ASFExtOptions)) {
            return false;
        }
        ASFExtOptions that = (ASFExtOptions)other;
        boolean result = true;
        boolean bl = result = result && this.included == that.included;
        boolean bl2 = result && (this.getPmc() == null ? that.getPmc() == null : this.getPmc().equals(that.getPmc())) ? true : (result = false);
        boolean bl3 = result && (this.getName() == null ? that.getName() == null : this.getName().equals(that.getName())) ? true : (result = false);
        boolean bl4 = result && (this.getCharter() == null ? that.getCharter() == null : this.getCharter().equals(that.getCharter())) ? true : (result = false);
        result = result && (this.getChair() == null ? that.getChair() == null : this.getChair().equals(that.getChair()));
        return result;
    }

    public String getChair() {
        return this.chair;
    }

    public String getCharter() {
        return this.charter;
    }

    public String getName() {
        return this.name;
    }

    public String getPmc() {
        return this.pmc;
    }

    public List getStandards() {
        if (this.standards == null) {
            this.standards = new ArrayList();
        }
        return this.standards;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.included ? 0 : 1);
        result = 37 * result + (this.pmc != null ? this.pmc.hashCode() : 0);
        result = 37 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 37 * result + (this.charter != null ? this.charter.hashCode() : 0);
        result = 37 * result + (this.chair != null ? this.chair.hashCode() : 0);
        return result;
    }

    public boolean isIncluded() {
        return this.included;
    }

    public void removeStandard(Standard standard) {
        if (!(standard instanceof Standard)) {
            throw new ClassCastException("ASFExtOptions.removeStandards(standard) parameter must be instanceof " + Standard.class.getName());
        }
        this.getStandards().remove(standard);
    }

    public void setChair(String chair) {
        this.chair = chair;
    }

    public void setCharter(String charter) {
        this.charter = charter;
    }

    public void setIncluded(boolean included) {
        this.included = included;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPmc(String pmc) {
        this.pmc = pmc;
    }

    public void setStandards(List standards) {
        this.standards = standards;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("included = '");
        buf.append(this.isIncluded());
        buf.append("'");
        buf.append("\n");
        buf.append("pmc = '");
        buf.append(this.getPmc());
        buf.append("'");
        buf.append("\n");
        buf.append("name = '");
        buf.append(this.getName());
        buf.append("'");
        buf.append("\n");
        buf.append("charter = '");
        buf.append(this.getCharter());
        buf.append("'");
        buf.append("\n");
        buf.append("chair = '");
        buf.append(this.getChair());
        buf.append("'");
        return buf.toString();
    }

    public static boolean isCategorySupportedByASF(String category) {
        for (int i = 0; i < CATEGORIES.length; ++i) {
            if (!CATEGORIES[i].equalsIgnoreCase(category)) continue;
            return true;
        }
        return false;
    }

    public static boolean isProgrammingLanguageSupportedByASF(String programmingLanguage) {
        for (int i = 0; i < PROGRAMMING_LANGUAGES.length; ++i) {
            if (!PROGRAMMING_LANGUAGES[i].equalsIgnoreCase(programmingLanguage)) continue;
            return true;
        }
        return false;
    }

    public static Developer findChair(List developers) {
        if (developers == null || developers.isEmpty()) {
            return null;
        }
        Iterator it = developers.iterator();
        while (it.hasNext()) {
            Developer developer = (Developer)it.next();
            List roles = developer.getRoles();
            Iterator it2 = roles.iterator();
            while (it2.hasNext()) {
                String role = (String)it2.next();
                if (role.toLowerCase().indexOf("chair") == -1) continue;
                return developer;
            }
        }
        return null;
    }

    public static List findPMCMembers(List developers) {
        if (developers == null || developers.isEmpty()) {
            return null;
        }
        ArrayList<Developer> pmc = new ArrayList<Developer>();
        Iterator it = developers.iterator();
        while (it.hasNext()) {
            Developer developer = (Developer)it.next();
            List roles = developer.getRoles();
            Iterator it2 = roles.iterator();
            while (it2.hasNext()) {
                String role = (String)it2.next();
                if (role.toLowerCase().indexOf("pmc") == -1) continue;
                pmc.add(developer);
            }
        }
        return pmc;
    }

    public void setModelEncoding(String modelEncoding) {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding() {
        return this.modelEncoding;
    }
}

