/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.doap;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.apache.maven.plugins:maven-doap-plugin:1.1", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven DOAP Plugin", 0);
        this.append(sb, "Plugins which generate a DOAP file from information in a POM.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 2 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "generate".equals(this.goal)) {
            this.append(sb, "doap:generate", 0);
            this.append(sb, "Generate a Description of a Project (DOAP) file from the main information found in a POM.\nNote: The generated file is tailored for use by projects at Apache.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "about (Default: ${project.url})", 2);
                this.append(sb, "The about URI-reference which should be displayed in the DOAP file. Example:\n<rdf:RDF>\n\u00a0\u00a0<Project\u00a0rdf:about='http://maven.apache.org/'>\n\u00a0\u00a0...\n\u00a0\u00a0</Project>\n</rdf:RDF>\nSee http://www.w3.org/TR/1999/REC-rdf-syntax-19990222/#aboutAttr\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "artifact", 2);
                this.append(sb, "An artifact to generate the DOAP file against.\nExample:\n<artifact>\n\u00a0\u00a0<groupId>given-artifact-groupId</groupId>\n\u00a0\u00a0<artifactId>given-artifact-artifactId</artifactId>\n\u00a0\u00a0<version>given-artifact-version</version>\n</artifact>\n\nSee Javadoc\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "asfExtOptions", 2);
                this.append(sb, "Specific ASF extensions parameters, i.e. options that POM doesn't have any notions but required by ASF DOAP requirements.\nExample:\n<asfExtOptions>\n\u00a0\u00a0<included>true</included>\n\u00a0\u00a0<charter>The\u00a0mission\u00a0of\u00a0the\u00a0Apache\u00a0XXX\u00a0project\u00a0is\u00a0to\u00a0create\u00a0and\u00a0maintain\u00a0software\n\u00a0\u00a0libraries\u00a0that\u00a0provide\u00a0...</charter>\n\u00a0\u00a0...\n</asfExtOptions>\nNote: By default, <asfExtOptions><included/></asfExtOptions> will be automatically set to true if the project is hosted at ASF.\nSee Javadoc\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "category", 2);
                this.append(sb, "Deprecated. Since 1.0. Instead of, configure <doapOptions><category/></doapOptions> parameter.", 3);
                this.append(sb, "", 0);
                this.append(sb, "The category which should be displayed in the DOAP file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "doapFile (Default: doap_${project.artifactId}.rdf)", 2);
                this.append(sb, "The name of the DOAP file that will be generated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "doapOptions", 2);
                this.append(sb, "Specific DOAP parameters, i.e. options that POM doesn't have any notions.\nExample:\n<doapOptions>\n\u00a0\u00a0<programmingLanguage>java</programmingLanguage>\n</doapOptions>\n\nSee Javadoc\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "extOptions", 2);
                this.append(sb, "Extensions parameters.\nExample:\n<extOptions>\n\u00a0<extOption>\n\u00a0\u00a0\u00a0<xmlnsPrefix>labs</xmlnsPrefix>\n\u00a0\u00a0\u00a0<xmlnsNamespaceURI>http://labs.apache.org/doap-ext/1.0#</xmlnsNamespaceURI>\n\u00a0\u00a0\u00a0<extensions>\n\u00a0\u00a0\u00a0\u00a0<status>active</status>\n\u00a0\u00a0\u00a0</extensions>\n\u00a0</extOption>\n</extOptions>\nSee Javadoc\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "lang (Default: en)", 2);
                this.append(sb, "The value for the xml:lang attribute used by the <rdf:RDF/>, <description/> and <shortdesc/> elements.\nPOM doesn't have any notions about language.\nSee http://www.w3.org/TR/REC-xml/#sec-lang-tag\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "language", 2);
                this.append(sb, "Deprecated. Since 1.0. Instead of, configure <doapOptions><programmingLanguage/></doapOptions> parameter.", 3);
                this.append(sb, "", 0);
                this.append(sb, "The programming language which should be displayed in the DOAP file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.reporting.outputDirectory})", 2);
                this.append(sb, "The output directory of the DOAP file that will be generated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Specifies whether the DOAP generation should be skipped.", 3);
                this.append(sb, "", 0);
                this.append(sb, "validate (Default: true)", 2);
                this.append(sb, "Flag to validate the generated DOAP.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "doap:help", 0);
            this.append(sb, "Display help information on maven-doap-plugin.\nCall\n\u00a0\u00a0mvn\u00a0doap:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

