/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.doap.options;

import java.io.Serializable;
import org.codehaus.plexus.util.StringUtils;

public class DoapArtifact
implements Serializable {
    private String groupId;
    private String artifactId;
    private String version;
    private String doapFileName;

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DoapArtifact)) {
            return false;
        }
        DoapArtifact that = (DoapArtifact)other;
        boolean result = true;
        boolean bl = result && (this.getGroupId() == null ? that.getGroupId() == null : this.getGroupId().equals(that.getGroupId())) ? true : (result = false);
        boolean bl2 = result && (this.getArtifactId() == null ? that.getArtifactId() == null : this.getArtifactId().equals(that.getArtifactId())) ? true : (result = false);
        boolean bl3 = result && (this.getVersion() == null ? that.getVersion() == null : this.getVersion().equals(that.getVersion())) ? true : (result = false);
        result = result && (this.getDoapFileName() == null ? that.getDoapFileName() == null : this.getDoapFileName().equals(that.getDoapFileName()));
        return result;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getVersion() {
        return this.version;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.groupId != null ? this.groupId.hashCode() : 0);
        result = 37 * result + (this.artifactId != null ? this.artifactId.hashCode() : 0);
        result = 37 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 37 * result + (this.doapFileName != null ? this.doapFileName.hashCode() : 0);
        return result;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setDoapFileName(String doapFileName) {
        this.doapFileName = doapFileName;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("groupId = '");
        buf.append(this.getGroupId());
        buf.append("'");
        buf.append("\n");
        buf.append("artifactId = '");
        buf.append(this.getArtifactId());
        buf.append("'");
        buf.append("\n");
        buf.append("version = '");
        buf.append(this.getVersion());
        buf.append("'");
        buf.append("\n");
        buf.append("doapFileName = '");
        buf.append(this.getDoapFileName());
        buf.append("'");
        return buf.toString();
    }

    public String getDoapFileName() {
        if (StringUtils.isEmpty((String)this.doapFileName)) {
            return "doap_" + this.artifactId + ".rdf";
        }
        return this.doapFileName;
    }

    public String toConfiguration() {
        StringBuilder sb = new StringBuilder();
        sb.append("<artifact>");
        sb.append("<groupId>").append(this.groupId).append("</groupId>");
        sb.append("<artifactId>").append(this.artifactId).append("</artifactId>");
        sb.append("<version>").append(this.version).append("</version>");
        sb.append("</artifact>");
        return sb.toString();
    }
}

