/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.docck;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Prerequisites;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.docck.reports.DocumentationReporter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractCheckDocumentationMojo
extends AbstractMojo {
    private List reactorProjects;
    private File output;
    protected String siteDirectory;
    private boolean offline;
    private Settings settings;
    private HttpClient httpClient;
    private FileSetManager fileSetManager = new FileSetManager();
    private List validUrls = new ArrayList();

    protected AbstractCheckDocumentationMojo() {
        this.httpClient = new HttpClient();
        this.httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(5000);
    }

    protected List getReactorProjects() {
        return this.reactorProjects;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.setupProxy();
        if (this.output != null) {
            this.getLog().info((CharSequence)("Writing documentation survey results to: " + this.output));
        }
        LinkedHashMap<MavenProject, DocumentationReporter> reporters = new LinkedHashMap<MavenProject, DocumentationReporter>();
        boolean hasErrors = false;
        Iterator it = this.reactorProjects.iterator();
        while (it.hasNext()) {
            MavenProject project = (MavenProject)it.next();
            if (this.approveProjectPackaging(project.getPackaging())) {
                this.getLog().info((CharSequence)("Checking project: " + project.getName()));
                DocumentationReporter reporter = new DocumentationReporter();
                this.checkProject(project, reporter);
                if (!hasErrors && reporter.hasErrors()) {
                    hasErrors = true;
                }
                reporters.put(project, reporter);
                continue;
            }
            this.getLog().info((CharSequence)("Skipping unsupported project: " + project.getName()));
        }
        String messages = this.buildErrorMessages(reporters);
        if (!hasErrors) {
            messages = messages + "\nNo documentation errors were found.";
        }
        try {
            this.writeMessages(messages);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error writing results to output file: " + this.output);
        }
        if (hasErrors) {
            String logLocation = this.output == null ? "Please see the console output above for more information." : "Please see '" + this.output + "' for more information.";
            throw new MojoFailureException((Object)"documentation check", "Documentation errors were found.", logLocation);
        }
    }

    private void setupProxy() {
        Proxy settingsProxy = this.settings.getActiveProxy();
        if (settingsProxy != null) {
            String proxyUsername = settingsProxy.getUsername();
            String proxyPassword = settingsProxy.getPassword();
            String proxyHost = settingsProxy.getHost();
            int proxyPort = settingsProxy.getPort();
            if (StringUtils.isNotEmpty((String)proxyHost)) {
                this.httpClient.getHostConfiguration().setProxy(proxyHost, proxyPort);
                this.getLog().info((CharSequence)("Using proxy[" + proxyHost + "] at port [" + proxyPort + "]."));
                if (StringUtils.isNotEmpty((String)proxyUsername)) {
                    this.getLog().info((CharSequence)("Using proxy user[" + proxyUsername + "]."));
                    UsernamePasswordCredentials creds = new UsernamePasswordCredentials(proxyUsername, proxyPassword);
                    this.httpClient.getState().setProxyCredentials(new AuthScope(proxyHost, proxyPort), (Credentials)creds);
                    this.httpClient.getParams().setAuthenticationPreemptive(true);
                }
            }
        }
    }

    private String buildErrorMessages(Map reporters) {
        String messages = "";
        StringBuffer buffer = new StringBuffer();
        Iterator it = reporters.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            MavenProject project = (MavenProject)entry.getKey();
            DocumentationReporter reporter = (DocumentationReporter)entry.getValue();
            if (reporter.getMessages().isEmpty()) continue;
            buffer.append("\no ").append(project.getName());
            buffer.append(" (").append(reporter.getMessagesByType(3).size()).append(" errors,");
            buffer.append(" ").append(reporter.getMessagesByType(2).size()).append(" warnings)");
            Iterator errorIterator = reporter.getMessages().iterator();
            while (errorIterator.hasNext()) {
                String error = (String)errorIterator.next();
                buffer.append("\n\t").append(error);
            }
            buffer.append("\n");
        }
        if (buffer.length() > 0) {
            messages = "\nThe following documentation problems were found:\n" + buffer.toString();
        }
        return messages;
    }

    protected abstract boolean approveProjectPackaging(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMessages(String messages) throws IOException {
        block3: {
            block2: {
                if (this.output == null) break block2;
                FileWriter writer = null;
                try {
                    writer = new FileWriter(this.output);
                    writer.write(messages);
                    writer.flush();
                }
                catch (Throwable throwable) {
                    IOUtil.close(writer);
                    throw throwable;
                }
                IOUtil.close((Writer)writer);
                break block3;
            }
            this.getLog().info((CharSequence)messages);
        }
    }

    private void checkProject(MavenProject project, DocumentationReporter reporter) {
        this.checkPomRequirements(project, reporter);
        this.checkPackagingSpecificDocumentation(project, reporter);
    }

    private void checkPomRequirements(MavenProject project, DocumentationReporter reporter) {
        this.checkProjectLicenses(project, reporter);
        if (StringUtils.isEmpty((String)project.getName())) {
            reporter.error("Missing tag <name>.");
        }
        if (StringUtils.isEmpty((String)project.getDescription())) {
            reporter.error("Missing tag <description>.");
        }
        if (StringUtils.isEmpty((String)project.getUrl())) {
            reporter.error("Missing tag <url>.");
        } else {
            this.checkURL(project.getUrl(), "project site", reporter);
        }
        if (project.getIssueManagement() == null) {
            reporter.error("Missing tag <issueManagement>.");
        } else {
            IssueManagement issueMngt = project.getIssueManagement();
            if (StringUtils.isEmpty((String)issueMngt.getUrl())) {
                reporter.error("Missing <url> tag in <issueManagement>.");
            } else {
                this.checkURL(issueMngt.getUrl(), "Issue Management", reporter);
            }
        }
        if (project.getPrerequisites() == null) {
            reporter.error("Missing tag <prerequisites>");
        } else {
            Prerequisites prereq = project.getPrerequisites();
            if (StringUtils.isEmpty((String)prereq.getMaven())) {
                reporter.error("Missing <maven> tag in <prerequisites>");
            }
        }
        if (StringUtils.isEmpty((String)project.getInceptionYear())) {
            reporter.error("Missing tag <inceptionYear>");
        }
        if (project.getMailingLists().size() == 0) {
            reporter.warn("No <mailingList> specified");
        }
        if (project.getScm() == null) {
            reporter.warn("Missing tag <scm>");
        } else {
            Scm scm = project.getScm();
            if (StringUtils.isEmpty((String)scm.getConnection()) && StringUtils.isEmpty((String)scm.getDeveloperConnection()) && StringUtils.isEmpty((String)scm.getUrl())) {
                reporter.warn("Missing children under the <scm> tag ");
            } else if (scm.getUrl() != null) {
                this.checkURL(scm.getUrl(), "scm", reporter);
            }
        }
        if (project.getOrganization() == null) {
            reporter.error("Missing tag <organization>");
        } else {
            Organization org = project.getOrganization();
            if (StringUtils.isEmpty((String)org.getName())) {
                reporter.error("Missing <name> tag in <organization>");
            } else if (org.getUrl() != null) {
                this.checkURL(org.getUrl(), org.getName() + " site", reporter);
            }
        }
    }

    private void checkProjectLicenses(MavenProject project, DocumentationReporter reporter) {
        List licenses = project.getLicenses();
        if (licenses == null || licenses.isEmpty()) {
            reporter.error("No license(s) specified.");
        } else {
            Iterator it = licenses.iterator();
            while (it.hasNext()) {
                License license = (License)it.next();
                if (StringUtils.isEmpty((String)license.getName())) {
                    reporter.error("Missing <name> tag in <license>");
                    continue;
                }
                String url = license.getUrl();
                if (StringUtils.isEmpty((String)url)) {
                    reporter.error("No license URL provided for license " + license.getName());
                    continue;
                }
                this.checkURL(url, "license " + license.getName(), reporter);
            }
        }
    }

    private String getURLProtocol(String url) throws MalformedURLException {
        URL licenseUrl = new URL(url);
        String protocol = licenseUrl.getProtocol();
        if (protocol != null) {
            protocol = protocol.toLowerCase();
        }
        return protocol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkURL(String url, String description, DocumentationReporter reporter) {
        block13: {
            try {
                String protocol = this.getURLProtocol(url);
                if (protocol.startsWith("http")) {
                    if (this.offline) {
                        reporter.warn("Cannot verify " + description + " in offline mode with URL: '" + url + "'.");
                        break block13;
                    }
                    if (this.validUrls.contains(url)) break block13;
                    HeadMethod headMethod = new HeadMethod(url);
                    headMethod.setFollowRedirects(true);
                    headMethod.setDoAuthentication(false);
                    try {
                        this.getLog().debug((CharSequence)("Verifying http url: " + url));
                        if (this.httpClient.executeMethod((HttpMethod)headMethod) != 200) {
                            reporter.error("Cannot reach " + description + " with URL: '" + url + "'.");
                        } else {
                            this.validUrls.add(url);
                        }
                        break block13;
                    }
                    catch (HttpException e) {
                        reporter.error("Cannot reach " + description + " with URL: '" + url + "'.\nError: " + e.getMessage());
                        break block13;
                    }
                    catch (IOException e) {
                        reporter.error("Cannot reach " + description + " with URL: '" + url + "'.\nError: " + e.getMessage());
                        break block13;
                    }
                    finally {
                        headMethod.releaseConnection();
                    }
                }
                reporter.warn("Non-HTTP " + description + " URL not verified.");
            }
            catch (MalformedURLException e) {
                reporter.warn(description + " appears to have an invalid URL: '" + url + "'.\nError: " + e.getMessage() + "\n\nTrying to access it as a file instead.");
                this.checkFile(url, description, reporter);
            }
        }
    }

    private void checkFile(String url, String description, DocumentationReporter reporter) {
        File licenseFile = new File(url);
        if (!licenseFile.exists()) {
            reporter.error(description + " file: '" + licenseFile.getPath() + " does not exist.");
        }
    }

    protected abstract void checkPackagingSpecificDocumentation(MavenProject var1, DocumentationReporter var2);

    protected boolean findFiles(File siteDirectory, String pattern) {
        FileSet fs = new FileSet();
        fs.setDirectory(siteDirectory.getAbsolutePath());
        fs.setFollowSymlinks(false);
        fs.addInclude("apt/" + pattern + ".apt");
        fs.addInclude("xdoc/" + pattern + ".xml");
        fs.addInclude("fml/" + pattern + ".fml");
        fs.addInclude("resources/" + pattern + ".html");
        String[] includedFiles = this.fileSetManager.getIncludedFiles(fs);
        return includedFiles != null && includedFiles.length > 0;
    }
}

