/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.docck;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.plugin.descriptor.InvalidPluginDescriptorException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.docck.AbstractCheckDocumentationMojo;
import org.apache.maven.plugin.docck.reports.DocumentationReporter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.tools.plugin.extractor.ExtractionException;
import org.apache.maven.tools.plugin.scanner.MojoScanner;
import org.codehaus.plexus.util.FileUtils;

public class CheckPluginDocumentationMojo
extends AbstractCheckDocumentationMojo {
    protected MojoScanner mojoScanner;
    private static final int MIN_DESCRIPTION_LENGTH = 1;

    protected void checkPackagingSpecificDocumentation(MavenProject project, DocumentationReporter reporter) {
        List mojos;
        PluginDescriptor descriptor = new PluginDescriptor();
        try {
            this.mojoScanner.populatePluginDescriptor(project, descriptor);
        }
        catch (InvalidPluginDescriptorException e) {
            reporter.error("Failed to parse mojo descriptors.\nError: " + e.getMessage());
            descriptor = null;
        }
        catch (ExtractionException e) {
            reporter.error("Failed to parse mojo descriptors.\nError: " + e.getMessage());
            descriptor = null;
        }
        if (descriptor != null && (mojos = descriptor.getMojos()) != null && !mojos.isEmpty()) {
            Iterator it = mojos.iterator();
            while (it.hasNext()) {
                List params;
                MojoDescriptor mojo = (MojoDescriptor)it.next();
                String mojoDescription = mojo.getDescription();
                if (mojoDescription == null || mojoDescription.trim().length() < 1) {
                    reporter.error("Mojo: '" + mojo.getGoal() + "' is missing a description.");
                }
                if ((params = mojo.getParameters()) == null || params.isEmpty()) continue;
                Iterator paramIterator = params.iterator();
                while (paramIterator.hasNext()) {
                    String paramDescription;
                    Parameter param = (Parameter)paramIterator.next();
                    if (param.getRequirement() != null || !param.isEditable() || (paramDescription = param.getDescription()) != null && paramDescription.trim().length() >= 1) continue;
                    reporter.error("Parameter: '" + param.getName() + "' in mojo: '" + mojo.getGoal() + "' is missing a description.");
                }
            }
        }
        this.checkConfiguredReportPlugins(project, reporter);
        this.checkProjectSite(project, reporter);
    }

    protected boolean approveProjectPackaging(String packaging) {
        return "maven-plugin".equals(packaging);
    }

    private void checkProjectSite(MavenProject project, DocumentationReporter reporter) {
        File projectSiteDirectory = new File(project.getBasedir(), this.siteDirectory);
        File siteXml = new File(projectSiteDirectory, "site.xml");
        if (!siteXml.exists()) {
            reporter.error("site.xml is missing.");
        } else {
            try {
                String siteHtml = FileUtils.fileRead((String)siteXml.getAbsolutePath());
                if (siteHtml.indexOf("href=\"index.html\"") < 0) {
                    reporter.error("site.xml is missing the link to: index.html \"Introduction\".");
                }
                if (siteHtml.indexOf("href=\"usage.html\"") < 0) {
                    reporter.error("site.xml is missing the link to: usage.html \"Usage\".");
                }
                if (siteHtml.indexOf("href=\"plugin-info.html\"") < 0) {
                    reporter.error("site.xml is missing the link to: plugin-info.html \"Goals\".");
                }
                if (siteHtml.indexOf("href=\"faq.html\"") < 0) {
                    reporter.error("site.xml is missing the link to: faq.html \"FAQ\".");
                }
            }
            catch (IOException e) {
                reporter.error("Unable to read site.xml file: '" + siteXml.getAbsolutePath() + "'.\nError: " + e.getMessage());
            }
        }
        if (!this.findFiles(projectSiteDirectory, "index")) {
            reporter.error("There is no 'index' file in your site directory (in apt|html|xml format).");
        }
        if (!this.findFiles(projectSiteDirectory, "usage")) {
            reporter.error("There is no 'usage' file in your site directory (in apt|html|xml format).");
        }
        if (!this.findFiles(projectSiteDirectory, "**/examples/*") && !this.findFiles(projectSiteDirectory, "**/example*")) {
            reporter.error("There are no example files in your site directory (in apt|html|xml format). They should either be called 'example*.(apt|html|xml)' or they should be located in the 'examples' directory.");
        }
        if (!this.findFiles(projectSiteDirectory, "faq")) {
            reporter.error("There is no 'faq' file in your site directory (in apt|fml|html|xml format).");
        }
    }

    private void checkConfiguredReportPlugins(MavenProject project, DocumentationReporter reporter) {
        Iterator plugins;
        List expectedPlugins = this.getRequiredPlugins();
        List reportPlugins = project.getReportPlugins();
        if (reportPlugins != null && reportPlugins.size() > 0) {
            plugins = reportPlugins.iterator();
            while (plugins.hasNext()) {
                ReportPlugin plugin = (ReportPlugin)plugins.next();
                expectedPlugins.remove(plugin.getArtifactId());
            }
        } else {
            reporter.error("pom.xml has no report plugins configured.");
        }
        plugins = expectedPlugins.iterator();
        while (plugins.hasNext()) {
            reporter.error("pom.xml is missing the report plugin: " + plugins.next().toString() + ".");
        }
    }

    private List getRequiredPlugins() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("maven-javadoc-plugin");
        list.add("maven-jxr-plugin");
        return list;
    }
}

