/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ear.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.ear.EarModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleIdentifierValidator {
    private List<EarModule> earModules;
    private Map<String, List<EarModule>> result;

    public ModuleIdentifierValidator(List<EarModule> earModules) {
        if (earModules == null) {
            throw new IllegalArgumentException("Not allowed to give null for earModules.");
        }
        this.earModules = earModules;
        this.result = new HashMap<String, List<EarModule>>();
    }

    public boolean existDuplicateArtifacts() {
        return !this.result.isEmpty();
    }

    public ModuleIdentifierValidator checkForDuplicateArtifacts() {
        this.analyze();
        return this;
    }

    private void analyze() {
        HashMap newList = new HashMap();
        for (EarModule earModule : this.earModules) {
            String earId = earModule.getArtifact().getArtifactId() + ":" + earModule.getArtifact().getVersion();
            if (newList.containsKey(earId)) {
                ((List)newList.get(earId)).add(earModule);
                continue;
            }
            ArrayList<EarModule> list = new ArrayList<EarModule>();
            list.add(earModule);
            newList.put(earId, list);
        }
        this.result.clear();
        for (Map.Entry entry : newList.entrySet()) {
            if (((List)entry.getValue()).size() <= 1) continue;
            this.result.put((String)entry.getKey(), (List<EarModule>)entry.getValue());
        }
    }

    public Map<String, List<EarModule>> getDuplicateArtifacts() {
        return this.result;
    }

    public List<EarModule> getEarModules() {
        return this.earModules;
    }

    public ModuleIdentifierValidator setEarModules(List<EarModule> paramEarModules) {
        if (paramEarModules == null) {
            throw new IllegalArgumentException("Not allowed to give null for earModules.");
        }
        this.earModules = paramEarModules;
        return this;
    }
}

