/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ear;

import org.apache.maven.plugin.ear.EarPluginException;

class JbossConfiguration {
    static final String VERSION_3_2 = "3.2";
    static final String VERSION_4 = "4";
    static final String VERSION_4_2 = "4.2";
    static final String VERSION = "version";
    static final String SECURITY_DOMAIN = "security-domain";
    static final String UNAUHTHENTICTED_PRINCIPAL = "unauthenticated-principal";
    static final String JMX_NAME = "jmx-name";
    static final String LOADER_REPOSITORY = "loader-repository";
    static final String MODULE_ORDER = "module-order";
    private final String version;
    private boolean jbossThreeDotTwo;
    private boolean jbossFour;
    private boolean jbossFourDotTwo;
    private final String securityDomain;
    private final String unauthenticatedPrincipal;
    private final String jmxName;
    private final String loaderRepository;
    private final String moduleOrder;

    public JbossConfiguration(String version, String securityDomain, String unauthenticatedPrincipal, String jmxName, String loaderRepository, String moduleOrder) throws EarPluginException {
        if (version == null) {
            throw new EarPluginException("jboss version could not be null.");
        }
        this.version = version;
        if (version.equals(VERSION_3_2)) {
            this.jbossThreeDotTwo = true;
        } else if (version.equals(VERSION_4)) {
            this.jbossFour = true;
        } else if (version.equals(VERSION_4_2)) {
            this.jbossFourDotTwo = true;
        } else {
            throw new EarPluginException("Invalid JBoss configuration, version[" + version + "] is not supported.");
        }
        this.securityDomain = securityDomain;
        this.unauthenticatedPrincipal = unauthenticatedPrincipal;
        this.jmxName = jmxName;
        this.loaderRepository = loaderRepository;
        this.moduleOrder = moduleOrder;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isJbossThreeDotTwo() {
        return this.jbossThreeDotTwo;
    }

    public boolean isJbossFour() {
        return this.jbossFour;
    }

    public boolean isJbossFourDotTwo() {
        return this.jbossFourDotTwo;
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public String getUnauthenticatedPrincipal() {
        return this.unauthenticatedPrincipal;
    }

    public String getJmxName() {
        return this.jmxName;
    }

    public String getLoaderRepository() {
        return this.loaderRepository;
    }

    public String getModuleOrder() {
        return this.moduleOrder;
    }
}

