/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ear;

import java.io.Writer;
import java.util.Iterator;
import org.apache.maven.plugin.ear.AbstractXmlWriter;
import org.apache.maven.plugin.ear.ApplicationXmlWriterContext;
import org.apache.maven.plugin.ear.EarModule;
import org.apache.maven.plugin.ear.EarPluginException;
import org.apache.maven.plugin.ear.SecurityRole;
import org.codehaus.plexus.util.xml.XMLWriter;

final class ApplicationXmlWriter
extends AbstractXmlWriter {
    public static final String DOCTYPE_1_3 = "application PUBLIC\n\t\"-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN\"\n\t\"http://java.sun.com/dtd/application_1_3.dtd\"";
    private static final String APPLICATION_ELEMENT = "application";
    private final String version;

    ApplicationXmlWriter(String version, String encoding) {
        super(encoding);
        this.version = version;
    }

    public void write(ApplicationXmlWriterContext context) throws EarPluginException {
        Writer w = this.initializeWriter(context.getDestinationFile());
        XMLWriter writer = null;
        if ("1.3".equals(this.version)) {
            writer = this.initializeRootElementOneDotThree(w);
            this.writeDisplayName(context.getDisplayName(), writer);
            this.writeDescription(context.getDescription(), writer);
        } else if ("1.4".equals(this.version)) {
            writer = this.initializeRootElementOneDotFour(w);
            this.writeDescription(context.getDescription(), writer);
            this.writeDisplayName(context.getDisplayName(), writer);
        } else if ("5".equals(this.version)) {
            writer = this.initializeRootElementFive(w);
            this.writeDescription(context.getDescription(), writer);
            this.writeDisplayName(context.getDisplayName(), writer);
        }
        Iterator moduleIt = context.getEarModules().iterator();
        while (moduleIt.hasNext()) {
            EarModule module = (EarModule)moduleIt.next();
            module.appendModule(writer, this.version);
        }
        Iterator securityRoleIt = context.getSecurityRoles().iterator();
        while (securityRoleIt.hasNext()) {
            SecurityRole securityRole = (SecurityRole)securityRoleIt.next();
            securityRole.appendSecurityRole(writer);
        }
        if ("5".equals(this.version)) {
            this.writeLibraryDirectory(context.getLibraryDirectory(), writer);
        }
        writer.endElement();
        this.close(w);
    }

    private void writeDescription(String description, XMLWriter writer) {
        if (description != null) {
            writer.startElement("description");
            writer.writeText(description);
            writer.endElement();
        }
    }

    private void writeDisplayName(String displayName, XMLWriter writer) {
        if (displayName != null) {
            writer.startElement("display-name");
            writer.writeText(displayName);
            writer.endElement();
        }
    }

    private void writeLibraryDirectory(String libraryDirectory, XMLWriter writer) {
        if (libraryDirectory != null) {
            writer.startElement("library-directory");
            writer.writeText(libraryDirectory);
            writer.endElement();
        }
    }

    private XMLWriter initializeRootElementOneDotThree(Writer w) {
        XMLWriter writer = this.initializeXmlWriter(w, DOCTYPE_1_3);
        writer.startElement(APPLICATION_ELEMENT);
        return writer;
    }

    private XMLWriter initializeRootElementOneDotFour(Writer w) {
        XMLWriter writer = this.initializeXmlWriter(w, null);
        writer.startElement(APPLICATION_ELEMENT);
        writer.addAttribute("xmlns", "http://java.sun.com/xml/ns/j2ee");
        writer.addAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        writer.addAttribute("xsi:schemaLocation", "http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/application_1_4.xsd");
        writer.addAttribute("version", "1.4");
        return writer;
    }

    private XMLWriter initializeRootElementFive(Writer w) {
        XMLWriter writer = this.initializeXmlWriter(w, null);
        writer.startElement(APPLICATION_ELEMENT);
        writer.addAttribute("xmlns", "http://java.sun.com/xml/ns/javaee");
        writer.addAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        writer.addAttribute("xsi:schemaLocation", "http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/application_5.xsd");
        writer.addAttribute("version", "5");
        return writer;
    }
}

