/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ear;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.ear.EarModule;
import org.apache.maven.plugin.ear.Ejb3Module;
import org.apache.maven.plugin.ear.EjbClientModule;
import org.apache.maven.plugin.ear.EjbModule;
import org.apache.maven.plugin.ear.HarModule;
import org.apache.maven.plugin.ear.JarModule;
import org.apache.maven.plugin.ear.ParModule;
import org.apache.maven.plugin.ear.RarModule;
import org.apache.maven.plugin.ear.SarModule;
import org.apache.maven.plugin.ear.UnknownArtifactTypeException;
import org.apache.maven.plugin.ear.WebModule;
import org.apache.maven.plugin.ear.WsrModule;
import org.apache.maven.plugin.ear.util.ArtifactTypeMappingService;

public final class EarModuleFactory {
    public static final List standardArtifactTypes = new ArrayList();

    public static EarModule newEarModule(Artifact artifact, String defaultLibBundleDir, Boolean includeInApplicationXml) throws UnknownArtifactTypeException {
        String artifactType = ArtifactTypeMappingService.getInstance().getStandardType(artifact.getType());
        if ("jar".equals(artifactType)) {
            return new JarModule(artifact, defaultLibBundleDir, includeInApplicationXml);
        }
        if ("ejb".equals(artifactType)) {
            return new EjbModule(artifact);
        }
        if ("ejb3".equals(artifactType)) {
            return new Ejb3Module(artifact);
        }
        if ("par".equals(artifactType)) {
            return new ParModule(artifact);
        }
        if ("ejb-client".equals(artifactType)) {
            return new EjbClientModule(artifact, null);
        }
        if ("rar".equals(artifactType)) {
            return new RarModule(artifact);
        }
        if ("war".equals(artifactType)) {
            return new WebModule(artifact);
        }
        if ("sar".equals(artifactType)) {
            return new SarModule(artifact);
        }
        if ("wsr".equals(artifactType)) {
            return new WsrModule(artifact);
        }
        if ("har".equals(artifactType)) {
            return new HarModule(artifact);
        }
        throw new IllegalStateException("Could not handle artifact type[" + artifactType + "]");
    }

    public static List getStandardArtifactTypes() {
        return standardArtifactTypes;
    }

    public static boolean isStandardArtifactType(String type) {
        return standardArtifactTypes.contains(type);
    }

    static {
        standardArtifactTypes.add("jar");
        standardArtifactTypes.add("ejb");
        standardArtifactTypes.add("ejb3");
        standardArtifactTypes.add("par");
        standardArtifactTypes.add("ejb-client");
        standardArtifactTypes.add("rar");
        standardArtifactTypes.add("war");
        standardArtifactTypes.add("sar");
        standardArtifactTypes.add("wsr");
        standardArtifactTypes.add("har");
    }
}

