/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ide;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.ide.IdeDependency;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class IdeUtils {
    public static final String JAVA_1_1 = "1.1";
    public static final String JAVA_1_2 = "1.2";
    public static final String JAVA_1_3 = "1.3";
    public static final String JAVA_1_4 = "1.4";
    public static final String JAVA_5_0 = "5.0";
    public static final String JAVA_6_0 = "6.0";
    public static final String PROJECT_NAME_DEFAULT_TEMPLATE = "[artifactId]";
    public static final String PROJECT_NAME_WITH_VERSION_TEMPLATE = "[artifactId]-[version]";
    public static final String PROJECT_NAME_WITH_GROUP_TEMPLATE = "[groupId].[artifactId]";
    public static final String PROJECT_NAME_WITH_GROUP_AND_VERSION_TEMPLATE = "[groupId].[artifactId]-[version]";
    private static final String ARTIFACT_MAVEN_COMPILER_PLUGIN = "maven-compiler-plugin";
    private static final String PROPERTY_SOURCE = "source";
    private static final String PROPERTY_ENCODING = "encoding";
    private static final String PROPERTY_TARGET = "target";
    public static final String NOT_AVAILABLE_MARKER_FILE_SUFFIX = "-not-available";

    public static void delete(File f, Log log) throws MojoExecutionException {
        if (f.isDirectory()) {
            log.info((CharSequence)Messages.getString("EclipseCleanMojo.deletingDirectory", f.getName()));
        } else {
            log.info((CharSequence)Messages.getString("EclipseCleanMojo.deletingFile", f.getName()));
        }
        if (f.exists()) {
            if (!f.delete()) {
                try {
                    FileUtils.forceDelete((File)f);
                }
                catch (IOException e) {
                    throw new MojoExecutionException(Messages.getString("EclipseCleanMojo.failedtodelete", new Object[]{f.getName(), f.getAbsolutePath()}));
                }
            }
        } else {
            log.debug((CharSequence)Messages.getString("EclipseCleanMojo.nofilefound", f.getName()));
        }
    }

    public static String getCanonicalPath(File file) throws MojoExecutionException {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new MojoExecutionException(Messages.getString("EclipsePlugin.cantcanonicalize", file.getAbsolutePath()), (Exception)e);
        }
    }

    public static String getCompilerPluginSetting(MavenProject project, String optionName) {
        String value = IdeUtils.findCompilerPluginSettingInPlugins(project.getModel().getBuild().getPlugins(), optionName);
        if (value == null && project.getModel().getBuild().getPluginManagement() != null) {
            value = IdeUtils.findCompilerPluginSettingInPlugins(project.getModel().getBuild().getPluginManagement().getPlugins(), optionName);
        }
        return value;
    }

    public static String getCompilerSourceVersion(MavenProject project) {
        return IdeUtils.getCompilerPluginSetting(project, PROPERTY_SOURCE);
    }

    public static String getCompilerSourceEncoding(MavenProject project) {
        String value = IdeUtils.getCompilerPluginSetting(project, PROPERTY_ENCODING);
        if (value == null) {
            project.getProperties().getProperty("project.build.sourceEncoding");
        }
        return value;
    }

    public static String getCompilerTargetVersion(MavenProject project) {
        return IdeUtils.getCompilerPluginSetting(project, PROPERTY_TARGET);
    }

    public static String getArtifactVersion(String[] artifactIds, List dependencies, int len) {
        String version = null;
        ArtifactVersion artifactVersion = IdeUtils.getArtifactVersion(artifactIds, dependencies);
        if (artifactVersion != null) {
            StringBuffer versionBuffer = new StringBuffer();
            if (len >= 1) {
                versionBuffer.append(artifactVersion.getMajorVersion());
            }
            if (len >= 2) {
                versionBuffer.append('.');
            }
            if (len >= 3) {
                versionBuffer.append(artifactVersion.getMinorVersion());
            }
            if (len >= 4) {
                versionBuffer.append('.');
            }
            if (len >= 5) {
                versionBuffer.append(artifactVersion.getIncrementalVersion());
            }
            version = versionBuffer.toString();
        }
        return version;
    }

    public static ArtifactVersion getArtifactVersion(String[] artifactIds, List dependencies) {
        for (int j = 0; j < artifactIds.length; ++j) {
            String id = artifactIds[j];
            for (Dependency dep : dependencies) {
                if (!id.equals(dep.getArtifactId())) continue;
                return VersionRange.createFromVersion((String)dep.getVersion()).getRecommendedVersion();
            }
        }
        return null;
    }

    public static String getPluginSetting(MavenProject project, String pluginId, String optionName, String defaultValue) {
        Xpp3Dom dom = IdeUtils.getPluginConfigurationDom(project, pluginId);
        if (dom != null && dom.getChild(optionName) != null) {
            return dom.getChild(optionName).getValue();
        }
        return defaultValue;
    }

    public static Xpp3Dom getPluginConfigurationDom(MavenProject project, String pluginId) {
        Plugin plugin = (Plugin)project.getBuild().getPluginsAsMap().get(pluginId);
        if (plugin != null) {
            return (Xpp3Dom)plugin.getConfiguration();
        }
        return null;
    }

    public static Xpp3Dom[] getPluginConfigurationDom(MavenProject project, String artifactId, String[] subConfiguration) {
        ArrayList<Xpp3Dom> configurationDomList = new ArrayList<Xpp3Dom>();
        Xpp3Dom configuration = IdeUtils.getPluginConfigurationDom(project, artifactId);
        if (configuration != null) {
            configurationDomList.add(configuration);
            for (int index = 0; !configurationDomList.isEmpty() && subConfiguration != null && index < subConfiguration.length; ++index) {
                ArrayList<Xpp3Dom> newConfigurationDomList = new ArrayList<Xpp3Dom>();
                for (Xpp3Dom child : configurationDomList) {
                    Xpp3Dom[] deeperChild = child.getChildren(subConfiguration[index]);
                    for (int deeperIndex = 0; deeperIndex < deeperChild.length; ++deeperIndex) {
                        if (deeperChild[deeperIndex] == null) continue;
                        newConfigurationDomList.add(deeperChild[deeperIndex]);
                    }
                }
                configurationDomList = newConfigurationDomList;
            }
        }
        return configurationDomList.toArray(new Xpp3Dom[configurationDomList.size()]);
    }

    public static String calculateProjectNameTemplate(String projectNameTemplate, boolean addVersionToProjectName, boolean addGroupIdToProjectName, Log log) {
        if (projectNameTemplate != null) {
            if (addVersionToProjectName || addGroupIdToProjectName) {
                log.warn((CharSequence)"projectNameTemplate definition overrides addVersionToProjectName or addGroupIdToProjectName");
            }
            return projectNameTemplate;
        }
        if (addVersionToProjectName && addGroupIdToProjectName) {
            return PROJECT_NAME_WITH_GROUP_AND_VERSION_TEMPLATE;
        }
        if (addVersionToProjectName) {
            return PROJECT_NAME_WITH_VERSION_TEMPLATE;
        }
        if (addGroupIdToProjectName) {
            return PROJECT_NAME_WITH_GROUP_TEMPLATE;
        }
        return PROJECT_NAME_DEFAULT_TEMPLATE;
    }

    protected static String getProjectName(String template, IdeDependency dep) {
        return IdeUtils.getProjectName(template, dep.getGroupId(), dep.getArtifactId(), dep.getVersion());
    }

    public static String getProjectName(String template, Artifact artifact) {
        return IdeUtils.getProjectName(template, artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
    }

    public static String getProjectName(String template, MavenProject project) {
        return IdeUtils.getProjectName(template, project.getGroupId(), project.getArtifactId(), project.getVersion());
    }

    public static String getProjectName(MavenProject project, boolean addVersionToProjectName) {
        return IdeUtils.getProjectName(addVersionToProjectName ? PROJECT_NAME_WITH_VERSION_TEMPLATE : PROJECT_NAME_DEFAULT_TEMPLATE, project);
    }

    public static File getNotAvailableMarkerFile(ArtifactRepository localRepository, Artifact artifact) {
        return new File(localRepository.getBasedir(), localRepository.pathOf(artifact) + NOT_AVAILABLE_MARKER_FILE_SUFFIX);
    }

    public static Artifact resolveArtifact(ArtifactResolver artifactResolver, Artifact artifact, List remoteRepos, ArtifactRepository localRepository, Log log) {
        try {
            artifactResolver.resolve(artifact, remoteRepos, localRepository);
        }
        catch (ArtifactNotFoundException e) {
            if (artifact.getFile() != null && artifact.getFile().isFile()) {
                artifact.setResolved(true);
            }
        }
        catch (ArtifactResolutionException e) {
            String message = Messages.getString("IdeUtils.errorresolving", new Object[]{artifact.getClassifier(), artifact.getId(), e.getMessage()});
            log.warn((CharSequence)message);
        }
        return artifact;
    }

    public static Artifact createArtifactWithClassifier(String groupId, String artifactId, String version, String depClassifier, String inClassifier, ArtifactFactory artifactFactory) {
        String type = null;
        type = "sources".equals(inClassifier) ? "java-source" : inClassifier;
        String finalClassifier = null;
        finalClassifier = depClassifier == null ? inClassifier : ("sources".equals(inClassifier) && "tests".equals(depClassifier) ? "test-sources" : depClassifier + "-" + inClassifier);
        return artifactFactory.createArtifactWithClassifier(groupId, artifactId, version, type, finalClassifier);
    }

    public static String resolveJavaVersion(MavenProject project) {
        String version = IdeUtils.getCompilerTargetVersion(project);
        if (version == null) {
            version = IdeUtils.getCompilerSourceVersion(project);
        }
        if ("1.5".equals(version)) {
            version = JAVA_5_0;
        } else if ("1.6".equals(version)) {
            version = JAVA_6_0;
        } else if (version != null && version.length() == 1) {
            version = version + ".0";
        }
        return version == null ? JAVA_1_4 : version;
    }

    public static String toRelativeAndFixSeparator(File basedir, File fileToAdd, boolean replaceSlashesWithDashes) throws MojoExecutionException {
        if (!fileToAdd.isAbsolute()) {
            fileToAdd = new File(basedir, fileToAdd.getPath());
        }
        String basedirPath = IdeUtils.getCanonicalPath(basedir);
        String absolutePath = IdeUtils.getCanonicalPath(fileToAdd);
        String relative = null;
        if (absolutePath.equals(basedirPath)) {
            relative = ".";
        } else if (absolutePath.startsWith(basedirPath)) {
            int length = basedirPath.length() + 1;
            if (basedirPath.endsWith("\\")) {
                --length;
            }
            relative = absolutePath.substring(length);
        } else {
            relative = absolutePath;
        }
        relative = IdeUtils.fixSeparator(relative);
        if (replaceSlashesWithDashes) {
            relative = StringUtils.replace((String)relative, (char)'/', (char)'-');
            relative = StringUtils.replace((String)relative, (char)':', (char)'-');
        }
        return relative;
    }

    public static String fixSeparator(String filename) {
        return StringUtils.replace((String)filename, (char)'\\', (char)'/');
    }

    public static String fixWindowsDriveURI(String input) {
        return input.replaceAll("file:([a-zA-Z]):", "file:/$1:");
    }

    private static String findCompilerPluginSettingInPlugins(List plugins, String optionName) {
        String value = null;
        for (Plugin plugin : plugins) {
            if (!plugin.getArtifactId().equals(ARTIFACT_MAVEN_COMPILER_PLUGIN)) continue;
            Xpp3Dom o = (Xpp3Dom)plugin.getConfiguration();
            if (o != null && o.getChild(optionName) != null) {
                value = o.getChild(optionName).getValue();
            }
            List executions = plugin.getExecutions();
            for (PluginExecution execution : executions) {
                o = (Xpp3Dom)execution.getConfiguration();
                if (o == null || o.getChild(optionName) == null) continue;
                value = o.getChild(optionName).getValue();
            }
        }
        return value;
    }

    private static String getProjectName(String template, String groupId, String artifactId, String version) {
        String s = template;
        s = s.replaceAll("\\[groupId\\]", groupId);
        s = s.replaceAll("\\[artifactId\\]", artifactId);
        s = s.replaceAll("\\[version\\]", version);
        return s;
    }

    private IdeUtils() {
    }
}

