/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ejb;

import java.io.File;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.jar.JarArchiver;

public class EjbMojo
extends AbstractMojo {
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    private static final String[] DEFAULT_EXCLUDES = new String[]{"**/*Bean.class", "**/*CMP.class", "**/*Session.class", "**/package.html"};
    private String basedir;
    private String outputDirectory;
    private String jarName;
    private String generateClient = Boolean.FALSE.toString();
    private MavenProject project;
    private JarArchiver jarArchiver;
    private JarArchiver clientJarArchiver;
    private MavenProjectHelper projectHelper;
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)("Building ejb " + this.jarName));
        File jarFile = new File(this.basedir, this.jarName + ".jar");
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.jarArchiver);
        archiver.setOutputFile(jarFile);
        String ejbJarXmlFile = "META-INF/ejb-jar.xml";
        try {
            archiver.getArchiver().addDirectory(new File(this.outputDirectory), DEFAULT_INCLUDES, new String[]{ejbJarXmlFile, "**/package.html"});
            archiver.getArchiver().addFile(new File(this.outputDirectory, ejbJarXmlFile), ejbJarXmlFile);
            archiver.createArchive(this.project, this.archive);
            this.project.getArtifact().setFile(jarFile);
            if (new Boolean(this.generateClient).booleanValue()) {
                this.getLog().info((CharSequence)("Building ejb client " + this.jarName + "-client"));
                File clientJarFile = new File(this.basedir, this.jarName + "-client.jar");
                MavenArchiver clientArchiver = new MavenArchiver();
                clientArchiver.setArchiver(this.clientJarArchiver);
                clientArchiver.setOutputFile(clientJarFile);
                clientArchiver.getArchiver().addDirectory(new File(this.outputDirectory), DEFAULT_INCLUDES, DEFAULT_EXCLUDES);
                clientArchiver.createArchive(this.project, this.archive);
                this.projectHelper.attachArtifact(this.project, "ejb-client", "client", clientJarFile);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error assembling EJB", e);
        }
    }
}

