/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.enforcer;

import java.util.Iterator;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.enforcer.rule.api.EnforcerRule;
import org.apache.maven.shared.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.shared.enforcer.rule.api.EnforcerRuleHelper;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;

public abstract class AbstractBanDependencies
implements EnforcerRule {
    public boolean searchTransitive = true;
    public String message = null;

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        MavenProject project = null;
        try {
            project = (MavenProject)helper.evaluate("${project}");
        }
        catch (ExpressionEvaluationException eee) {
            throw new EnforcerRuleException("Unable to retrieve the MavenProject: ", (Exception)((Object)eee));
        }
        Set dependencies = null;
        dependencies = this.searchTransitive ? project.getArtifacts() : project.getDependencyArtifacts();
        Set foundExcludes = this.checkDependencies(dependencies);
        if (!foundExcludes.isEmpty()) {
            StringBuffer buf = new StringBuffer();
            if (this.message != null) {
                buf.append(this.message + "\n");
            }
            Iterator iter = foundExcludes.iterator();
            while (iter.hasNext()) {
                buf.append("Found Banned Dependency: " + ((Artifact)iter.next()).getId() + "\n");
            }
            this.message = buf.toString();
            throw new EnforcerRuleException(this.message);
        }
    }

    protected abstract Set checkDependencies(Set var1) throws EnforcerRuleException;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String theMessage) {
        this.message = theMessage;
    }

    public boolean isSearchTransitive() {
        return this.searchTransitive;
    }

    public void setSearchTransitive(boolean theSearchTransitive) {
        this.searchTransitive = theSearchTransitive;
    }
}

