/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.enforcer;

import java.util.Iterator;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.Restriction;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.enforcer.rule.api.EnforcerRuleException;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractVersionEnforcer {
    public String version = null;
    public String message = "";

    public void enforceVersion(Log log, String variableName, String requiredVersionRange, ArtifactVersion actualVersion) throws EnforcerRuleException {
        if (StringUtils.isEmpty((String)requiredVersionRange)) {
            throw new EnforcerRuleException(variableName + " version can't be empty.");
        }
        String msg = "Detected " + variableName + " Version: " + actualVersion;
        if (actualVersion.toString().equals(requiredVersionRange)) {
            log.debug((CharSequence)(msg + " is allowed in the range " + requiredVersionRange + "."));
        } else {
            try {
                VersionRange vr = VersionRange.createFromVersionSpec((String)requiredVersionRange);
                if (!this.containsVersion(vr, actualVersion)) {
                    if (StringUtils.isEmpty((String)this.message)) {
                        this.message = msg + " is not in the allowed range " + vr + ".";
                    }
                    throw new EnforcerRuleException(this.message);
                }
                log.debug((CharSequence)(msg + " is allowed in the range " + requiredVersionRange + "."));
            }
            catch (InvalidVersionSpecificationException e) {
                throw new EnforcerRuleException("The requested " + variableName + " version " + requiredVersionRange + " is invalid.", (Exception)((Object)e));
            }
        }
    }

    public boolean containsVersion(VersionRange allowedRange, ArtifactVersion theVersion) {
        boolean matched = false;
        ArtifactVersion recommendedVersion = allowedRange.getRecommendedVersion();
        if (recommendedVersion == null) {
            Iterator i = allowedRange.getRestrictions().iterator();
            while (i.hasNext() && !matched) {
                Restriction restriction = (Restriction)i.next();
                if (!restriction.containsVersion(theVersion)) continue;
                matched = true;
            }
        } else {
            int compareTo = recommendedVersion.compareTo(theVersion);
            matched = compareTo <= 0;
        }
        return matched;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String theVersion) {
        this.version = theVersion;
    }
}

