/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.enforcer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.enforcer.AbstractBanDependencies;
import org.apache.maven.plugin.enforcer.util.EnforcerUtils;
import org.apache.maven.shared.enforcer.rule.api.EnforcerRuleException;
import org.codehaus.plexus.util.StringUtils;

public class BannedDependencies
extends AbstractBanDependencies {
    public ArrayList excludes = null;

    protected Set checkDependencies(Set theDependencies) throws EnforcerRuleException {
        return this.checkDependencies(theDependencies, this.excludes);
    }

    private Set checkDependencies(Set dependencies, List theExcludes) throws EnforcerRuleException {
        HashSet<Artifact> foundExcludes = new HashSet<Artifact>();
        Iterator iter = theExcludes.iterator();
        while (iter.hasNext()) {
            String exclude = (String)iter.next();
            String[] subStrings = exclude.split(":");
            subStrings = StringUtils.stripAll((String[])subStrings);
            Iterator DependencyIter = dependencies.iterator();
            while (DependencyIter.hasNext()) {
                Artifact artifact = (Artifact)DependencyIter.next();
                if (!this.compareDependency(subStrings, artifact)) continue;
                foundExcludes.add(artifact);
            }
        }
        return foundExcludes;
    }

    protected boolean compareDependency(String[] exclude, Artifact artifact) throws EnforcerRuleException {
        boolean result = false;
        if (exclude.length > 0) {
            boolean bl = result = exclude[0].equals("*") || artifact.getGroupId().equals(exclude[0]);
        }
        if (result && exclude.length > 1) {
            boolean bl = result = exclude[1].equals("*") || artifact.getArtifactId().equals(exclude[1]);
        }
        if (result && exclude.length > 2) {
            if (exclude[2].equals("*") || artifact.getVersion().equals(exclude[2])) {
                result = true;
            } else {
                try {
                    result = EnforcerUtils.containsVersion(VersionRange.createFromVersionSpec((String)exclude[2]), (ArtifactVersion)new DefaultArtifactVersion(artifact.getVersion()));
                }
                catch (InvalidVersionSpecificationException e) {
                    throw new EnforcerRuleException("Invalid Version Range: ", (Exception)((Object)e));
                }
            }
        }
        return result;
    }

    public ArrayList getExcludes() {
        return this.excludes;
    }

    public void setExcludes(ArrayList theExcludes) {
        this.excludes = theExcludes;
    }
}

