/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.enforcer;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.enforcer.DefaultEnforcementRuleHelper;
import org.apache.maven.plugin.enforcer.EnforcerExpressionEvaluator;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.path.PathTranslator;
import org.apache.maven.shared.enforcer.rule.api.EnforcerRule;
import org.apache.maven.shared.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.shared.enforcer.rule.api.EnforcerRuleHelper;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;

public class EnforceMojo
extends AbstractMojo {
    protected PathTranslator translator;
    protected MavenSession session;
    protected MavenProject project;
    protected boolean fail = true;
    protected boolean skip = false;
    protected boolean failFast = false;
    private EnforcerRule[] rules;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws MojoExecutionException {
        Log log = this.getLog();
        EnforcerExpressionEvaluator evaluator = new EnforcerExpressionEvaluator(this.session, this.translator, this.project);
        if (!this.skip) {
            ArrayList<String> list = new ArrayList<String>();
            if (this.rules == null || this.rules.length <= 0) throw new MojoExecutionException("No rules are configured. Use the skip flag if you want to disable execution.");
            String currentRule = "Unknown";
            DefaultEnforcementRuleHelper helper = new DefaultEnforcementRuleHelper(this.session, (ExpressionEvaluator)evaluator, log);
            if (!this.fail) {
                this.failFast = false;
            }
            for (int i = 0; i < this.rules.length; ++i) {
                EnforcerRule rule = this.rules[i];
                if (rule == null) continue;
                currentRule = rule.getClass().getName();
                log.debug((CharSequence)("Executing rule: " + currentRule));
                try {
                    this.rules[i].execute((EnforcerRuleHelper)helper);
                    continue;
                }
                catch (EnforcerRuleException e) {
                    if (this.failFast) {
                        throw new MojoExecutionException(currentRule + " failed with message: " + e.getMessage(), (Exception)((Object)e));
                    }
                    list.add("Rule " + i + ": " + currentRule + " failed with message: " + e.getMessage());
                }
            }
            if (list.isEmpty()) return;
            Iterator iter = ((AbstractList)list).iterator();
            while (iter.hasNext()) {
                String failure = (String)iter.next();
                log.warn((CharSequence)failure);
            }
            if (!this.fail) return;
            throw new MojoExecutionException("Some Enforcer rules have failed. Look above for specific messages explaining why the rule failed.");
        }
        log.info((CharSequence)"Skipping Rule Enforcement.");
    }

    public boolean isFail() {
        return this.fail;
    }

    public void setFail(boolean theFail) {
        this.fail = theFail;
    }

    public EnforcerRule[] getRules() {
        return this.rules;
    }

    public void setRules(EnforcerRule[] theRules) {
        this.rules = theRules;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean theSkip) {
        this.skip = theSkip;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public void setFailFast(boolean theFailFast) {
        this.failFast = theFailFast;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject theProject) {
        this.project = theProject;
    }

    public MavenSession getSession() {
        return this.session;
    }

    public void setSession(MavenSession theSession) {
        this.session = theSession;
    }

    public PathTranslator getTranslator() {
        return this.translator;
    }

    public void setTranslator(PathTranslator theTranslator) {
        this.translator = theTranslator;
    }
}

