/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.enforcer;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationOS;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.profiles.activation.OperatingSystemProfileActivator;
import org.apache.maven.shared.enforcer.rule.api.EnforcerRule;
import org.apache.maven.shared.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.shared.enforcer.rule.api.EnforcerRuleHelper;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;

public class RequireOS
implements EnforcerRule {
    public String family = null;
    public String name = null;
    public String version = null;
    public String arch = null;
    public String message = "";
    public boolean display = false;
    private Set validFamilies = new HashSet();
    public static final String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
    public static final String OS_ARCH = System.getProperty("os.arch").toLowerCase(Locale.US);
    public static final String OS_VERSION = System.getProperty("os.version").toLowerCase(Locale.US);

    public RequireOS() {
        this.validFamilies.add("dos");
        this.validFamilies.add("mac");
        this.validFamilies.add("netware");
        this.validFamilies.add("os/2");
        this.validFamilies.add("tandem");
        this.validFamilies.add("unix");
        this.validFamilies.add("windows");
        this.validFamilies.add("win9x");
        this.validFamilies.add("z/os");
        this.validFamilies.add("os/400");
    }

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        this.displayOSInfo(helper.getLog(), this.display);
        if (this.allParamsEmpty()) {
            throw new EnforcerRuleException("All parameters can not be empty. You must pick at least one of (family, name, version, arch) or use -Denforcer.os.display=true to see the current OS information.");
        }
        if (this.isValidFamily(this.family)) {
            if (!this.isAllowed()) {
                if (StringUtils.isEmpty((String)this.message)) {
                    this.message = "OS Arch: " + OS_ARCH + " Family: " + this.determineOsFamily() + " Name: " + OS_NAME + " Version: " + OS_VERSION + " is not allowed by" + (this.arch != null ? " Arch=" + this.arch : "") + (this.family != null ? " Family=" + this.family : "") + (this.name != null ? " Name=" + this.name : "") + (this.version != null ? " Version=" + this.version : "");
                }
                throw new EnforcerRuleException(this.message);
            }
        } else {
            StringBuffer buffer = new StringBuffer(50);
            Iterator iter = this.validFamilies.iterator();
            while (iter.hasNext()) {
                buffer.append(iter.next());
                buffer.append(", ");
            }
            String help = StringUtils.stripEnd((String)buffer.toString().trim(), (String)".");
            throw new EnforcerRuleException("Invalid Family type used. Valid family types are: " + help);
        }
    }

    public void displayOSInfo(Log log, boolean info) {
        String string = "OS Info: Arch: " + OS_ARCH + " Family: " + this.determineOsFamily() + " Name: " + OS_NAME + " Version: " + OS_VERSION;
        if (!info) {
            log.debug((CharSequence)string);
        } else {
            log.info((CharSequence)string);
        }
    }

    public String determineOsFamily() {
        Iterator iter = this.getValidFamilies().iterator();
        while (iter.hasNext()) {
            String fam = (String)iter.next();
            if (!Os.isFamily((String)fam)) continue;
            return fam;
        }
        return null;
    }

    public boolean isAllowed() {
        OperatingSystemProfileActivator activator = new OperatingSystemProfileActivator();
        return activator.isActive(this.createProfile());
    }

    public boolean allParamsEmpty() {
        return StringUtils.isEmpty((String)this.family) && StringUtils.isEmpty((String)this.arch) && StringUtils.isEmpty((String)this.name) && StringUtils.isEmpty((String)this.version);
    }

    private Profile createProfile() {
        Profile profile = new Profile();
        profile.setActivation(this.createActivation());
        return profile;
    }

    private Activation createActivation() {
        Activation activation = new Activation();
        activation.setActiveByDefault(false);
        activation.setOs(this.createOsBean());
        return activation;
    }

    private ActivationOS createOsBean() {
        ActivationOS os = new ActivationOS();
        os.setArch(this.arch);
        os.setFamily(this.family);
        os.setName(this.name);
        os.setVersion(this.version);
        return os;
    }

    public boolean isValidFamily(String theFamily) {
        return StringUtils.isEmpty((String)(theFamily = StringUtils.stripStart((String)theFamily, (String)"!"))) || this.validFamilies.contains(theFamily);
    }

    public String getArch() {
        return this.arch;
    }

    public void setArch(String theArch) {
        this.arch = theArch;
    }

    public String getFamily() {
        return this.family;
    }

    public void setFamily(String theFamily) {
        this.family = theFamily;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String theName) {
        this.name = theName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String theVersion) {
        this.version = theVersion;
    }

    public Set getValidFamilies() {
        return this.validFamilies;
    }

    public void setValidFamilies(Set theValidFamilies) {
        this.validFamilies = theValidFamilies;
    }
}

