/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.failsafe;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.surefire.SurefireHelper;
import org.apache.maven.plugin.surefire.SurefireReportParameters;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.surefire.shade.org.apache.maven.shared.utils.ReaderFactory;
import org.apache.maven.surefire.shade.org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.surefire.shade.org.apache.maven.shared.utils.io.IOUtil;
import org.apache.maven.surefire.suite.RunResult;

@Mojo(name="verify", defaultPhase=LifecyclePhase.VERIFY, requiresProject=true, threadSafe=true)
public class VerifyMojo
extends AbstractMojo
implements SurefireReportParameters {
    @Parameter(property="skipTests")
    private boolean skipTests;
    @Parameter(property="skipITs")
    private boolean skipITs;
    @Parameter(property="maven.test.skip.exec")
    private boolean skipExec;
    @Parameter(property="maven.test.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="maven.test.failure.ignore", defaultValue="false")
    private boolean testFailureIgnore;
    @Parameter(defaultValue="${basedir}")
    private File basedir;
    @Parameter(defaultValue="${project.build.testOutputDirectory}")
    private File testClassesDirectory;
    @Parameter(defaultValue="${project.build.directory}/failsafe-reports")
    private File reportsDirectory;
    @Parameter(defaultValue="${project.build.directory}/failsafe-reports/failsafe-summary.xml", required=true)
    private File summaryFile;
    @Parameter
    private File[] summaryFiles;
    @Parameter(property="failIfNoTests")
    private Boolean failIfNoTests;
    @Parameter(property="encoding", defaultValue="${project.reporting.outputEncoding}")
    private String encoding;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.verifyParameters()) {
            RunResult summary;
            this.getLog().info((CharSequence)(StringUtils.capitalizeFirstLetter(this.getPluginName()) + " report directory: " + this.getReportsDirectory()));
            try {
                String encoding;
                if (StringUtils.isEmpty(this.encoding)) {
                    this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + ReaderFactory.FILE_ENCODING + ", i.e. build is platform dependent!"));
                    encoding = ReaderFactory.FILE_ENCODING;
                } else {
                    encoding = this.encoding;
                }
                summary = !this.summaryFile.isFile() && this.summaryFiles != null ? RunResult.noTestsRun() : this.readSummary(encoding, this.summaryFile);
                if (this.summaryFiles != null) {
                    for (File file : this.summaryFiles) {
                        summary = summary.aggregate(this.readSummary(encoding, file));
                    }
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
            SurefireHelper.reportExecution((SurefireReportParameters)this, (RunResult)summary, (Log)this.getLog());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RunResult readSummary(String encoding, File summaryFile) throws IOException {
        RunResult runResult;
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        InputStreamReader reader = null;
        try {
            fileInputStream = new FileInputStream(summaryFile);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            reader = new InputStreamReader((InputStream)bufferedInputStream, encoding);
            runResult = RunResult.fromInputStream((InputStream)bufferedInputStream, (String)encoding);
        }
        catch (Throwable throwable) {
            IOUtil.close(reader);
            IOUtil.close(bufferedInputStream);
            IOUtil.close(fileInputStream);
            throw throwable;
        }
        IOUtil.close(reader);
        IOUtil.close(bufferedInputStream);
        IOUtil.close(fileInputStream);
        return runResult;
    }

    protected boolean verifyParameters() throws MojoFailureException {
        if (this.isSkip() || this.isSkipTests() || this.isSkipITs() || this.isSkipExec()) {
            this.getLog().info((CharSequence)"Tests are skipped.");
            return false;
        }
        if (!this.getTestClassesDirectory().exists()) {
            if (this.getFailIfNoTests() != null && this.getFailIfNoTests().booleanValue()) {
                throw new MojoFailureException("No tests to run!");
            }
            this.getLog().info((CharSequence)"No tests to run.");
            return false;
        }
        return true;
    }

    protected String getPluginName() {
        return "failsafe";
    }

    protected String[] getDefaultIncludes() {
        return null;
    }

    public boolean isSkipTests() {
        return this.skipTests;
    }

    public void setSkipTests(boolean skipTests) {
        this.skipTests = skipTests;
    }

    public boolean isSkipITs() {
        return this.skipITs;
    }

    public void setSkipITs(boolean skipITs) {
        this.skipITs = skipITs;
    }

    @Deprecated
    public boolean isSkipExec() {
        return this.skipExec;
    }

    @Deprecated
    public void setSkipExec(boolean skipExec) {
        this.skipExec = skipExec;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public boolean isTestFailureIgnore() {
        return this.testFailureIgnore;
    }

    public void setTestFailureIgnore(boolean testFailureIgnore) {
        this.testFailureIgnore = testFailureIgnore;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public File getTestClassesDirectory() {
        return this.testClassesDirectory;
    }

    public void setTestClassesDirectory(File testClassesDirectory) {
        this.testClassesDirectory = testClassesDirectory;
    }

    public File getReportsDirectory() {
        return this.reportsDirectory;
    }

    public void setReportsDirectory(File reportsDirectory) {
        this.reportsDirectory = reportsDirectory;
    }

    public Boolean getFailIfNoTests() {
        return this.failIfNoTests;
    }

    public void setFailIfNoTests(Boolean failIfNoTests) {
        this.failIfNoTests = failIfNoTests;
    }
}

